/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_wcmquickstart.jobs.feedback;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.alfresco.module.org_alfresco_module_wcmquickstart.jobs.feedback.FeedbackProcessorHandlerBase;
import org.alfresco.module.org_alfresco_module_wcmquickstart.model.WebSiteModel;
import org.alfresco.module.org_alfresco_module_wcmquickstart.util.contextparser.ContextParserService;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ActionService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.PersonService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.I18NUtil;

public class ContactFeedbackProcessorHandler
extends FeedbackProcessorHandlerBase {
    private static final Log log = LogFactory.getLog(ContactFeedbackProcessorHandler.class);
    private ActionService actionService;
    private PersonService personService;
    private ContextParserService contextParserService;

    public void setActionService(ActionService actionService) {
        this.actionService = actionService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public void setContextParserService(ContextParserService contextParserService) {
        this.contextParserService = contextParserService;
    }

    @Override
    public void processFeedback(NodeRef feedback) {
        Action action = this.actionService.createAction("start-workflow");
        action.setParameterValue("workflowName", (Serializable)((Object)"activiti$readContactProcess"));
        Map<String, String> feedbackConfig = this.getFeedbackConfiguration(feedback);
        String workflowUser = null;
        if (feedbackConfig != null) {
            workflowUser = feedbackConfig.get("feedbackAssignee.Contact Request");
        }
        if (workflowUser == null) {
            workflowUser = AuthenticationUtil.getAdminUserName();
        }
        String visitorName = (String)((Object)this.nodeService.getProperty(feedback, WebSiteModel.PROP_VISITOR_NAME));
        String visitorEmail = (String)((Object)this.nodeService.getProperty(feedback, WebSiteModel.PROP_VISITOR_EMAIL));
        if (visitorName == null) {
            int indexOfAt;
            visitorName = visitorEmail == null ? I18NUtil.getMessage((String)"wcmqs.contactRequest.unknownPerson") : ((indexOfAt = visitorEmail.indexOf(64)) == -1 ? visitorEmail : visitorEmail.substring(0, indexOfAt));
        }
        NodeRef workflowPerson = this.personService.getPerson(workflowUser);
        action.setParameterValue("bpm:assignee", (Serializable)workflowPerson);
        action.setParameterValue("bpm:workflowDescription", (Serializable)((Object)I18NUtil.getMessage((String)"wcmqs.contactRequest.workflowDescription", (Object[])new Object[]{visitorName})));
        if (log.isDebugEnabled()) {
            log.debug((Object)("Starting contact request workflow for node " + feedback.toString()));
        }
        this.actionService.executeAction(action, feedback);
    }

    private Map<String, String> getFeedbackConfiguration(NodeRef feedback) {
        List feedbackConfig;
        NodeRef website;
        TreeMap<String, String> result = new TreeMap<String, String>();
        NodeRef relevantArticle = (NodeRef)this.nodeService.getProperty(feedback, PROP_RELEVANT_ASSET);
        if (relevantArticle != null && (website = this.siteHelper.getRelevantWebSite(relevantArticle)) != null && (feedbackConfig = (List)((Object)this.nodeService.getProperty(website, PROP_WEBSITE_CONFIG))) != null) {
            for (String configValue : feedbackConfig) {
                String[] configValues = configValue.split("=");
                if (configValues.length != 2) continue;
                result.put(configValues[0], this.contextParserService.parse(website, configValues[1]));
            }
        }
        return result;
    }
}

