/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_wcmquickstart.webscript;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.List;
import javax.transaction.UserTransaction;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_wcmquickstart.model.WebSiteModel;
import org.alfresco.repo.model.Repository;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.web.scripts.BaseWebScriptTest;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.cmr.site.SiteVisibility;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.GUID;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.springframework.context.ApplicationContext;
import org.springframework.extensions.webscripts.TestWebScriptServer;

public final class WebscriptTest
extends BaseWebScriptTest
implements WebSiteModel {
    private static final String GET_TRANSLATION_DETAILS = "/api/webassettranslations?nodeRef={0}";
    private static final String GET_ASSET_COLLECTION = "/api/assetcollections/{0}?sectionid={1}";
    private static final String GET_LOADWEBSITEDATA = "/api/loadwebsitedata?site={0}";
    private AuthenticationComponent authenticationComponent;
    private TransactionService transactionService;
    private FileFolderService fileFolderService;
    private NodeService nodeService;
    private Repository repository;
    private ContentService contentService;
    private SiteService siteService;
    private NodeRef sectionChild;
    private NodeRef englishHome;
    private NodeRef collection;
    private String siteName;

    protected void setUp() throws Exception {
        super.setUp();
        ApplicationContext appContext = this.getServer().getApplicationContext();
        this.authenticationComponent = (AuthenticationComponent)appContext.getBean("authenticationComponent");
        this.transactionService = (TransactionService)appContext.getBean("transactionService");
        this.fileFolderService = (FileFolderService)appContext.getBean("fileFolderService");
        this.nodeService = (NodeService)appContext.getBean("nodeService");
        this.repository = (Repository)appContext.getBean("repositoryHelper");
        this.contentService = (ContentService)appContext.getBean("contentService");
        this.siteService = (SiteService)appContext.getBean("siteService");
        this.authenticationComponent.setCurrentUser("admin");
        UserTransaction userTransaction = this.transactionService.getUserTransaction();
        userTransaction.begin();
        NodeRef companyHome = this.repository.getCompanyHome();
        NodeRef website = this.fileFolderService.create(companyHome, "websitetest" + GUID.generate(), WebSiteModel.TYPE_WEB_SITE).getNodeRef();
        NodeRef webroot = this.fileFolderService.create(website, "webroottest" + GUID.generate(), ContentModel.TYPE_FOLDER).getNodeRef();
        WebscriptTest.assertNotNull((Object)webroot);
        this.nodeService.setType(webroot, TYPE_WEB_ROOT);
        NodeRef section = this.fileFolderService.create(webroot, "section", ContentModel.TYPE_FOLDER).getNodeRef();
        WebscriptTest.assertNotNull((Object)section);
        WebscriptTest.assertEquals((Object)TYPE_SECTION, (Object)this.nodeService.getType(section));
        this.sectionChild = this.fileFolderService.create(section, "childSection", ContentModel.TYPE_FOLDER).getNodeRef();
        WebscriptTest.assertNotNull((Object)this.sectionChild);
        WebscriptTest.assertEquals((Object)TYPE_SECTION, (Object)this.nodeService.getType(this.sectionChild));
        NodeRef page1 = this.createContent(this.sectionChild, "file1.html");
        NodeRef page2 = this.createContent(this.sectionChild, "file2.html");
        NodeRef page3 = this.createContent(this.sectionChild, "file3.html");
        userTransaction.commit();
        userTransaction = this.transactionService.getUserTransaction();
        userTransaction.begin();
        NodeRef collections = this.fileFolderService.searchSimple(this.sectionChild, "collections");
        WebscriptTest.assertNotNull((Object)collections);
        this.collection = this.fileFolderService.create(collections, "myCollection", ContentModel.TYPE_FOLDER).getNodeRef();
        this.nodeService.setProperty(this.collection, ContentModel.PROP_TITLE, (Serializable)((Object)"My Collection"));
        this.nodeService.setProperty(this.collection, ContentModel.PROP_DESCRIPTION, (Serializable)((Object)"My web assect collection"));
        this.nodeService.createAssociation(this.collection, page1, ASSOC_WEBASSETS);
        this.nodeService.createAssociation(this.collection, page2, ASSOC_WEBASSETS);
        this.nodeService.createAssociation(this.collection, page3, ASSOC_WEBASSETS);
        this.englishHome = this.fileFolderService.create(webroot, "English", WebSiteModel.TYPE_SECTION).getNodeRef();
        this.siteName = "testSite" + GUID.generate();
        this.siteService.createSite("sitePreset", this.siteName, "siteTitle", "siteDescription", SiteVisibility.PUBLIC);
        userTransaction.commit();
    }

    private NodeRef createContent(NodeRef section, String name) {
        NodeRef page = this.fileFolderService.create(section, name, ContentModel.TYPE_CONTENT).getNodeRef();
        ContentWriter writer = this.contentService.getWriter(page, ContentModel.PROP_CONTENT, true);
        writer.setEncoding("UTF-8");
        writer.setMimetype("text/html");
        writer.putContent("<html><head><title>Hello</title></head><body></body></html>");
        return page;
    }

    public void testGetAssestCollection() throws Exception {
        String url = MessageFormat.format(GET_ASSET_COLLECTION, "myCollection", this.sectionChild.toString());
        TestWebScriptServer.Response rsp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(url), 200);
        String xmlStr = rsp.getContentAsString();
        WebscriptTest.fail((String)"This test assumes a JSON response, but the webscript now returns XML");
        JSONObject jsonRsp = new JSONObject(new JSONTokener(xmlStr));
        JSONObject data = jsonRsp.getJSONObject("data");
        WebscriptTest.assertNotNull((Object)data);
        WebscriptTest.assertEquals((String)this.collection.toString(), (String)data.getString("id"));
        WebscriptTest.assertEquals((String)"myCollection", (String)data.getString("name"));
        WebscriptTest.assertEquals((String)"My Collection", (String)data.getString("title"));
        WebscriptTest.assertEquals((String)"My web assect collection", (String)data.getString("description"));
        JSONArray assets = data.getJSONArray("assets");
        WebscriptTest.assertNotNull((Object)assets);
        WebscriptTest.assertEquals((int)3, (int)assets.length());
        System.out.println(rsp.getContentAsString());
    }

    public void testGetTranslationDetails() throws Exception {
        String url = MessageFormat.format(GET_TRANSLATION_DETAILS, this.englishHome.toString());
        TestWebScriptServer.Response rsp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(url), 200);
        String jsonStr = rsp.getContentAsString();
        JSONObject jsonRsp = null;
        try {
            jsonRsp = new JSONObject(new JSONTokener(jsonStr));
        }
        catch (JSONException e) {
            System.err.println(jsonStr);
            WebscriptTest.fail((String)("Invalid JSON received: " + e.getMessage() + "\n" + jsonStr));
        }
        System.out.println(jsonStr);
        JSONObject data = jsonRsp.getJSONObject("data");
        WebscriptTest.assertNotNull((Object)data);
        WebscriptTest.assertTrue((data.getJSONArray("locales").length() > 4 ? 1 : 0) != 0);
        WebscriptTest.assertEquals((String)"en", (String)data.getJSONArray("locales").getJSONObject(0).getString("id"));
        WebscriptTest.assertEquals((Object)JSONObject.NULL, (Object)data.get("locale"));
        WebscriptTest.assertEquals((boolean)false, (boolean)data.getBoolean("translationEnabled"));
        WebscriptTest.assertEquals((int)0, (int)data.getJSONObject("translations").length());
        WebscriptTest.assertEquals((int)0, (int)data.getJSONObject("parents").length());
        UserTransaction userTransaction = this.transactionService.getUserTransaction();
        userTransaction.begin();
        this.nodeService.addAspect(this.englishHome, WebSiteModel.ASPECT_TEMPORARY_MULTILINGUAL, null);
        this.nodeService.setProperty(this.englishHome, WebSiteModel.PROP_LANGUAGE, (Serializable)((Object)"en"));
        NodeRef doc = this.fileFolderService.create(this.englishHome, "Document", WebSiteModel.TYPE_ARTICLE).getNodeRef();
        userTransaction.commit();
        rsp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(url), 200);
        jsonStr = rsp.getContentAsString();
        jsonRsp = new JSONObject(new JSONTokener(jsonStr));
        data = jsonRsp.getJSONObject("data");
        WebscriptTest.assertTrue((data.getJSONArray("locales").length() > 4 ? 1 : 0) != 0);
        WebscriptTest.assertEquals((String)"en", (String)data.getJSONArray("locales").getJSONObject(0).getString("id"));
        WebscriptTest.assertEquals((String)"en", (String)data.getString("locale"));
        WebscriptTest.assertEquals((boolean)true, (boolean)data.getBoolean("translationEnabled"));
        WebscriptTest.assertEquals((int)1, (int)data.getJSONObject("translations").length());
        WebscriptTest.assertEquals((int)0, (int)data.getJSONObject("parents").length());
        String url2 = MessageFormat.format(GET_TRANSLATION_DETAILS, doc.toString());
        rsp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(url2), 200);
        jsonStr = rsp.getContentAsString();
        jsonRsp = new JSONObject(new JSONTokener(jsonStr));
        data = jsonRsp.getJSONObject("data");
        WebscriptTest.assertTrue((data.getJSONArray("locales").length() > 4 ? 1 : 0) != 0);
        WebscriptTest.assertEquals((String)"en", (String)data.getJSONArray("locales").getJSONObject(0).getString("id"));
        WebscriptTest.assertEquals((String)"en", (String)data.getString("locale"));
        WebscriptTest.assertEquals((boolean)false, (boolean)data.getBoolean("translationEnabled"));
        WebscriptTest.assertEquals((int)0, (int)data.getJSONObject("translations").length());
        WebscriptTest.assertEquals((int)1, (int)data.getJSONObject("parents").length());
        WebscriptTest.assertEquals((Object)"en", (Object)data.getJSONObject("parents").names().get(0));
        WebscriptTest.assertEquals((String)this.englishHome.toString(), (String)data.getJSONObject("parents").getJSONObject("en").getString("nodeRef"));
        WebscriptTest.assertEquals((boolean)true, (boolean)data.getJSONObject("parents").getJSONObject("en").getBoolean("allPresent"));
        userTransaction = this.transactionService.getUserTransaction();
        userTransaction.begin();
        this.nodeService.addAspect(doc, WebSiteModel.ASPECT_TEMPORARY_MULTILINGUAL, null);
        userTransaction.commit();
        userTransaction = this.transactionService.getUserTransaction();
        userTransaction.begin();
        NodeRef french = this.fileFolderService.create(this.englishHome, "FrDocument", WebSiteModel.TYPE_ARTICLE).getNodeRef();
        this.nodeService.addAspect(french, WebSiteModel.ASPECT_TEMPORARY_MULTILINGUAL, null);
        this.nodeService.setProperty(french, WebSiteModel.PROP_LANGUAGE, (Serializable)((Object)"fr"));
        this.nodeService.setProperty(french, WebSiteModel.PROP_TRANSLATION_OF, (Serializable)doc);
        userTransaction.commit();
        rsp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(url), 200);
        jsonStr = rsp.getContentAsString();
        jsonRsp = new JSONObject(new JSONTokener(jsonStr));
        data = jsonRsp.getJSONObject("data");
        WebscriptTest.assertTrue((data.getJSONArray("locales").length() > 4 ? 1 : 0) != 0);
        WebscriptTest.assertEquals((String)"en", (String)data.getJSONArray("locales").getJSONObject(0).getString("id"));
        WebscriptTest.assertEquals((String)"en", (String)data.getString("locale"));
        WebscriptTest.assertEquals((boolean)true, (boolean)data.getBoolean("translationEnabled"));
        WebscriptTest.assertEquals((int)1, (int)data.getJSONObject("translations").length());
        WebscriptTest.assertEquals((int)0, (int)data.getJSONObject("parents").length());
        rsp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(url2), 200);
        jsonStr = rsp.getContentAsString();
        System.out.println(jsonStr);
        jsonRsp = new JSONObject(new JSONTokener(jsonStr));
        data = jsonRsp.getJSONObject("data");
        WebscriptTest.assertTrue((data.getJSONArray("locales").length() > 4 ? 1 : 0) != 0);
        WebscriptTest.assertEquals((String)"en", (String)data.getJSONArray("locales").getJSONObject(0).getString("id"));
        WebscriptTest.assertEquals((String)"en", (String)data.getString("locale"));
        WebscriptTest.assertEquals((boolean)true, (boolean)data.getBoolean("translationEnabled"));
        WebscriptTest.assertEquals((int)2, (int)data.getJSONObject("translations").length());
        WebscriptTest.assertEquals((String)doc.toString(), (String)data.getJSONObject("translations").getJSONObject("en").getString("nodeRef"));
        WebscriptTest.assertEquals((String)french.toString(), (String)data.getJSONObject("translations").getJSONObject("fr").getString("nodeRef"));
        WebscriptTest.assertEquals((int)1, (int)data.getJSONObject("parents").length());
        WebscriptTest.assertEquals((Object)"en", (Object)data.getJSONObject("parents").names().get(0));
        WebscriptTest.assertEquals((String)this.englishHome.toString(), (String)data.getJSONObject("parents").getJSONObject("en").getString("nodeRef"));
        WebscriptTest.assertEquals((boolean)true, (boolean)data.getJSONObject("parents").getJSONObject("en").getBoolean("allPresent"));
        String url3 = MessageFormat.format(GET_TRANSLATION_DETAILS, french.toString());
        rsp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(url3), 200);
        jsonStr = rsp.getContentAsString();
        System.out.println(jsonStr);
        jsonRsp = new JSONObject(new JSONTokener(jsonStr));
        data = jsonRsp.getJSONObject("data");
        WebscriptTest.assertTrue((data.getJSONArray("locales").length() > 4 ? 1 : 0) != 0);
        WebscriptTest.assertEquals((String)"en", (String)data.getJSONArray("locales").getJSONObject(0).getString("id"));
        WebscriptTest.assertEquals((String)"fr", (String)data.getString("locale"));
        WebscriptTest.assertEquals((boolean)true, (boolean)data.getBoolean("translationEnabled"));
        WebscriptTest.assertEquals((int)2, (int)data.getJSONObject("translations").length());
        WebscriptTest.assertEquals((String)doc.toString(), (String)data.getJSONObject("translations").getJSONObject("en").getString("nodeRef"));
        WebscriptTest.assertEquals((String)french.toString(), (String)data.getJSONObject("translations").getJSONObject("fr").getString("nodeRef"));
        WebscriptTest.assertEquals((int)1, (int)data.getJSONObject("parents").length());
        WebscriptTest.assertEquals((Object)"en", (Object)data.getJSONObject("parents").names().get(0));
        WebscriptTest.assertEquals((String)this.englishHome.toString(), (String)data.getJSONObject("parents").getJSONObject("en").getString("nodeRef"));
        WebscriptTest.assertEquals((boolean)true, (boolean)data.getJSONObject("parents").getJSONObject("en").getBoolean("allPresent"));
    }

    public void testGetImportWebSiteData() throws Exception {
        UserTransaction userTransaction = this.transactionService.getUserTransaction();
        userTransaction.begin();
        String url = MessageFormat.format(GET_LOADWEBSITEDATA, this.siteName);
        TestWebScriptServer.Response resp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(url + "&preview=true"), 200);
        System.out.println(resp.getContentAsString());
        resp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(url), 200);
        System.out.println(resp.getContentAsString());
        NodeRef nodeRef = this.siteService.getContainer(this.siteName, "documentLibrary");
        WebscriptTest.assertNotNull((Object)nodeRef);
        List infos = this.fileFolderService.listFolders(nodeRef);
        WebscriptTest.assertNotNull((Object)infos);
        WebscriptTest.assertEquals((int)1, (int)infos.size());
        NodeRef root = ((FileInfo)infos.get(0)).getNodeRef();
        WebscriptTest.assertNotNull((Object)root);
        WebscriptTest.assertEquals((Object)ContentModel.TYPE_FOLDER, (Object)this.nodeService.getType(root));
        infos = this.fileFolderService.listFolders(root);
        WebscriptTest.assertNotNull((Object)infos);
        WebscriptTest.assertEquals((int)2, (int)infos.size());
        NodeRef website = ((FileInfo)infos.get(0)).getNodeRef();
        WebscriptTest.assertNotNull((Object)website);
        WebscriptTest.assertEquals((Object)TYPE_WEB_SITE, (Object)this.nodeService.getType(website));
        website = ((FileInfo)infos.get(1)).getNodeRef();
        WebscriptTest.assertNotNull((Object)website);
        WebscriptTest.assertEquals((Object)TYPE_WEB_SITE, (Object)this.nodeService.getType(website));
        userTransaction.commit();
    }
}

