/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.wcm.client.directive;

import freemarker.core.Environment;
import freemarker.ext.beans.StringModel;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateDirectiveModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.utility.StringUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Map;
import org.alfresco.wcm.client.Asset;
import org.alfresco.wcm.client.ContentStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.webscripts.ui.common.StringUtils;

public class AssetDirective
implements TemplateDirectiveModel {
    protected static final int DEFAULT_BUFFERSIZE = 4096;
    protected static final Log logger = LogFactory.getLog(AssetDirective.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Environment env, Map params, TemplateModel[] loopVars, TemplateDirectiveBody body) throws TemplateException, IOException {
        if (params.size() != 1) {
            throw new TemplateModelException("asset directive expects one parameter of type Asset");
        }
        StringModel assetParam = (StringModel)params.get("asset");
        if (assetParam == null || !(assetParam.getWrappedObject() instanceof Asset)) {
            throw new TemplateModelException("asset directive expects asset parameter with a value of class Asset");
        }
        Asset asset = (Asset)assetParam.getWrappedObject();
        ContentStream contentStream = asset.getContentAsInputStream();
        Writer out = env.getOut();
        String mimeType = contentStream.getMimeType();
        String encoding = Charset.forName("UTF-8").name();
        String content = null;
        int bufferSize = 4096;
        int length = (int)contentStream.getLength();
        if (length > 0 && length < bufferSize) {
            bufferSize = length;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream(bufferSize);
        InputStream input = contentStream.getStream();
        if (input != null) {
            try {
                byte[] buffer = new byte[bufferSize];
                int read = input.read(buffer);
                while (read != -1) {
                    bos.write(buffer, 0, read);
                    read = input.read(buffer);
                }
            }
            finally {
                input.close();
            }
            content = encoding != null ? new String(bos.toByteArray(), encoding) : new String(bos.toByteArray());
            content = mimeType.contains("text/html") || mimeType.contains("application/xhtml+xml") ? StringUtils.stripUnsafeHTMLDocument((String)content, (boolean)false) : StringUtil.XHTMLEnc((String)content);
        }
        try {
            String processedContent = new String(content.getBytes(), encoding);
            out.write(processedContent);
        }
        catch (IOException ex) {
            logger.error((Object)ex);
        }
    }
}

