/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.wcm.client.interceptor;

import freemarker.template.TemplateDirectiveModel;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Map;
import org.alfresco.wcm.client.WebSite;
import org.springframework.extensions.surf.support.ThreadLocalRequestContext;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.support.RequestContext;
import org.springframework.web.servlet.view.RedirectView;

public class ModelDecorator {
    private Map<String, TemplateDirectiveModel> freemarkerDirectives;

    public void populate(HttpServletRequest request, ModelAndView modelAndView) {
        if (!(modelAndView == null || modelAndView.hasView() && modelAndView.getView() instanceof RedirectView)) {
            Map model = modelAndView.getModel();
            model.putAll(this.freemarkerDirectives);
            org.springframework.extensions.surf.RequestContext requestContext = ThreadLocalRequestContext.getRequestContext();
            WebSite website = (WebSite)requestContext.getValue("webSite");
            model.put("webSite", website);
            model.put("section", requestContext.getValue("section"));
            model.put("asset", requestContext.getValue("asset"));
            model.put("rootSection", requestContext.getValue("rootSection"));
            model.put("springMacroRequestContext", new RequestContext(request, model));
            model.put("uri", requestContext.getAttribute("javax.servlet.forward.request_uri"));
            model.put("editorialSite", website.isEditorialSite());
            request.setAttribute("wef_enabled", (Object)website.isEditorialSite());
        }
    }

    public void setFreemarkerDirectives(Map<String, TemplateDirectiveModel> directives) {
        this.freemarkerDirectives = directives;
    }
}

