/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.wcm.client.directive;

import freemarker.core.Environment;
import freemarker.template.SimpleNumber;
import freemarker.template.SimpleScalar;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateDirectiveModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import java.io.IOException;
import java.text.BreakIterator;
import java.util.Map;

public class TruncateDirective
implements TemplateDirectiveModel {
    public void execute(Environment env, Map params, TemplateModel[] loopVars, TemplateDirectiveBody body) throws TemplateException, IOException {
        if (params.size() != 2) {
            return;
        }
        SimpleScalar valueParam = (SimpleScalar)params.get("value");
        SimpleNumber charsParam = (SimpleNumber)params.get("chars");
        if (valueParam != null && charsParam != null) {
            Object text = valueParam.getAsString();
            int chars = charsParam.getAsNumber().intValue();
            if (((String)text).length() > chars) {
                BreakIterator bi = BreakIterator.getWordInstance();
                bi.setText((String)text);
                int firstBefore = bi.preceding(chars);
                text = ((String)text).substring(0, firstBefore) + "...";
            }
            env.getOut().write((String)text);
        }
    }
}

