/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.wcm.client.util;

import java.util.Locale;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.context.NoSuchMessageException;
import org.springframework.extensions.surf.util.I18NUtil;

public class SurfMessageSource
implements MessageSource {
    public String getMessage(MessageSourceResolvable resolvable, Locale locale) throws NoSuchMessageException {
        String lastCode = null;
        for (String code : resolvable.getCodes()) {
            String message = I18NUtil.getMessage((String)code, (Locale)locale);
            if (message != null) {
                return message;
            }
            lastCode = code;
        }
        throw new NoSuchMessageException(lastCode, locale);
    }

    public String getMessage(String code, Object[] args, Locale locale) throws NoSuchMessageException {
        String message = I18NUtil.getMessage((String)code, (Locale)locale, (Object[])args);
        if (message == null) {
            throw new NoSuchMessageException(code, locale);
        }
        return message;
    }

    public String getMessage(String code, Object[] args, String defaultMessage, Locale locale) {
        String message = I18NUtil.getMessage((String)code, (Object[])new Object[]{args, locale});
        if (message == null) {
            message = defaultMessage;
        }
        return message;
    }
}

