/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.wcm.client.util.impl;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Date;
import org.alfresco.wcm.client.Asset;
import org.alfresco.wcm.client.util.HeaderHelper;

public class SimpleCacheControlHeaderHelper
extends HeaderHelper {
    private long defaultExpiry = 300000L;

    public void setDefaultExpiry(long defaultExpiry) {
        this.defaultExpiry = defaultExpiry;
    }

    @Override
    public boolean setHeaders(Asset asset, boolean attach, HttpServletRequest request, HttpServletResponse response) {
        try {
            Date modifiedDate = (Date)asset.getProperty("cmis:lastModificationDate");
            long modifiedTime = modifiedDate.getTime();
            modifiedTime = modifiedTime / 1000L * 1000L;
            response.addDateHeader("Last-Modified", modifiedTime);
            response.addDateHeader("Expires", new Date().getTime() + this.defaultExpiry);
            String etag = Long.toHexString(modifiedTime);
            response.addHeader("ETag", etag);
            String requestIfNoneMatch = request.getHeader("If-None-Match");
            if (requestIfNoneMatch != null) {
                if (etag.equals(requestIfNoneMatch)) {
                    response.sendError(304);
                    return false;
                }
            } else {
                Date requestDate;
                String requestIfModifiedSince = request.getHeader("If-Modified-Since");
                if (requestIfModifiedSince != null && (requestDate = this.getDateFromHttpDate(requestIfModifiedSince)).getTime() >= modifiedTime) {
                    response.sendError(304);
                    return false;
                }
            }
            if (attach) {
                Object headerValue = "attachment";
                String attachFileName = asset.getName();
                if (attachFileName != null && attachFileName.length() > 0) {
                    headerValue = (String)headerValue + "; filename=" + attachFileName;
                }
                response.setHeader("Content-Disposition", (String)headerValue);
            }
            return true;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

