/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.wcm.client.controller;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.alfresco.wcm.client.Asset;
import org.alfresco.wcm.client.AssetFactory;
import org.alfresco.wcm.client.util.UrlUtils;
import org.alfresco.wcm.client.view.StreamedAssetView;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.mvc.AbstractController;
import org.springframework.web.servlet.view.RedirectView;

public class StreamedAssetController
extends AbstractController {
    private UrlUtils urlUtils;
    private AssetFactory assetFactory;

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String uri = request.getPathInfo();
        String objectId = this.urlUtils.getAssetIdFromShortUrl(uri);
        String renditionName = request.getParameter("rendition");
        boolean attach = Boolean.parseBoolean(request.getParameter("attach"));
        Asset asset = this.assetFactory.getAssetById(objectId);
        if (asset == null) {
            response.setStatus(HttpStatus.NOT_FOUND.value());
            return null;
        }
        String template = asset.getTemplate();
        if (template != null && renditionName == null && !"raw".equalsIgnoreCase(template)) {
            String fullUri = this.urlUtils.getUrl(asset);
            RedirectView redirect = new RedirectView(fullUri, true, false);
            redirect.setStatusCode((HttpStatusCode)HttpStatus.MOVED_PERMANENTLY);
            return new ModelAndView((View)redirect);
        }
        return new ModelAndView((View)new StreamedAssetView(asset, renditionName, attach));
    }

    public void setUrlUtils(UrlUtils urlUtils) {
        this.urlUtils = urlUtils;
    }

    public void setAssetFactory(AssetFactory assetFactory) {
        this.assetFactory = assetFactory;
    }
}

