/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.wcm.client.directive;

import freemarker.core.Environment;
import freemarker.ext.servlet.HttpRequestHashModel;
import freemarker.template.TemplateDirectiveModel;
import freemarker.template.TemplateModelException;
import jakarta.servlet.http.HttpServletRequest;
import org.alfresco.wcm.client.directive.TemplateProps;

public abstract class AbstractTemplateDirective
implements TemplateDirectiveModel {
    public static final long serialVersionUID = 4251970922970982753L;
    protected String urlPrefix = null;

    protected HttpServletRequest getRequest(Environment env) throws TemplateModelException {
        return ((HttpRequestHashModel)env.getDataModel().get("Request")).getRequest();
    }

    protected boolean isEditingEnabled(Environment env) throws TemplateModelException {
        boolean editingEnabled = false;
        HttpServletRequest request = this.getRequest(env);
        Object enabledKey = request.getAttribute("wef_enabled");
        if (enabledKey != null && enabledKey instanceof Boolean) {
            editingEnabled = (Boolean)enabledKey;
        }
        return editingEnabled;
    }

    protected String getWebEditorUrlPrefix(Environment env) throws TemplateModelException {
        if (this.urlPrefix == null) {
            HttpServletRequest request = this.getRequest(env);
            String prefix = (String)request.getAttribute("wef_url_prefix");
            if (prefix != null && prefix.length() > 0) {
                this.urlPrefix = prefix;
            } else {
                this.urlPrefix = TemplateProps.getUrlPrefix();
                if (this.urlPrefix == null) {
                    this.urlPrefix = request.getContextPath();
                }
            }
        }
        return this.urlPrefix;
    }

    protected boolean isDebugEnabled(Environment env) throws TemplateModelException {
        boolean debugEnabled = false;
        HttpServletRequest request = this.getRequest(env);
        Object debug = request.getAttribute("wef_debug");
        if (debug != null && debug instanceof Boolean) {
            debugEnabled = (Boolean)debug;
        } else {
            Boolean prop = TemplateProps.isDebugEnabled();
            if (prop != null) {
                debugEnabled = prop;
            }
        }
        return debugEnabled;
    }

    protected String getToolbarLocation(Environment env) throws TemplateModelException {
        HttpServletRequest request = this.getRequest(env);
        return (String)request.getAttribute("wef_toolbar_location");
    }

    protected String encode(String string) {
        if (string == null) {
            return "";
        }
        StringBuilder sb = null;
        for (int i = 0; i < string.length(); ++i) {
            Object enc = null;
            char c = string.charAt(i);
            switch (c) {
                case '\"': {
                    enc = "&quot;";
                    break;
                }
                case '&': {
                    enc = "&amp;";
                    break;
                }
                case '<': {
                    enc = "&lt;";
                    break;
                }
                case '>': {
                    enc = "&gt;";
                    break;
                }
                case '\u20ac': {
                    enc = "&euro;";
                    break;
                }
                case '\u00ab': {
                    enc = "&laquo;";
                    break;
                }
                case '\u00bb': {
                    enc = "&raquo;";
                    break;
                }
                case '\u00a0': {
                    enc = "&nbsp;";
                    break;
                }
                default: {
                    if (c < '\u0080') break;
                    enc = "&#" + c + ";";
                }
            }
            if (enc != null) {
                if (sb == null) {
                    String soFar = string.substring(0, i);
                    sb = new StringBuilder(i + 16);
                    sb.append(soFar);
                }
                sb.append((String)enc);
                continue;
            }
            if (sb == null) continue;
            sb.append(c);
        }
        if (sb == null) {
            return string;
        }
        return sb.toString();
    }
}

