/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.wcm.client.directive;

import freemarker.core.Environment;
import freemarker.template.SimpleScalar;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.alfresco.wcm.client.directive.AbstractTemplateDirective;
import org.alfresco.web.awe.tag.AlfrescoTagUtil;
import org.alfresco.web.awe.tag.MarkedContent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WebEditorMarkContentDirective
extends AbstractTemplateDirective {
    private static final Log logger = LogFactory.getLog(WebEditorMarkContentDirective.class);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute(Environment env, Map params, TemplateModel[] loopVars, TemplateDirectiveBody body) throws TemplateException, IOException {
        SimpleScalar idParam = (SimpleScalar)params.get("id");
        SimpleScalar titleParam = (SimpleScalar)params.get("title");
        SimpleScalar formIdParam = (SimpleScalar)params.get("formId");
        SimpleScalar nestedMarkerParam = (SimpleScalar)params.get("nestedMarker");
        if (idParam == null) {
            throw new TemplateModelException("id parameter is mandatory for markContent directive");
        }
        String contentId = idParam.getAsString();
        String contentTitle = titleParam == null ? null : titleParam.getAsString();
        String formId = null;
        boolean nestedMarker = false;
        if (formIdParam != null) {
            formId = formIdParam.getAsString();
        }
        if (nestedMarkerParam != null) {
            nestedMarker = "true".equals(nestedMarkerParam.getAsString());
        }
        if (this.isEditingEnabled(env)) {
            try {
                Writer out = env.getOut();
                HttpServletRequest request = this.getRequest(env);
                String urlPrefix = this.getWebEditorUrlPrefix(env);
                List markedContent = AlfrescoTagUtil.getMarkedContent((ServletRequest)request);
                String markerIdPrefix = (String)request.getAttribute("awe_marker_id_prefix");
                String markerId = markerIdPrefix + "-" + (markedContent.size() + 1);
                String redirectUrl = this.calculateRedirectUrl(request);
                MarkedContent content = new MarkedContent(markerId, contentId, contentTitle, formId, nestedMarker);
                markedContent.add(content);
                AlfrescoTagUtil.writeMarkContentHtml((Writer)out, (String)urlPrefix, (String)redirectUrl, (MarkedContent)content);
                if (!logger.isDebugEnabled()) return;
                logger.debug((Object)("Completed markContent rendering for: " + String.valueOf(content)));
                return;
            }
            catch (IOException ioe) {
                throw new TemplateModelException(ioe.toString());
            }
        } else {
            if (!logger.isDebugEnabled()) return;
            logger.debug((Object)"Skipping markContent rendering as editing is disabled");
        }
    }

    private String calculateRedirectUrl(HttpServletRequest request) {
        String redirectUrl = null;
        try {
            String fullUrl = request.getRequestURL().toString();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Calculating redirect URL. Request URL is " + fullUrl));
            }
            int firstSep = fullUrl.indexOf("/", fullUrl.indexOf("://") + 3);
            StringBuffer url = new StringBuffer();
            url.append(fullUrl.substring(0, firstSep));
            url.append(request.getContextPath());
            url.append(request.getPathInfo());
            String queryString = request.getQueryString();
            if (queryString != null) {
                url.append("?").append(queryString);
            }
            redirectUrl = URLEncoder.encode(url.toString(), "UTF-8");
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Calculated redirect URL: " + redirectUrl));
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return redirectUrl;
    }
}

