/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.wcm.client;

import java.util.Collection;
import java.util.List;
import org.alfresco.wcm.client.Asset;
import org.alfresco.wcm.client.BaseTest;
import org.alfresco.wcm.client.ResourceNotFoundException;
import org.alfresco.wcm.client.Section;
import org.alfresco.wcm.client.WebSite;
import org.alfresco.wcm.client.impl.AssetImpl;
import org.junit.Test;

public class WebSiteServiceTest
extends BaseTest {
    public void testGetSections() {
        Collection webSites = this.webSiteService.getWebSites();
        for (WebSite webSite : webSites) {
            System.out.println(webSite.getHostName() + ":" + webSite.getHostPort());
        }
        WebSite site = this.getWebSite();
        WebSiteServiceTest.assertNotNull((Object)site);
        WebSiteServiceTest.assertEquals((String)"localhost", (String)site.getHostName());
        WebSite siteBad = this.webSiteService.getWebSite("localhost", 8085);
        WebSiteServiceTest.assertNull((Object)siteBad);
        WebSite siteBad2 = this.webSiteService.getWebSite("me.com", 8080);
        WebSiteServiceTest.assertNull((Object)siteBad2);
        Section rootSection = site.getRootSection();
        WebSiteServiceTest.assertNotNull((Object)rootSection);
        this.outputSection(0, rootSection);
        Asset pathTest = site.getAssetByPath("/blog/blog1.html");
        WebSiteServiceTest.assertNotNull((Object)pathTest);
        WebSiteServiceTest.assertTrue((boolean)(pathTest instanceof AssetImpl));
        WebSiteServiceTest.assertEquals((String)"blog1.html", (String)pathTest.getName());
        Asset indexFromPath = site.getAssetByPath("/blog/");
        WebSiteServiceTest.assertNotNull((Object)indexFromPath);
        WebSiteServiceTest.assertTrue((boolean)(indexFromPath instanceof AssetImpl));
        WebSiteServiceTest.assertEquals((String)"index.html", (String)indexFromPath.getName());
        Asset indexFromNull = site.getAssetByPath(null);
        WebSiteServiceTest.assertNotNull((Object)indexFromNull);
        WebSiteServiceTest.assertTrue((boolean)(indexFromNull instanceof AssetImpl));
        WebSiteServiceTest.assertEquals((String)"index.html", (String)indexFromNull.getName());
    }

    @Test(expected=ResourceNotFoundException.class)
    public void testError() {
        WebSite site = this.webSiteService.getWebSite("localhost", 8080);
        site.getAssetByPath("/blog");
    }

    public void testSectionConfig() {
        WebSite site = this.getWebSite();
        Asset blog1 = site.getAssetByPath("/blog/blog1.html");
        Section blog = blog1.getContainingSection();
        String template = blog.getTemplate("cmis:document");
        WebSiteServiceTest.assertNotNull((Object)template);
        WebSiteServiceTest.assertEquals((String)"baseTemplate", (String)template);
        template = blog1.getTemplate();
        WebSiteServiceTest.assertNotNull((Object)template);
        WebSiteServiceTest.assertEquals((String)"articlepage2", (String)template);
        Asset index = blog.getIndexPage();
        WebSiteServiceTest.assertNotNull((Object)index);
        template = index.getTemplate();
        WebSiteServiceTest.assertNotNull((Object)template);
        WebSiteServiceTest.assertEquals((String)"sectionpage2", (String)template);
    }

    private void outputSection(int depth, Section section) {
        System.out.println(this.indentString(depth) + "/" + section.getName());
        List sections = section.getSections();
        for (Section child : sections) {
            WebSiteServiceTest.assertEquals((String)section.getName(), (String)child.getContainingSection().getName());
            this.outputSection(depth + 3, child);
        }
    }

    private String indentString(int size) {
        StringBuffer buffer = new StringBuffer(size);
        for (int i = 0; i < size; ++i) {
            buffer.append(" ");
        }
        return buffer.toString();
    }
}

