/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.wcm.client.impl;

import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.alfresco.wcm.client.DictionaryService;
import org.alfresco.wcm.client.util.CmisSessionHelper;
import org.apache.chemistry.opencmis.client.api.ObjectType;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.client.api.Tree;

public class DictionaryServiceImpl
implements DictionaryService {
    private static final String TYPE_DELIMITER = ":";
    private static final String[] ROOT_TYPES = new String[]{"cmis:document", "cmis:folder"};
    private static final String[] ROOT_TYPE_PREFIXES = new String[]{"D", "cmis:folder"};
    private boolean initialised = false;
    private Map<String, Map<String, String>> typeMaps = new TreeMap<String, Map<String, String>>();
    private Map<String, String> typePrefixMap;

    public void init() {
        if (!this.initialised) {
            Session session = CmisSessionHelper.getSession();
            this.typePrefixMap = new TreeMap<String, String>();
            int index = 0;
            for (String rootType : ROOT_TYPES) {
                List typeHierarchy = session.getTypeDescendants(rootType, -1, false);
                TreeMap<String, String> typeMap = new TreeMap<String, String>();
                this.addToMap(typeMap, typeHierarchy, rootType);
                this.typeMaps.put(rootType, typeMap);
                this.typePrefixMap.put(rootType, ROOT_TYPE_PREFIXES[index]);
                ++index;
            }
            this.initialised = true;
        }
    }

    private void addToMap(Map<String, String> map, List<Tree<ObjectType>> types, String parentType) {
        if (types != null) {
            for (Tree<ObjectType> type : types) {
                String typeName = ((ObjectType)type.getItem()).getQueryName();
                map.put(typeName, parentType);
                this.addToMap(map, type.getChildren(), typeName);
            }
        }
    }

    @Override
    public String getParentType(String type) {
        return this.getParentType(type, false);
    }

    @Override
    public String getParentType(String type, boolean queryName) {
        Object parentType = null;
        this.init();
        type = this.removeTypePrefix(type);
        type = this.translateToCmisRootType(type);
        if (!this.typeMaps.containsKey(type)) {
            for (Map.Entry<String, Map<String, String>> entry : this.typeMaps.entrySet()) {
                String rootType = entry.getKey();
                parentType = entry.getValue().get(type);
                if (parentType == null) continue;
                if (queryName) break;
                parentType = this.typePrefixMap.get(rootType) + TYPE_DELIMITER + (String)parentType;
                break;
            }
        }
        return parentType;
    }

    private String translateToCmisRootType(String type) {
        if ("cm:content".equals(type)) {
            type = "cmis:document";
        } else if ("cm:folder".equals(type)) {
            type = "cmis:folder";
        }
        return type;
    }

    @Override
    public boolean isRootType(String type) {
        this.init();
        type = this.removeTypePrefix(type);
        type = this.translateToCmisRootType(type);
        return this.typeMaps.containsKey(type);
    }

    @Override
    public boolean isDocumentSubType(String type) {
        this.init();
        type = this.removeTypePrefix(type);
        type = this.translateToCmisRootType(type);
        return "cmis:document".equals(type) || this.typeMaps.get("cmis:document").containsKey(type);
    }

    @Override
    public boolean isFolderSubType(String type) {
        this.init();
        type = this.removeTypePrefix(type);
        type = this.translateToCmisRootType(type);
        return "cmis:folder".equals(type) || this.typeMaps.get("cmis:folder").containsKey(type);
    }

    @Override
    public String removeTypePrefix(String type) {
        Object result = type;
        String[] values = type.split(TYPE_DELIMITER);
        if (values.length == 3) {
            result = values[1] + TYPE_DELIMITER + values[2];
        }
        return result;
    }
}

