/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.wcm.client.impl;

import java.util.List;
import java.util.Map;
import org.alfresco.wcm.client.Asset;
import org.alfresco.wcm.client.PathResolutionDetails;
import org.alfresco.wcm.client.Section;
import org.alfresco.wcm.client.SectionFactory;
import org.alfresco.wcm.client.UgcService;
import org.alfresco.wcm.client.WebSite;
import org.alfresco.wcm.client.impl.PathImpl;

public class WebSiteImpl
implements WebSite {
    private static final long serialVersionUID = 1L;
    private String id;
    private String hostName;
    private String context;
    private int hostPort;
    private String title;
    private String description;
    private Asset logo;
    private transient SectionFactory sectionFactory;
    private transient UgcService ugcService;
    private String rootSectionId;
    private Map<String, String> configMap;
    private Boolean editorial;

    public WebSiteImpl(String id, String hostName, int hostPort, int sectonsRefreshAfter) {
        this.id = id;
        this.rootSectionId = id;
        this.hostName = hostName;
        this.hostPort = hostPort;
    }

    @Override
    public String getHostName() {
        return this.hostName;
    }

    @Override
    public int getHostPort() {
        return this.hostPort;
    }

    @Override
    public String getContext() {
        return this.context;
    }

    public void setContext(String context) {
        this.context = context;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Section getRootSection() {
        return this.getSectionByPath("");
    }

    @Override
    public List<Section> getSections() {
        return this.getRootSection().getSections();
    }

    @Override
    public Asset getAssetByPath(String path) {
        PathResolutionDetails resolution = this.getRootSection().resolvePath(path);
        return resolution.getAsset();
    }

    @Override
    public Section getSectionByPath(String path) {
        PathImpl segmentedPath = new PathImpl(path);
        String[] sectionPath = segmentedPath.getPathSegments();
        return this.sectionFactory.getSectionFromPathSegments(this.rootSectionId, sectionPath);
    }

    public void setSectionFactory(SectionFactory sectionFactory) {
        this.sectionFactory = sectionFactory;
    }

    @Override
    public UgcService getUgcService() {
        return this.ugcService;
    }

    public void setUgcService(UgcService ugcService) {
        this.ugcService = ugcService;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public Asset getLogo() {
        return this.logo;
    }

    public void setLogo(Asset logo) {
        this.logo = logo;
    }

    public void setRootSectionId(String rootSectionId) {
        this.rootSectionId = rootSectionId;
    }

    public void setConfig(Map<String, String> configProperties) {
        this.configMap = configProperties;
    }

    @Override
    public Map<String, String> getConfig() {
        return this.configMap;
    }

    @Override
    public boolean isEditorialSite() {
        if (this.editorial == null) {
            this.editorial = Boolean.parseBoolean(this.configMap.get("isEditorial"));
        }
        return this.editorial;
    }

    @Override
    public PathResolutionDetails resolvePath(String path) {
        return this.getRootSection().resolvePath(path);
    }
}

