/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.wcm.client.impl;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.alfresco.wcm.client.Section;
import org.alfresco.wcm.client.impl.AbstractCachingSectionFactoryImpl;
import org.alfresco.wcm.client.impl.SectionImpl;
import org.alfresco.wcm.client.util.CmisSessionHelper;
import org.alfresco.wcm.client.util.SqlUtils;
import org.apache.chemistry.opencmis.client.api.ItemIterable;
import org.apache.chemistry.opencmis.client.api.QueryResult;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SectionFactoryCmisImpl
extends AbstractCachingSectionFactoryImpl {
    private static final String COLUMNS = " f.cmis:objectId, f.cmis:name, t.cm:title, t.cm:description, f.cmis:objectTypeId, f.cmis:parentId, f.ws:sectionConfig, f.ws:excludeFromNavigation, ts.cm:tagScopeSummary ";
    private static final Log log = LogFactory.getLog(SectionFactoryCmisImpl.class);
    private static final String QUERY_SECTION_WITH_CHILDREN = "select  f.cmis:objectId, f.cmis:name, t.cm:title, t.cm:description, f.cmis:objectTypeId, f.cmis:parentId, f.ws:sectionConfig, f.ws:excludeFromNavigation, ts.cm:tagScopeSummary , o.ws:orderIndex as ord from ws:section as f join cm:titled as t on t.cmis:objectId = f.cmis:objectId join ws:ordered as o on o.cmis:objectId = f.cmis:objectId join cm:tagscope as ts on ts.cmis:objectId = f.cmis:objectId where (in_tree(f, {0}) or f.cmis:objectId = {1}) order by ord";

    protected AbstractCachingSectionFactoryImpl.SectionDetails buildSection(QueryResult result) {
        AbstractCachingSectionFactoryImpl.SectionDetails sectionDetails = new AbstractCachingSectionFactoryImpl.SectionDetails(this);
        SectionImpl section = new SectionImpl();
        TreeMap<String, Serializable> properties = new TreeMap<String, Serializable>();
        properties.put("cmis:objectId", (Serializable)((Object)((String)result.getPropertyValueById("cmis:objectId"))));
        properties.put("cmis:name", (Serializable)((Object)((String)result.getPropertyValueById("cmis:name"))));
        properties.put("cm:title", (Serializable)((Object)((String)result.getPropertyValueById("cm:title"))));
        properties.put("cm:description", (Serializable)((Object)((String)result.getPropertyValueById("cm:description"))));
        properties.put("ws:excludeFromNavigation", (Boolean)result.getPropertyValueById("ws:excludeFromNavigation"));
        List configList = result.getPropertyMultivalueById("ws:sectionConfig");
        properties.put("ws:sectionConfig", (Serializable)((Object)configList));
        section.setProperties(properties);
        List tagSummary = result.getPropertyMultivalueById("cm:tagScopeSummary");
        section.setTags(this.createTags(tagSummary));
        section.setSectionFactory(this);
        section.setAssetFactory(this.getAssetFactory());
        section.setDictionaryService(this.getDictionaryService());
        section.setCollectionFactory(this.getCollectionFactory());
        sectionDetails.section = section;
        sectionDetails.objectTypeId = (String)result.getPropertyValueById("cmis:objectTypeId");
        if (!sectionDetails.objectTypeId.equals("F:ws:webroot")) {
            String parentId = (String)result.getPropertyValueById("cmis:parentId");
            section.setPrimarySectionId(parentId);
            sectionDetails.parentId = parentId;
        }
        return sectionDetails;
    }

    private Map<String, String> parseSectionConfig(List<String> sectionConfigList) {
        TreeMap<String, String> result = new TreeMap<String, String>();
        for (String configValue : sectionConfigList) {
            String[] split = configValue.split("=");
            if (split.length != 2) continue;
            String name = split[0];
            String value = split[1];
            result.put(name, value);
            if ("cmis:document".equals(name)) {
                result.put("cm:content", value);
                continue;
            }
            if (!"cm:content".equals(name)) continue;
            result.put("cmis:document", value);
        }
        return result;
    }

    @Override
    protected Map<String, Section> findSectionWithChildren(String topSectionId) {
        Session session = CmisSessionHelper.getSession();
        TreeMap<String, Section> loadedSections = new TreeMap<String, Section>();
        String query = MessageFormat.format(QUERY_SECTION_WITH_CHILDREN, SqlUtils.encloseSQLString(topSectionId), SqlUtils.encloseSQLString(topSectionId));
        log.debug((Object)("About to run CMIS query: " + query));
        ItemIterable results = session.query(query, false);
        ArrayList<AbstractCachingSectionFactoryImpl.SectionDetails> orderedList = new ArrayList<AbstractCachingSectionFactoryImpl.SectionDetails>();
        for (QueryResult result : results) {
            AbstractCachingSectionFactoryImpl.SectionDetails sectionDetails = this.buildSection(result);
            if (!sectionDetails.objectTypeId.equals("F:ws:webroot") && !sectionDetails.objectTypeId.equals("F:ws:section")) continue;
            orderedList.add(sectionDetails);
            loadedSections.put(sectionDetails.section.getId(), sectionDetails.section);
        }
        for (AbstractCachingSectionFactoryImpl.SectionDetails details : orderedList) {
            if (details.section.getId().equals(topSectionId)) continue;
            SectionImpl parent = (SectionImpl)loadedSections.get(details.parentId);
            parent.addChild(details.section);
        }
        return loadedSections;
    }
}

