/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.wcm.client.impl;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.alfresco.wcm.client.Asset;
import org.alfresco.wcm.client.ContentStream;
import org.alfresco.wcm.client.Rendition;
import org.alfresco.wcm.client.Section;
import org.alfresco.wcm.client.impl.ResourceBaseImpl;

public class AssetImpl
extends ResourceBaseImpl
implements Asset {
    private static final long serialVersionUID = 1L;
    private static final String RELATIONSHIPS_PROP_NAME = "ws:sourceRelationships";
    private Map<String, List<String>> relationships = null;
    private Map<String, List<Asset>> relatedAssets;
    private List<String> parentSectionIds = Collections.emptyList();
    private ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private Lock writeLock = this.lock.writeLock();
    private Lock readLock = this.lock.readLock();

    @Override
    public void setProperties(Map<String, Serializable> props) {
        this.writeLock.lock();
        try {
            super.setProperties(props);
            Serializable relations = props.get(RELATIONSHIPS_PROP_NAME);
            if (relations != null) {
                this.relationships = Collections.unmodifiableMap((Map)((Object)relations));
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, List<Asset>> getRelatedAssets() {
        this.readLock.lock();
        try {
            if (this.relatedAssets != null) {
                Map<String, List<Asset>> map = this.relatedAssets;
                return map;
            }
        }
        finally {
            this.readLock.unlock();
        }
        this.writeLock.lock();
        try {
            if (this.relatedAssets == null) {
                TreeMap<String, List<Asset>> assetMap = new TreeMap<String, List<Asset>>();
                for (Map.Entry<String, List<String>> entry : this.getRelationships().entrySet()) {
                    List<Asset> assets;
                    List<String> relatedAssetIds = entry.getValue();
                    if (relatedAssetIds == null || (assets = this.getAssetFactory().getAssetsById(relatedAssetIds)).size() <= 0) continue;
                    assetMap.put(entry.getKey(), assets);
                }
                this.relatedAssets = Collections.unmodifiableMap(assetMap);
            }
            Map<String, List<Asset>> map = this.relatedAssets;
            return map;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public Map<String, List<Asset>> getCachedRelatedAssets() {
        return this.relatedAssets;
    }

    @Override
    public List<Asset> getRelatedAssets(String relationshipName) {
        List<String> relatedAssetIds = this.getRelationships().get(relationshipName);
        if (relatedAssetIds == null) {
            return Collections.emptyList();
        }
        return this.getAssetFactory().getAssetsById(relatedAssetIds);
    }

    @Override
    public Asset getRelatedAsset(String relationshipName) {
        Asset result = null;
        List<String> relatedAssetIds = this.getRelationships().get(relationshipName);
        if (relatedAssetIds != null && !relatedAssetIds.isEmpty()) {
            result = this.getAssetFactory().getAssetById(relatedAssetIds.get(0));
        }
        return result;
    }

    public void setParentSectionIds(Collection<String> sectionIds) {
        this.writeLock.lock();
        try {
            if (sectionIds != null) {
                this.parentSectionIds = Collections.unmodifiableList(new LinkedList<String>(sectionIds));
                if (!sectionIds.isEmpty()) {
                    this.setPrimarySectionId(this.parentSectionIds.get(0));
                }
            } else {
                this.parentSectionIds = Collections.emptyList();
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public List<String> getTags() {
        return (List)((Object)this.getProperties().get("ws:tags"));
    }

    @Override
    public String getMimeType() {
        return (String)((Object)this.getProperties().get("cmis:contentStreamMimeType"));
    }

    @Override
    public long getSize() {
        BigInteger streamLength = (BigInteger)this.getProperties().get("cmis:contentStreamLength");
        if (streamLength == null) {
            return 0L;
        }
        return streamLength.longValue();
    }

    @Override
    public ContentStream getContentAsInputStream() {
        return this.getAssetFactory().getContentStream(this.getId());
    }

    @Override
    public String getTemplate() {
        String template = null;
        String mimeType = this.getMimeType();
        if (mimeType != null && mimeType.startsWith("text") && ((template = (String)((Object)this.getProperties().get("ws:templateName"))) == null || template.trim().length() == 0)) {
            Section section = this.getContainingSection();
            template = section.getTemplate(this.getType());
        }
        return template;
    }

    private Map<String, List<String>> getRelationships() {
        this.readLock.lock();
        try {
            if (this.relationships == null) {
                this.readLock.unlock();
                this.writeLock.lock();
                try {
                    if (this.relationships == null) {
                        this.relationships = this.getAssetFactory().getSourceRelationships(this.getId());
                        if (this.relationships != null) {
                            this.relationships = Collections.unmodifiableMap(this.relationships);
                        }
                    }
                }
                finally {
                    this.readLock.lock();
                    this.writeLock.unlock();
                }
            }
            Map<String, List<String>> map = this.relationships;
            return map;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public Map<String, Rendition> getRenditions() {
        return this.getAssetFactory().getRenditions(this.getId());
    }
}

