/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.wcm.client.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import org.alfresco.wcm.client.AssetFactory;
import org.alfresco.wcm.client.CollectionFactory;
import org.alfresco.wcm.client.DictionaryService;
import org.alfresco.wcm.client.Section;
import org.alfresco.wcm.client.SectionFactory;
import org.alfresco.wcm.client.Tag;
import org.alfresco.wcm.client.impl.SectionImpl;
import org.alfresco.wcm.client.impl.TagImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractCachingSectionFactoryImpl
implements SectionFactory {
    protected static final String PROPERTY_TAG_SUMMARY = "cm:tagScopeSummary";
    private static final Log log = LogFactory.getLog(AbstractCachingSectionFactoryImpl.class);
    private long sectionsRefreshAfter;
    private ConcurrentMap<String, Section> sectionsById = new ConcurrentSkipListMap<String, Section>();
    private Map<String, SectionCache> rootSectionsByWebsite = new ConcurrentSkipListMap<String, SectionCache>();
    private ConcurrentMap<String, String> sectionsBeingLoaded = new ConcurrentSkipListMap<String, String>();
    private AssetFactory assetFactory;
    private DictionaryService dictionaryService;
    private CollectionFactory collectionFactory;

    @Override
    public void setAssetFactory(AssetFactory assetFactory) {
        this.assetFactory = assetFactory;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setCollectionFactory(CollectionFactory collectionFactory) {
        this.collectionFactory = collectionFactory;
    }

    public AssetFactory getAssetFactory() {
        return this.assetFactory;
    }

    public DictionaryService getDictionaryService() {
        return this.dictionaryService;
    }

    public CollectionFactory getCollectionFactory() {
        return this.collectionFactory;
    }

    protected List<Tag> createTags(List<String> tagSummary) {
        ArrayList<Tag> tags = new ArrayList<Tag>();
        if (tagSummary != null) {
            for (String tag : tagSummary) {
                String[] nameCountPair = tag.split("=");
                if (nameCountPair.length != 2) continue;
                try {
                    tags.add(new TagImpl(nameCountPair[0], Integer.parseInt(nameCountPair[1])));
                }
                catch (Exception ex) {
                    log.warn((Object)("Ignoring invalid tag summary data: " + tag));
                }
            }
        }
        return tags;
    }

    @Override
    public Section getSection(String id) {
        Map<String, Section> loadedSections;
        Section section = (Section)this.sectionsById.get(id);
        if (section == null && (loadedSections = this.findSectionWithChildren(id)) != null) {
            this.sectionsById.putAll(loadedSections);
            section = (Section)this.sectionsById.get(id);
        }
        return section;
    }

    @Override
    public Section getSectionFromPathSegments(String rootSectionId, String[] pathSegments) {
        this.refreshCacheIfRequired(rootSectionId);
        SectionCache cache = this.rootSectionsByWebsite.get(rootSectionId);
        Section currentSection = cache.rootSection;
        for (String segment : pathSegments) {
            if (segment.length() > 0) {
                currentSection = currentSection.getSection(segment);
            }
            if (currentSection != null) continue;
            return null;
        }
        return currentSection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshCacheIfRequired(String rootSectionId) {
        SectionCache cache = this.rootSectionsByWebsite.get(rootSectionId);
        while (cache == null || cache.isExpired()) {
            String string;
            String existingSectionToken = this.sectionsBeingLoaded.putIfAbsent(rootSectionId, rootSectionId);
            if (existingSectionToken == null) {
                try {
                    cache = this.rootSectionsByWebsite.get(rootSectionId);
                    if (cache != null && !cache.isExpired()) {
                        return;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)(Thread.currentThread().getName() + " started refreshing tree cache for section " + rootSectionId));
                    }
                    Map<String, Section> sections = this.findSectionWithChildren(rootSectionId);
                    Section rootSection = sections.get(rootSectionId);
                    SectionCache cachedRootSection = new SectionCache(rootSection);
                    this.rootSectionsByWebsite.put(rootSectionId, cachedRootSection);
                    this.sectionsById.putAll(sections);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)(Thread.currentThread().getName() + " finished refreshing tree cache for section " + rootSectionId));
                    }
                    return;
                }
                finally {
                    string = rootSectionId;
                    synchronized (string) {
                        this.sectionsBeingLoaded.remove(rootSectionId);
                        rootSectionId.notifyAll();
                    }
                }
            }
            if (cache != null) {
                return;
            }
            string = existingSectionToken;
            synchronized (string) {
                if (this.sectionsBeingLoaded.containsKey(existingSectionToken)) {
                    try {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)(Thread.currentThread().getName() + " started waiting for section tree to be loaded " + rootSectionId));
                        }
                        existingSectionToken.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)(Thread.currentThread().getName() + " finished waiting for section tree to be loaded " + rootSectionId));
                    }
                }
            }
            cache = this.rootSectionsByWebsite.get(rootSectionId);
        }
    }

    protected abstract Map<String, Section> findSectionWithChildren(String var1);

    public void setSectionsRefreshAfter(int seconds) {
        this.sectionsRefreshAfter = seconds * 1000;
    }

    private class SectionCache {
        Section rootSection;
        long sectionsRefeshedAt;

        SectionCache(Section root) {
            this.rootSection = root;
            this.sectionsRefeshedAt = System.currentTimeMillis();
        }

        boolean isExpired() {
            long now = System.currentTimeMillis();
            long difference = now - this.sectionsRefeshedAt;
            return difference > AbstractCachingSectionFactoryImpl.this.sectionsRefreshAfter;
        }
    }

    protected class SectionDetails {
        SectionImpl section;
        String objectTypeId;
        String parentId;

        protected SectionDetails() {
        }
    }
}

