/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.wcm.client.impl;

import java.io.Serializable;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.alfresco.wcm.client.Asset;
import org.alfresco.wcm.client.AssetFactory;
import org.alfresco.wcm.client.CollectionFactory;
import org.alfresco.wcm.client.ContentStream;
import org.alfresco.wcm.client.Query;
import org.alfresco.wcm.client.Rendition;
import org.alfresco.wcm.client.SearchResult;
import org.alfresco.wcm.client.SearchResults;
import org.alfresco.wcm.client.SectionFactory;
import org.alfresco.wcm.client.impl.AssetImpl;
import org.alfresco.wcm.client.impl.ContentStreamCmisImpl;
import org.alfresco.wcm.client.impl.ContentStreamCmisRenditionImpl;
import org.alfresco.wcm.client.impl.DeferredLoadingAssetImpl;
import org.alfresco.wcm.client.impl.DeferredLoadingAssetListImpl;
import org.alfresco.wcm.client.impl.SearchResultAssetImpl;
import org.alfresco.wcm.client.impl.SearchResultsImpl;
import org.alfresco.wcm.client.util.CmisSessionHelper;
import org.alfresco.wcm.client.util.SqlUtils;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.ItemIterable;
import org.apache.chemistry.opencmis.client.api.ObjectId;
import org.apache.chemistry.opencmis.client.api.OperationContext;
import org.apache.chemistry.opencmis.client.api.QueryResult;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.client.runtime.ObjectIdImpl;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.ObjectList;
import org.apache.chemistry.opencmis.commons.data.PropertyData;
import org.apache.chemistry.opencmis.commons.enums.RelationshipDirection;
import org.apache.chemistry.opencmis.commons.spi.ObjectService;
import org.apache.chemistry.opencmis.commons.spi.RelationshipService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AssetFactoryCmisImpl
implements AssetFactory {
    private static final Log log = LogFactory.getLog(AssetFactoryCmisImpl.class);
    private SectionFactory sectionFactory;
    private CollectionFactory collectionFactory;
    private static final String COMMON_ASSET_SELECT_CLAUSE = "SELECT d.cmis:objectId, d.cmis:objectTypeId, d.cmis:name, d.cmis:contentStreamLength, d.cmis:contentStreamMimeType, d.cmis:lastModificationDate, t.cm:title, t.cm:description, wa.ws:parentSections, wa.ws:publishedTime, wa.ws:derivedCommentCount, wa.ws:derivedAverageRating, wa.ws:tags, a.cm:author ";
    private static final String COMMON_ASSET_FROM_CLAUSE = "FROM cmis:document AS d JOIN ws:webasset AS wa ON d.cmis:objectId = wa.cmis:objectId JOIN cm:author AS a ON d.cmis:objectId = a.cmis:objectId JOIN cm:titled AS t ON d.cmis:objectId = t.cmis:objectId ";
    private final String assetByIdQueryPattern = "SELECT d.cmis:objectId, d.cmis:objectTypeId, d.cmis:name, d.cmis:contentStreamLength, d.cmis:contentStreamMimeType, d.cmis:lastModificationDate, t.cm:title, t.cm:description, wa.ws:parentSections, wa.ws:publishedTime, wa.ws:derivedCommentCount, wa.ws:derivedAverageRating, wa.ws:tags, a.cm:author FROM cmis:document AS d JOIN ws:webasset AS wa ON d.cmis:objectId = wa.cmis:objectId JOIN cm:author AS a ON d.cmis:objectId = a.cmis:objectId JOIN cm:titled AS t ON d.cmis:objectId = t.cmis:objectId WHERE d.cmis:objectId = ''{0}''";
    private final String assetsByIdQueryPattern = "SELECT d.cmis:objectId, d.cmis:objectTypeId, d.cmis:name, d.cmis:contentStreamLength, d.cmis:contentStreamMimeType, d.cmis:lastModificationDate, t.cm:title, t.cm:description, wa.ws:parentSections, wa.ws:publishedTime, wa.ws:derivedCommentCount, wa.ws:derivedAverageRating, wa.ws:tags, a.cm:author FROM cmis:document AS d JOIN ws:webasset AS wa ON d.cmis:objectId = wa.cmis:objectId JOIN cm:author AS a ON d.cmis:objectId = a.cmis:objectId JOIN cm:titled AS t ON d.cmis:objectId = t.cmis:objectId WHERE d.cmis:objectId IN ({0})";
    private final String assetBySectionAndNameQueryPattern = "SELECT d.cmis:objectId, d.cmis:objectTypeId, d.cmis:name, d.cmis:contentStreamLength, d.cmis:contentStreamMimeType, d.cmis:lastModificationDate, t.cm:title, t.cm:description, wa.ws:parentSections, wa.ws:publishedTime, wa.ws:derivedCommentCount, wa.ws:derivedAverageRating, wa.ws:tags, a.cm:author FROM cmis:document AS d JOIN ws:webasset AS wa ON d.cmis:objectId = wa.cmis:objectId JOIN cm:author AS a ON d.cmis:objectId = a.cmis:objectId JOIN cm:titled AS t ON d.cmis:objectId = t.cmis:objectId WHERE ANY wa.ws:parentSections IN (''{0}'') AND d.cmis:name = ''{1}''";
    private final String assetBySectionAndNameWildcardQueryPattern = "SELECT d.cmis:objectId, d.cmis:objectTypeId, d.cmis:name, d.cmis:contentStreamLength, d.cmis:contentStreamMimeType, d.cmis:lastModificationDate, t.cm:title, t.cm:description, wa.ws:parentSections, wa.ws:publishedTime, wa.ws:derivedCommentCount, wa.ws:derivedAverageRating, wa.ws:tags, a.cm:author FROM cmis:document AS d JOIN ws:webasset AS wa ON d.cmis:objectId = wa.cmis:objectId JOIN cm:author AS a ON d.cmis:objectId = a.cmis:objectId JOIN cm:titled AS t ON d.cmis:objectId = t.cmis:objectId WHERE ANY wa.ws:parentSections IN (''{0}'') AND d.cmis:name like ''{1}''";
    private final String assetByFtsQueryPattern = "SELECT d.cmis:objectId, d.cmis:objectTypeId, d.cmis:name, d.cmis:contentStreamLength, d.cmis:contentStreamMimeType, d.cmis:lastModificationDate, t.cm:title, t.cm:description, wa.ws:parentSections, wa.ws:publishedTime, wa.ws:derivedCommentCount, wa.ws:derivedAverageRating, wa.ws:tags, a.cm:author , SCORE() FROM cmis:document AS d JOIN ws:webasset AS wa ON d.cmis:objectId = wa.cmis:objectId JOIN cm:author AS a ON d.cmis:objectId = a.cmis:objectId JOIN cm:titled AS t ON d.cmis:objectId = t.cmis:objectId WHERE IN_TREE(d, ''{0}'') AND (CONTAINS(d, ''{1}'') OR ANY wa.ws:tags IN ('''*'{1}'*''') OR t.cm:title like ''%{1}%'' OR t.cm:description like ''%{1}%'' ) ";
    private final String assetByTagQueryPattern = "SELECT d.cmis:objectId, d.cmis:objectTypeId, d.cmis:name, d.cmis:contentStreamLength, d.cmis:contentStreamMimeType, d.cmis:lastModificationDate, t.cm:title, t.cm:description, wa.ws:parentSections, wa.ws:publishedTime, wa.ws:derivedCommentCount, wa.ws:derivedAverageRating, wa.ws:tags, a.cm:author , SCORE() FROM cmis:document AS d JOIN ws:webasset AS wa ON d.cmis:objectId = wa.cmis:objectId JOIN cm:author AS a ON d.cmis:objectId = a.cmis:objectId JOIN cm:titled AS t ON d.cmis:objectId = t.cmis:objectId WHERE IN_TREE(d, ''{0}'') AND ANY wa.ws:tags IN (''{1}'') ";
    private final String searchOrderClause = " ORDER BY SEARCH_SCORE ASC";
    private final String modifiedTimeByAssetId = "SELECT d.cmis:lastModificationDate FROM cmis:document AS d WHERE d.cmis:objectId = ''{0}''";
    private final String modifiedTimesByAssetIds = "SELECT d.cmis:objectId, d.cmis:lastModificationDate FROM cmis:document AS d WHERE d.cmis:objectId IN ({0})";

    @Override
    public Asset getAssetById(String id, boolean deferredLoad) {
        Asset asset = null;
        if (deferredLoad) {
            asset = new DeferredLoadingAssetImpl(id, this);
        } else {
            ItemIterable<QueryResult> results = this.runQuery(MessageFormat.format("SELECT d.cmis:objectId, d.cmis:objectTypeId, d.cmis:name, d.cmis:contentStreamLength, d.cmis:contentStreamMimeType, d.cmis:lastModificationDate, t.cm:title, t.cm:description, wa.ws:parentSections, wa.ws:publishedTime, wa.ws:derivedCommentCount, wa.ws:derivedAverageRating, wa.ws:tags, a.cm:author FROM cmis:document AS d JOIN ws:webasset AS wa ON d.cmis:objectId = wa.cmis:objectId JOIN cm:author AS a ON d.cmis:objectId = a.cmis:objectId JOIN cm:titled AS t ON d.cmis:objectId = t.cmis:objectId WHERE d.cmis:objectId = ''{0}''", id));
            Iterator iterator = results.iterator();
            if (iterator.hasNext()) {
                QueryResult result = (QueryResult)iterator.next();
                asset = this.buildAsset(result);
            }
        }
        return asset;
    }

    @Override
    public List<Asset> getAssetsById(Collection<String> ids, boolean deferredLoad) {
        List<Asset> assets;
        if (deferredLoad) {
            assets = new DeferredLoadingAssetListImpl(ids, this);
        } else {
            assets = new ArrayList(ids.size());
            String idList = this.buildIdList(ids);
            ItemIterable<QueryResult> results = this.runQuery(MessageFormat.format("SELECT d.cmis:objectId, d.cmis:objectTypeId, d.cmis:name, d.cmis:contentStreamLength, d.cmis:contentStreamMimeType, d.cmis:lastModificationDate, t.cm:title, t.cm:description, wa.ws:parentSections, wa.ws:publishedTime, wa.ws:derivedCommentCount, wa.ws:derivedAverageRating, wa.ws:tags, a.cm:author FROM cmis:document AS d JOIN ws:webasset AS wa ON d.cmis:objectId = wa.cmis:objectId JOIN cm:author AS a ON d.cmis:objectId = a.cmis:objectId JOIN cm:titled AS t ON d.cmis:objectId = t.cmis:objectId WHERE d.cmis:objectId IN ({0})", idList));
            for (QueryResult result : results) {
                assets.add(this.buildAsset(result));
            }
        }
        return assets;
    }

    @Override
    public Asset getAssetById(String id) {
        return this.getAssetById(id, true);
    }

    @Override
    public List<Asset> getAssetsById(Collection<String> ids) {
        return this.getAssetsById(ids, true);
    }

    @Override
    public Asset getSectionAsset(String sectionId, String resourceName) {
        return this.getSectionAsset(sectionId, resourceName, false);
    }

    @Override
    public Asset getSectionAsset(String sectionId, String resourceName, boolean wildcardsAllowedInName) {
        AssetImpl asset = null;
        ItemIterable<QueryResult> results = this.runQuery(MessageFormat.format(wildcardsAllowedInName ? "SELECT d.cmis:objectId, d.cmis:objectTypeId, d.cmis:name, d.cmis:contentStreamLength, d.cmis:contentStreamMimeType, d.cmis:lastModificationDate, t.cm:title, t.cm:description, wa.ws:parentSections, wa.ws:publishedTime, wa.ws:derivedCommentCount, wa.ws:derivedAverageRating, wa.ws:tags, a.cm:author FROM cmis:document AS d JOIN ws:webasset AS wa ON d.cmis:objectId = wa.cmis:objectId JOIN cm:author AS a ON d.cmis:objectId = a.cmis:objectId JOIN cm:titled AS t ON d.cmis:objectId = t.cmis:objectId WHERE ANY wa.ws:parentSections IN (''{0}'') AND d.cmis:name like ''{1}''" : "SELECT d.cmis:objectId, d.cmis:objectTypeId, d.cmis:name, d.cmis:contentStreamLength, d.cmis:contentStreamMimeType, d.cmis:lastModificationDate, t.cm:title, t.cm:description, wa.ws:parentSections, wa.ws:publishedTime, wa.ws:derivedCommentCount, wa.ws:derivedAverageRating, wa.ws:tags, a.cm:author FROM cmis:document AS d JOIN ws:webasset AS wa ON d.cmis:objectId = wa.cmis:objectId JOIN cm:author AS a ON d.cmis:objectId = a.cmis:objectId JOIN cm:titled AS t ON d.cmis:objectId = t.cmis:objectId WHERE ANY wa.ws:parentSections IN (''{0}'') AND d.cmis:name = ''{1}''", sectionId, resourceName));
        Iterator iterator = results.iterator();
        if (iterator.hasNext()) {
            QueryResult result = (QueryResult)iterator.next();
            asset = this.buildAsset(result);
        }
        return asset;
    }

    @Override
    public SearchResults findByQuery(Query query) {
        String cmisQuery = null;
        if (query.getPhrase() != null && query.getPhrase().length() > 0) {
            cmisQuery = MessageFormat.format("SELECT d.cmis:objectId, d.cmis:objectTypeId, d.cmis:name, d.cmis:contentStreamLength, d.cmis:contentStreamMimeType, d.cmis:lastModificationDate, t.cm:title, t.cm:description, wa.ws:parentSections, wa.ws:publishedTime, wa.ws:derivedCommentCount, wa.ws:derivedAverageRating, wa.ws:tags, a.cm:author , SCORE() FROM cmis:document AS d JOIN ws:webasset AS wa ON d.cmis:objectId = wa.cmis:objectId JOIN cm:author AS a ON d.cmis:objectId = a.cmis:objectId JOIN cm:titled AS t ON d.cmis:objectId = t.cmis:objectId WHERE IN_TREE(d, ''{0}'') AND (CONTAINS(d, ''{1}'') OR ANY wa.ws:tags IN ('''*'{1}'*''') OR t.cm:title like ''%{1}%'' OR t.cm:description like ''%{1}%'' ) ", query.getSectionId(), query.getPhrase());
        } else if (query.getTag() != null && query.getTag().length() > 0) {
            cmisQuery = MessageFormat.format("SELECT d.cmis:objectId, d.cmis:objectTypeId, d.cmis:name, d.cmis:contentStreamLength, d.cmis:contentStreamMimeType, d.cmis:lastModificationDate, t.cm:title, t.cm:description, wa.ws:parentSections, wa.ws:publishedTime, wa.ws:derivedCommentCount, wa.ws:derivedAverageRating, wa.ws:tags, a.cm:author , SCORE() FROM cmis:document AS d JOIN ws:webasset AS wa ON d.cmis:objectId = wa.cmis:objectId JOIN cm:author AS a ON d.cmis:objectId = a.cmis:objectId JOIN cm:titled AS t ON d.cmis:objectId = t.cmis:objectId WHERE IN_TREE(d, ''{0}'') AND ANY wa.ws:tags IN (''{1}'') ", query.getSectionId(), query.getTag());
        }
        SearchResultsImpl searchResults = new SearchResultsImpl();
        searchResults.setQuery(new Query(query));
        if (cmisQuery != null) {
            ItemIterable<QueryResult> results = this.runQuery(cmisQuery, " ORDER BY SEARCH_SCORE ASC");
            ItemIterable page = results.skipTo((long)query.getResultsToSkip()).getPage(query.getMaxResults());
            ArrayList<SearchResult> foundAssets = new ArrayList<SearchResult>((int)page.getPageNumItems());
            for (QueryResult queryResult : page) {
                foundAssets.add(new SearchResultAssetImpl(this.buildAsset(queryResult), ((BigDecimal)queryResult.getPropertyValueByQueryName("SEARCH_SCORE")).scaleByPowerOfTen(2).intValue()));
            }
            searchResults.setResults(foundAssets);
            searchResults.setTotalSize(results.getTotalNumItems());
        }
        return searchResults;
    }

    @Override
    public Map<String, List<String>> getSourceRelationships(String assetId) {
        TreeMap<String, List<String>> result = new TreeMap<String, List<String>>();
        Session session = CmisSessionHelper.getSession();
        if (log.isDebugEnabled()) {
            log.debug((Object)("About to run call CMIS relationship service for: " + assetId));
        }
        RelationshipService relationshipService = session.getBinding().getRelationshipService();
        OperationContext ctxt = session.getDefaultContext();
        ObjectService objectService = session.getBinding().getObjectService();
        Map cmisProperties = objectService.getProperties(session.getRepositoryInfo().getId(), assetId, null, null).getProperties();
        String objectId = (String)((PropertyData)cmisProperties.get("cmis:objectId")).getFirstValue();
        ObjectList relList = relationshipService.getObjectRelationships(session.getRepositoryInfo().getId(), objectId, Boolean.valueOf(true), RelationshipDirection.SOURCE, null, ctxt.getFilterString(), Boolean.valueOf(ctxt.isIncludeAllowableActions()), null, null, null);
        if (relList.getObjects() != null) {
            for (ObjectData rod : relList.getObjects()) {
                ArrayList<String> currentTargets;
                Map props = rod.getProperties().getProperties();
                PropertyData targetIdData = (PropertyData)props.get("cmis:targetId");
                PropertyData assocTypeData = (PropertyData)props.get("cmis:objectTypeId");
                if (targetIdData == null || assocTypeData == null) continue;
                String assocType = assocTypeData.getFirstValue().toString();
                if (assocType.startsWith("R:")) {
                    assocType = assocType.substring(2);
                }
                if ((currentTargets = (ArrayList<String>)result.get(assocType)) == null) {
                    currentTargets = new ArrayList<String>();
                    result.put(assocType, currentTargets);
                }
                currentTargets.add(targetIdData.getFirstValue().toString());
            }
        }
        return result;
    }

    @Override
    public Date getModifiedTimeOfAsset(String assetId) {
        Date modifiedTime = null;
        String cmisQuery = MessageFormat.format("SELECT d.cmis:lastModificationDate FROM cmis:document AS d WHERE d.cmis:objectId = ''{0}''", assetId);
        ItemIterable<QueryResult> results = this.runQuery(cmisQuery);
        Iterator iterator = results.iterator();
        if (iterator.hasNext()) {
            QueryResult result = (QueryResult)iterator.next();
            modifiedTime = SqlUtils.getDateProperty(result, "cmis:lastModificationDate");
        }
        return modifiedTime;
    }

    @Override
    public Map<String, Date> getModifiedTimesOfAssets(Collection<String> assetIds) {
        TreeMap<String, Date> map = new TreeMap<String, Date>();
        String idList = this.buildIdList(assetIds);
        String cmisQuery = MessageFormat.format("SELECT d.cmis:objectId, d.cmis:lastModificationDate FROM cmis:document AS d WHERE d.cmis:objectId IN ({0})", idList);
        ItemIterable<QueryResult> results = this.runQuery(cmisQuery);
        for (QueryResult result : results) {
            Date modifiedTime = SqlUtils.getDateProperty(result, "cmis:lastModificationDate");
            String id = (String)result.getPropertyById("cmis:objectId").getFirstValue();
            map.put(id, modifiedTime);
        }
        return map;
    }

    private String buildIdList(Collection<String> assetIds) {
        boolean first = true;
        StringBuilder builder = new StringBuilder();
        for (String id : assetIds) {
            if (!first) {
                builder.append(',');
            }
            builder.append('\'');
            builder.append(id);
            builder.append('\'');
            first = false;
        }
        return builder.toString();
    }

    @Override
    public Map<String, Rendition> getRenditions(String assetId) {
        TreeMap<String, Rendition> renditionMap = new TreeMap<String, Rendition>();
        if (assetId == null || assetId.length() == 0) {
            throw new IllegalArgumentException("assetId = " + assetId);
        }
        Session session = CmisSessionHelper.getSession();
        OperationContext oc = session.createOperationContext();
        oc.setRenditionFilterString("*");
        List renditions = session.getObject(session.createObjectId(assetId), oc).getRenditions();
        for (org.apache.chemistry.opencmis.client.api.Rendition rendition : renditions) {
            renditionMap.put(rendition.getKind(), new ContentStreamCmisRenditionImpl(rendition));
        }
        return renditionMap;
    }

    protected AssetImpl buildAsset(QueryResult result) {
        AssetImpl asset = new AssetImpl();
        TreeMap<String, Serializable> properties = new TreeMap<String, Serializable>();
        properties.put("cmis:objectId", (Serializable)((Object)((String)result.getPropertyById("cmis:objectId").getFirstValue())));
        properties.put("cmis:objectTypeId", (Serializable)result.getPropertyById("cmis:objectTypeId").getFirstValue());
        properties.put("cmis:name", (Serializable)result.getPropertyById("cmis:name").getFirstValue());
        properties.put("cmis:contentStreamLength", (Serializable)result.getPropertyById("cmis:contentStreamLength").getFirstValue());
        properties.put("cmis:contentStreamMimeType", (Serializable)result.getPropertyById("cmis:contentStreamMimeType").getFirstValue());
        properties.put("cm:title", (Serializable)result.getPropertyById("cm:title").getFirstValue());
        properties.put("cmis:lastModificationDate", SqlUtils.getDateProperty(result, "cmis:lastModificationDate"));
        properties.put("cm:description", (Serializable)result.getPropertyById("cm:description").getFirstValue());
        properties.put("ws:derivedAverageRating", (Serializable)result.getPropertyById("ws:derivedAverageRating").getFirstValue());
        properties.put("ws:derivedCommentCount", (Serializable)result.getPropertyById("ws:derivedCommentCount").getFirstValue());
        properties.put("ws:tags", (Serializable)((Object)result.getPropertyMultivalueById("ws:tags")));
        properties.put("ws:publishedTime", SqlUtils.getDateProperty(result, "ws:publishedTime"));
        properties.put("cm:author", (Serializable)result.getPropertyById("cm:author").getFirstValue());
        List parentSectionIds = result.getPropertyMultivalueById("ws:parentSections");
        if (parentSectionIds == null || parentSectionIds.isEmpty()) {
            log.warn((Object)("Retrieved an asset that has no parent sections: " + String.valueOf(properties.get("cmis:objectId"))));
        }
        asset.setProperties(properties);
        asset.setParentSectionIds(parentSectionIds);
        asset.setSectionFactory(this.sectionFactory);
        asset.setCollectionFactory(this.collectionFactory);
        asset.setAssetFactory(this);
        return asset;
    }

    private ItemIterable<QueryResult> runQuery(String query) {
        return this.runQuery(query, null, false);
    }

    private ItemIterable<QueryResult> runQuery(String query, String orderByClause) {
        return this.runQuery(query, orderByClause, false);
    }

    private ItemIterable<QueryResult> runQuery(String query, String orderByClause, boolean forceUnavailableAssets) {
        if (orderByClause != null) {
            query = (String)query + orderByClause;
        }
        long start = 0L;
        if (log.isDebugEnabled()) {
            log.debug((Object)("About to run CMIS query: " + (String)query));
            start = System.currentTimeMillis();
        }
        Session session = CmisSessionHelper.getSession();
        ItemIterable results = session.query((String)query, false);
        if (log.isDebugEnabled()) {
            long end = System.currentTimeMillis();
            log.debug((Object)("CMIS query took " + (end - start) + "ms to return."));
        }
        return results;
    }

    public void setSectionFactory(SectionFactory sectionFactory) {
        this.sectionFactory = sectionFactory;
        sectionFactory.setAssetFactory(this);
    }

    public void setCollectionFactory(CollectionFactory collectionFactory) {
        this.collectionFactory = collectionFactory;
    }

    @Override
    public ContentStream getContentStream(String assetId) {
        Session session = CmisSessionHelper.getSession();
        CmisObject object = session.getObject((ObjectId)new ObjectIdImpl(assetId));
        if (!(object instanceof Document)) {
            throw new IllegalArgumentException("Object referenced by the uuid is not a document");
        }
        Document doc = (Document)object;
        if (doc == null) {
            return null;
        }
        return new ContentStreamCmisImpl(doc.getContentStream());
    }
}

