/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.wcm.client;

import java.util.Date;
import java.util.List;
import java.util.Random;
import org.alfresco.wcm.client.Asset;
import org.alfresco.wcm.client.BaseTest;
import org.alfresco.wcm.client.Section;
import org.alfresco.wcm.client.UgcService;
import org.alfresco.wcm.client.VisitorFeedback;
import org.alfresco.wcm.client.VisitorFeedbackPage;
import org.alfresco.wcm.client.WebSite;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UgcServiceTest
extends BaseTest {
    private static final Log log = LogFactory.getLog(UgcServiceTest.class);

    public void testPostFeedback() {
        WebSite site = this.getWebSite();
        Section root = site.getRootSection();
        String rootId = root.getId();
        Asset indexAsset = this.assetFactory.getSectionAsset(root.getId(), "index.html");
        UgcServiceTest.assertEquals((String)"index.html", (String)indexAsset.getName());
        UgcServiceTest.assertEquals((String)rootId, (String)indexAsset.getContainingSection().getId());
        log.info((Object)("Article id = " + indexAsset.getId()));
        Date beforePost = new Date();
        String feedbackId = site.getUgcService().postFeedback(indexAsset.getId(), "Brian", "brian@theworld", "www.brian.com", "Comment", null, "This is a fantastic article", new Random(System.currentTimeMillis()).nextInt(6));
        Date afterPost = new Date();
        long count = 0L;
        VisitorFeedbackPage page = site.getUgcService().getFeedbackPage(indexAsset.getId(), 10, count);
        long totalSize = page.getTotalSize();
        boolean found = false;
        while (page.getSize() > 0) {
            List feedbackList = page.getFeedback();
            for (VisitorFeedback feedback : feedbackList) {
                ++count;
                if (found || !(found = feedback.getId().equals(feedbackId))) continue;
                Date feedbackTime = feedback.getPostTime();
                UgcServiceTest.assertNotNull((Object)feedbackTime);
                UgcServiceTest.assertTrue((feedbackTime.after(beforePost) || feedbackTime.equals(beforePost) ? 1 : 0) != 0);
                UgcServiceTest.assertTrue((feedbackTime.before(afterPost) || feedbackTime.equals(afterPost) ? 1 : 0) != 0);
            }
            page = site.getUgcService().getFeedbackPage(indexAsset.getId(), 10, count);
        }
        UgcServiceTest.assertEquals((long)totalSize, (long)count);
        UgcServiceTest.assertTrue((boolean)found);
    }

    public void testFormId() {
        WebSite site = this.getWebSite();
        UgcService ugcService = site.getUgcService();
        UgcServiceTest.assertFalse((boolean)ugcService.validateFormId("A random identifier"));
        String formId = ugcService.getFormId();
        UgcServiceTest.assertTrue((boolean)ugcService.validateFormId(formId));
        UgcServiceTest.assertFalse((boolean)ugcService.validateFormId(formId));
    }
}

