/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.wcm.client;

import java.util.ArrayList;
import java.util.List;
import org.alfresco.wcm.client.Asset;
import org.alfresco.wcm.client.BaseTest;
import org.alfresco.wcm.client.Query;
import org.alfresco.wcm.client.SearchResults;
import org.alfresco.wcm.client.Section;
import org.alfresco.wcm.client.WebSite;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AssetFactoryTest
extends BaseTest {
    private static final Log log = LogFactory.getLog(AssetFactoryTest.class);

    public void testGetIndexAsset() {
        WebSite site = this.getWebSite();
        Section root = site.getRootSection();
        String rootId = root.getId();
        Asset indexAsset = this.assetFactory.getSectionAsset(rootId, "index.html");
        AssetFactoryTest.assertEquals((String)"index.html", (String)indexAsset.getName());
        AssetFactoryTest.assertEquals((String)rootId, (String)indexAsset.getContainingSection().getId());
        Asset indexAsset2 = this.assetFactory.getAssetById(indexAsset.getId());
        AssetFactoryTest.assertEquals((String)indexAsset.getId(), (String)indexAsset2.getId());
        AssetFactoryTest.assertEquals((String)indexAsset.getName(), (String)indexAsset2.getName());
        AssetFactoryTest.assertEquals((Object)indexAsset.getProperties(), (Object)indexAsset2.getProperties());
        log.info((Object)indexAsset.getProperties());
        List sections = site.getRootSection().getSections();
        ArrayList<String> indexPageIds = new ArrayList<String>();
        for (Section section : sections) {
            indexPageIds.add(this.assetFactory.getSectionAsset(section.getId(), "index.html").getId());
        }
        List assets = this.assetFactory.getAssetsById(indexPageIds);
        for (Asset asset : assets) {
            AssetFactoryTest.assertTrue((boolean)indexPageIds.remove(asset.getId()));
        }
        AssetFactoryTest.assertTrue((boolean)indexPageIds.isEmpty());
    }

    public void testSearch() {
        WebSite site = this.getWebSite();
        Section rootSection = site.getRootSection();
        Query query = rootSection.createQuery();
        AssetFactoryTest.assertEquals((String)rootSection.getId(), (String)query.getSectionId());
        query.setPhrase("test");
        SearchResults results = this.assetFactory.findByQuery(query);
        log.debug((Object)("Result count = " + results.getTotalSize()));
        query.setPhrase(null);
        query.setTag("potato");
        results = this.assetFactory.findByQuery(query);
        log.debug((Object)("Result count = " + results.getTotalSize()));
    }

    public void testRenditions() {
    }

    public void testRelationships() {
    }
}

