/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.wcm.client.impl;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.alfresco.wcm.client.AssetFactory;
import org.alfresco.wcm.client.CollectionFactory;
import org.alfresco.wcm.client.Resource;
import org.alfresco.wcm.client.Section;
import org.alfresco.wcm.client.SectionFactory;
import org.alfresco.wcm.client.impl.ContentInfo;

public abstract class ResourceBaseImpl
implements Resource {
    private static final long serialVersionUID = 2137271248424335766L;
    private Map<String, Serializable> properties = new TreeMap<String, Serializable>();
    private SectionFactory sectionFactory;
    private AssetFactory assetFactory;
    private CollectionFactory collectionFactory;
    private String primarySectionId;
    private String id;
    private String typeId;
    private String name;

    public void setProperties(Map<String, Serializable> props) {
        this.properties = new TreeMap<String, Serializable>(props);
        this.mimicCmisProperties();
        this.id = (String)((Object)this.properties.get("cmis:objectId"));
        this.typeId = (String)((Object)this.properties.get("cmis:objectTypeId"));
        this.name = (String)((Object)this.properties.get("cmis:name"));
        this.properties = Collections.unmodifiableMap(this.properties);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getTitle() {
        return (String)((Object)this.properties.get("cm:title"));
    }

    @Override
    public String getType() {
        return (String)((Object)this.properties.get("cmis:objectTypeId"));
    }

    @Override
    public String getDescription() {
        return (String)((Object)this.properties.get("cm:description"));
    }

    @Override
    public Section getContainingSection() {
        Section section = this.primarySectionId == null ? null : this.getSectionFactory().getSection(this.primarySectionId);
        return section;
    }

    @Override
    public Serializable getProperty(String propertyName) {
        return this.properties.get(propertyName);
    }

    @Override
    public Map<String, Serializable> getProperties() {
        return this.properties;
    }

    public SectionFactory getSectionFactory() {
        return this.sectionFactory;
    }

    public void setSectionFactory(SectionFactory sectionFactory) {
        this.sectionFactory = sectionFactory;
    }

    public AssetFactory getAssetFactory() {
        return this.assetFactory;
    }

    public void setAssetFactory(AssetFactory resourceFactory) {
        this.assetFactory = resourceFactory;
    }

    public CollectionFactory getCollectionFactory() {
        return this.collectionFactory;
    }

    public void setCollectionFactory(CollectionFactory collectionFactory) {
        this.collectionFactory = collectionFactory;
    }

    public void setPrimarySectionId(String sectionId) {
        this.primarySectionId = sectionId;
    }

    public String getPrimarySectionId() {
        return this.primarySectionId;
    }

    private void mimicCmisProperties() {
        if (this.properties.get("cmis:objectId") == null) {
            this.properties.put("cmis:objectId", this.properties.get("id"));
            String typeName = (String)((Object)this.properties.get("type"));
            if ("cm:content".equals(typeName)) {
                typeName = "cmis:document";
            } else if ("cm:folder".equals(typeName)) {
                typeName = "cmis:folder";
            }
            this.properties.put("cmis:objectTypeId", (Serializable)((Object)typeName));
            this.properties.put("cmis:name", this.properties.get("cm:name"));
            this.properties.put("cmis:lastModificationDate", this.properties.get("cm:modified"));
            ContentInfo contentInfo = (ContentInfo)this.properties.get("cm:content");
            if (contentInfo != null) {
                this.properties.put("cmis:contentStreamLength", BigInteger.valueOf(contentInfo.getSize()));
                this.properties.put("cmis:contentStreamMimeType", (Serializable)((Object)contentInfo.getMimeType()));
            }
        }
    }
}

