/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.transformer.logging;

import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Deque;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;

@Deprecated
public final class LogEntry {
    private static final Logger logger = LoggerFactory.getLogger(LogEntry.class);
    private static final AtomicInteger count = new AtomicInteger(0);
    private static final Deque<LogEntry> log = new ConcurrentLinkedDeque<LogEntry>();
    private static final int MAX_LOG_SIZE = 10;
    private static final SimpleDateFormat HH_MM_SS = new SimpleDateFormat("HH:mm:ss");
    private static final ThreadLocal<LogEntry> currentLogEntry = ThreadLocal.withInitial(() -> {
        LogEntry logEntry = new LogEntry();
        if (log.size() >= 10) {
            log.removeLast();
        }
        log.addFirst(logEntry);
        return logEntry;
    });
    private final int id = count.incrementAndGet();
    private final long start = System.currentTimeMillis();
    private int statusCode;
    private long durationStreamIn;
    private long durationTransform = -1L;
    private long durationStreamOut = -1L;
    private long durationDelay = -1L;
    private String source;
    private long sourceSize;
    private String target;
    private long targetSize = -1L;
    private String options;
    private String message;

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.append(sb, Integer.toString(this.getId()));
        this.append(sb, HH_MM_SS.format(this.getDate()));
        this.append(sb, Integer.toString(this.getStatusCode()));
        this.append(sb, this.getDuration());
        this.append(sb, this.getSource());
        this.append(sb, this.getSourceSize());
        this.append(sb, this.getTarget());
        this.append(sb, this.getTargetSize());
        this.append(sb, this.getOptions());
        sb.append(this.getMessage());
        return sb.toString();
    }

    private void append(StringBuilder sb, String value) {
        if (value != null && !value.isEmpty() && !"0bytes".equals(value)) {
            sb.append(value);
            sb.append(' ');
        }
    }

    public static Collection<LogEntry> getLog() {
        return log;
    }

    public static void start() {
        currentLogEntry.get();
    }

    public static void setSource(String source, long sourceSize) {
        LogEntry logEntry = currentLogEntry.get();
        logEntry.source = LogEntry.getExtension(source);
        logEntry.sourceSize = sourceSize;
        logEntry.durationStreamIn = System.currentTimeMillis() - logEntry.start;
    }

    public static void setTarget(String target) {
        LogEntry.currentLogEntry.get().target = LogEntry.getExtension(target);
    }

    private static String getExtension(String filename) {
        int i = filename.lastIndexOf(46);
        if (i != -1) {
            filename = filename.substring(i + 1);
        }
        return filename;
    }

    public static void setTargetSize(long targetSize) {
        LogEntry.currentLogEntry.get().targetSize = targetSize;
    }

    public static void setOptions(String options) {
        LogEntry.currentLogEntry.get().options = options;
    }

    public static long setStatusCodeAndMessage(int statusCode, String message) {
        LogEntry logEntry = currentLogEntry.get();
        logEntry.statusCode = statusCode;
        logEntry.message = message;
        logEntry.durationTransform = System.currentTimeMillis() - logEntry.start - logEntry.durationStreamIn;
        return logEntry.durationTransform;
    }

    public static long addDelay(Long testDelay) {
        long durationDelay = 0L;
        if (testDelay != null && testDelay > 0L) {
            durationDelay = currentLogEntry.get().addDelayInternal(testDelay);
        }
        return durationDelay;
    }

    private long addDelayInternal(Long testDelay) {
        long durationDelay = Math.max(testDelay - System.currentTimeMillis() + this.start, -1L);
        if (durationDelay > 0L) {
            try {
                Thread.sleep(durationDelay);
            }
            catch (InterruptedException ignore) {
                Thread.currentThread().interrupt();
            }
            this.durationDelay = durationDelay;
            return durationDelay;
        }
        this.durationDelay = -1L;
        return 0L;
    }

    public static void complete() {
        LogEntry logEntry = currentLogEntry.get();
        if (logEntry.statusCode == HttpStatus.OK.value()) {
            logEntry.durationStreamOut = System.currentTimeMillis() - logEntry.start - logEntry.durationStreamIn - Math.max(logEntry.durationTransform, 0L) - Math.max(logEntry.durationDelay, 0L);
        }
        currentLogEntry.remove();
        if (logger.isDebugEnabled()) {
            logger.debug(logEntry.toString());
        }
    }

    public int getId() {
        return this.id;
    }

    public Date getDate() {
        return new Date(this.start);
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getDuration() {
        long duration = this.durationStreamIn + Math.max(this.durationTransform, 0L) + Math.max(this.durationDelay, 0L) + Math.max(this.durationStreamOut, 0L);
        return duration <= 5L ? "" : this.time(duration) + " (" + (this.time(this.durationStreamIn) + " " + this.time(this.durationTransform) + " " + (String)(this.durationDelay > 0L ? this.time(this.durationDelay) + " " + (this.durationStreamOut < 0L ? "-" : this.time(this.durationStreamOut)) : this.time(this.durationStreamOut))).trim() + ")";
    }

    public String getSource() {
        return this.source;
    }

    public String getSourceSize() {
        return this.size(this.sourceSize);
    }

    public String getTarget() {
        return this.target;
    }

    public String getTargetSize() {
        return this.size(this.targetSize);
    }

    public String getOptions() {
        return this.options;
    }

    public String getMessage() {
        return this.message;
    }

    private String time(long ms) {
        return ms == -1L ? "" : this.size(ms, "1ms", new String[]{"ms", "s", "min", "hr"}, new long[]{1000L, 60000L, 3600000L, Long.MAX_VALUE});
    }

    private String size(long size) {
        return size == -1L ? "" : this.size(size, "1 byte", new String[]{"bytes", " KB", " MB", " GB", " TB"}, new long[]{1024L, 0x100000L, 0x40000000L, 0L, Long.MAX_VALUE});
    }

    private String size(long size, String singleValue, String[] units, long[] dividers) {
        if (size == 1L) {
            return singleValue;
        }
        long divider = 1L;
        for (int i = 0; i < units.length - 1; ++i) {
            long nextDivider = dividers[i];
            if (size < nextDivider) {
                return this.unitFormat(size, divider, units[i]);
            }
            divider = nextDivider;
        }
        return this.unitFormat(size, divider, units[units.length - 1]);
    }

    private String unitFormat(long size, long divider, String unit) {
        size = size * 10L / divider;
        int decimalPoint = (int)size % 10;
        StringBuilder sb = new StringBuilder();
        sb.append(size / 10L);
        if (decimalPoint != 0) {
            sb.append(".");
            sb.append(decimalPoint);
        }
        sb.append(unit);
        return sb.toString();
    }
}

