/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.transformer.metadataExtractors;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.slf4j.Logger;

@Deprecated
public abstract class AbstractMetadataExtractor {
    private static final String EXTRACT = "extract";
    private static final String EMBED = "embed";
    private static final String METADATA = "metadata";
    private static final String EXTRACT_MAPPING = "extractMapping";
    private static final String NAMESPACE_PROPERTY_PREFIX = "namespace.prefix.";
    private static final char NAMESPACE_PREFIX = ':';
    private static final char NAMESPACE_BEGIN = '{';
    private static final char NAMESPACE_END = '}';
    private static final List<String> SYS_PROPERTIES = Arrays.asList("sys:overwritePolicy", "sys:enableStringTagging", "sys:carryAspectProperties", "sys:stringTaggingSeparators");
    private static final ObjectMapper jsonObjectMapper = new ObjectMapper();
    protected final Logger logger;
    private Map<String, Set<String>> defaultExtractMapping;
    private ThreadLocal<Map<String, Set<String>>> extractMapping = new ThreadLocal();
    private Map<String, Set<String>> embedMapping;

    public AbstractMetadataExtractor(Logger logger) {
        this.logger = logger;
        this.defaultExtractMapping = Collections.emptyMap();
        this.embedMapping = Collections.emptyMap();
        try {
            this.defaultExtractMapping = this.buildExtractMapping();
            this.embedMapping = this.buildEmbedMapping();
        }
        catch (Exception e) {
            logger.error("Failed to read config", (Throwable)e);
        }
    }

    public abstract Map<String, Serializable> extractMetadata(String var1, Map<String, String> var2, File var3) throws Exception;

    public void embedMetadata(String sourceMimetype, String targetMimetype, Map<String, String> transformOptions, File sourceFile, File targetFile) throws Exception {
    }

    protected Map<String, Serializable> getMetadata(Map<String, String> transformOptions) {
        String metadataAsJson = transformOptions.get(METADATA);
        if (metadataAsJson == null) {
            throw new IllegalArgumentException("No metadata in embed request");
        }
        try {
            TypeReference<HashMap<String, Serializable>> typeRef = new TypeReference<HashMap<String, Serializable>>(){};
            HashMap systemProperties = (HashMap)jsonObjectMapper.readValue(metadataAsJson, (TypeReference)typeRef);
            Map<String, Serializable> rawProperties = this.mapSystemToRaw(systemProperties);
            return rawProperties;
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Failed to read metadata from request", e);
        }
    }

    private Map<String, Serializable> mapSystemToRaw(Map<String, Serializable> systemMetadata) {
        HashMap<String, Serializable> metadataProperties = new HashMap<String, Serializable>(systemMetadata.size() * 2 + 1);
        for (Map.Entry<String, Serializable> entry : systemMetadata.entrySet()) {
            String modelProperty = entry.getKey();
            if (!this.embedMapping.containsKey(modelProperty)) continue;
            Serializable documentValue = entry.getValue();
            Set<String> metadataKeys = this.embedMapping.get(modelProperty);
            for (String metadataKey : metadataKeys) {
                metadataProperties.put(metadataKey, documentValue);
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Converted system model values to metadata values: \n   System Properties:    " + String.valueOf(systemMetadata) + "\n   Metadata Properties: " + String.valueOf(metadataProperties));
        }
        return metadataProperties;
    }

    protected Map<String, Set<String>> getExtractMapping() {
        return Collections.unmodifiableMap(this.extractMapping.get());
    }

    public Map<String, Set<String>> getEmbedMapping() {
        return Collections.unmodifiableMap(this.embedMapping);
    }

    private Map<String, Set<String>> buildExtractMapping() {
        String filename = this.getPropertiesFilename(EXTRACT);
        Properties properties = this.readProperties(filename);
        if (properties == null) {
            this.logger.error("Failed to read " + filename);
        }
        Map<String, String> namespacesByPrefix = this.getNamespaces(properties);
        return this.buildExtractMapping(properties, namespacesByPrefix);
    }

    private Map<String, Set<String>> buildExtractMapping(Properties properties, Map<String, String> namespacesByPrefix) {
        HashMap<String, Set<String>> convertedMapping = new HashMap<String, Set<String>>(17);
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String documentProperty = (String)entry.getKey();
            String qnamesStr = (String)entry.getValue();
            if (documentProperty.startsWith(NAMESPACE_PROPERTY_PREFIX)) continue;
            HashSet<String> qnames = new HashSet<String>(3);
            convertedMapping.put(documentProperty, qnames);
            StringTokenizer tokenizer = new StringTokenizer(qnamesStr, ",");
            while (tokenizer.hasMoreTokens()) {
                String qnameStr = tokenizer.nextToken().trim();
                qnameStr = this.getQNameString(namespacesByPrefix, entry, qnameStr, EXTRACT);
                qnames.add(qnameStr);
            }
            if (!this.logger.isTraceEnabled()) continue;
            this.logger.trace("Added mapping from " + documentProperty + " to " + String.valueOf(qnames));
        }
        return convertedMapping;
    }

    private Map<String, Set<String>> buildEmbedMapping() {
        Map<String, Set<String>> embedMapping;
        String filename = this.getPropertiesFilename(EMBED);
        Properties properties = this.readProperties(filename);
        if (properties != null) {
            Map<String, String> namespacesByPrefix = this.getNamespaces(properties);
            embedMapping = this.buildEmbedMapping(properties, namespacesByPrefix);
        } else {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("No " + filename + ", assuming reverse of extract mapping");
            }
            embedMapping = this.buildEmbedMappingByReversingExtract();
        }
        return embedMapping;
    }

    private Map<String, Set<String>> buildEmbedMapping(Properties properties, Map<String, String> namespacesByPrefix) {
        HashMap<String, Set<String>> convertedMapping = new HashMap<String, Set<String>>(17);
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String modelProperty = (String)entry.getKey();
            String metadataKeysString = (String)entry.getValue();
            if (modelProperty.startsWith(NAMESPACE_PROPERTY_PREFIX)) continue;
            modelProperty = this.getQNameString(namespacesByPrefix, entry, modelProperty, EMBED);
            String[] metadataKeysArray = metadataKeysString.split(",");
            HashSet<String> metadataKeys = new HashSet<String>(metadataKeysArray.length);
            for (String metadataKey : metadataKeysArray) {
                metadataKeys.add(metadataKey.trim());
            }
            convertedMapping.put(modelProperty, metadataKeys);
            if (!this.logger.isTraceEnabled()) continue;
            this.logger.trace("Added mapping from " + modelProperty + " to " + metadataKeysString);
        }
        return convertedMapping;
    }

    private Map<String, Set<String>> buildEmbedMappingByReversingExtract() {
        Map<String, Set<String>> extractMapping = this.buildExtractMapping();
        HashMap<String, Set<String>> embedMapping = new HashMap<String, Set<String>>(extractMapping.size());
        for (String metadataKey : extractMapping.keySet()) {
            if (extractMapping.get(metadataKey) == null || extractMapping.get(metadataKey).size() <= 0) continue;
            String modelProperty = extractMapping.get(metadataKey).iterator().next();
            HashSet<String> metadataKeys = (HashSet<String>)embedMapping.get(modelProperty);
            if (metadataKeys == null) {
                metadataKeys = new HashSet<String>(1);
                embedMapping.put(modelProperty, metadataKeys);
            }
            metadataKeys.add(metadataKey);
            if (!this.logger.isTraceEnabled()) continue;
            this.logger.trace("Added mapping from " + modelProperty + " to " + ((Object)metadataKeys).toString());
        }
        return embedMapping;
    }

    private String getPropertiesFilename(String suffix) {
        String className = this.getClass().getName();
        String shortClassName = className.split("\\.")[className.split("\\.").length - 1];
        shortClassName = shortClassName.replace('$', '-');
        return shortClassName + "_metadata_" + suffix + ".properties";
    }

    private Properties readProperties(String filename) {
        Properties properties = null;
        try {
            InputStream inputStream = AbstractMetadataExtractor.class.getClassLoader().getResourceAsStream(filename);
            if (inputStream != null) {
                properties = new Properties();
                properties.load(inputStream);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return properties;
    }

    private Map<String, String> getNamespaces(Properties properties) {
        HashMap<String, String> namespacesByPrefix = new HashMap<String, String>(5);
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String propertyName = (String)entry.getKey();
            if (!propertyName.startsWith(NAMESPACE_PROPERTY_PREFIX)) continue;
            String prefix = propertyName.substring(17);
            String namespace = (String)entry.getValue();
            namespacesByPrefix.put(prefix, namespace);
        }
        return namespacesByPrefix;
    }

    private String getQNameString(Map<String, String> namespacesByPrefix, Map.Entry<Object, Object> entry, String qnameStr, String type) {
        int index = ((String)qnameStr).indexOf(58);
        if (index > -1 && ((String)qnameStr).charAt(0) != '{') {
            String prefix = ((String)qnameStr).substring(0, index);
            String suffix = ((String)qnameStr).substring(index + 1);
            String uri = namespacesByPrefix.get(prefix);
            if (uri == null) {
                throw new IllegalArgumentException("No prefix mapping for " + type + " property mapping: \n   Extractor: " + String.valueOf(this) + "\n   Mapping: " + String.valueOf(entry));
            }
            qnameStr = "{" + uri + "}" + suffix;
        }
        return qnameStr;
    }

    protected boolean putRawValue(String key, Serializable value, Map<String, Serializable> destination) {
        if (value != null) {
            if (value instanceof String) {
                String valueStr = ((String)value).trim();
                if (valueStr.length() == 0) {
                    value = null;
                } else {
                    if (valueStr.indexOf("\u0000") != -1) {
                        valueStr = valueStr.replaceAll("\u0000", "");
                    }
                    value = valueStr;
                }
            } else if (value instanceof Collection) {
                Collection valueCollection = (Collection)value;
                if (valueCollection.isEmpty()) {
                    value = null;
                }
            } else if (value.getClass().isArray() && Array.getLength(value) == 0) {
                value = null;
            }
        }
        destination.put(key, (Serializable)value);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void extractMetadata(String sourceMimetype, Map<String, String> transformOptions, File sourceFile, File targetFile) throws Exception {
        Map<String, Set<String>> mapping = this.getExtractMappingFromOptions(transformOptions, this.defaultExtractMapping);
        try {
            this.extractMapping.set(mapping);
            Map<String, Serializable> metadata = this.extractMetadata(sourceMimetype, transformOptions, sourceFile);
            this.mapMetadataAndWrite(targetFile, metadata, mapping);
        }
        finally {
            this.extractMapping.set(null);
        }
    }

    private Map<String, Set<String>> getExtractMappingFromOptions(Map<String, String> transformOptions, Map<String, Set<String>> defaultExtractMapping) {
        String extractMappingOption = transformOptions.get(EXTRACT_MAPPING);
        if (extractMappingOption != null) {
            try {
                TypeReference<HashMap<String, Set<String>>> typeRef = new TypeReference<HashMap<String, Set<String>>>(){};
                return (Map)jsonObjectMapper.readValue(extractMappingOption, (TypeReference)typeRef);
            }
            catch (JsonProcessingException e) {
                throw new IllegalArgumentException("Failed to read extractMapping from request", e);
            }
        }
        return defaultExtractMapping;
    }

    @Deprecated
    public void mapMetadataAndWrite(File targetFile, Map<String, Serializable> metadata) throws IOException {
        this.mapMetadataAndWrite(targetFile, metadata, this.defaultExtractMapping);
    }

    public void mapMetadataAndWrite(File targetFile, Map<String, Serializable> metadata, Map<String, Set<String>> extractMapping) throws IOException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Raw metadata:");
            metadata.forEach((k, v) -> this.logger.debug("  " + k + "=" + String.valueOf(v)));
        }
        metadata = this.mapRawToSystem(metadata, extractMapping);
        this.writeMetadata(targetFile, metadata);
    }

    private Map<String, Serializable> mapRawToSystem(Map<String, Serializable> rawMetadata, Map<String, Set<String>> extractMapping) {
        boolean debugEnabled = this.logger.isDebugEnabled();
        if (debugEnabled) {
            this.logger.debug("Returned metadata:");
        }
        HashMap<String, Serializable> systemProperties = new HashMap<String, Serializable>(rawMetadata.size() * 2 + 1);
        for (Map.Entry<String, Serializable> entry : rawMetadata.entrySet()) {
            String documentKey = entry.getKey();
            Serializable documentValue = entry.getValue();
            if (SYS_PROPERTIES.contains(documentKey)) {
                systemProperties.put(documentKey, documentValue);
                if (!debugEnabled) continue;
                this.logger.debug("  " + documentKey + "=" + String.valueOf(documentValue));
                continue;
            }
            if (!extractMapping.containsKey(documentKey)) continue;
            Set<String> systemQNames = extractMapping.get(documentKey);
            for (String systemQName : systemQNames) {
                if (debugEnabled) {
                    this.logger.debug("  " + systemQName + "=" + String.valueOf(documentValue) + " (" + documentKey + ")");
                }
                systemProperties.put(systemQName, documentValue);
            }
        }
        return new TreeMap<String, Serializable>(systemProperties);
    }

    private void writeMetadata(File targetFile, Map<String, Serializable> results) throws IOException {
        jsonObjectMapper.writeValue(targetFile, results);
    }
}

