/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.transformer.config;

import java.io.IOException;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.ssl.HostnameVerifier;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.ssl.NoopHostnameVerifier;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactoryBuilder;
import org.apache.hc.core5.http.config.Registry;
import org.apache.hc.core5.http.config.RegistryBuilder;
import org.apache.hc.core5.http.ssl.TLS;
import org.apache.hc.core5.ssl.SSLContextBuilder;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.Resource;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.web.client.RestTemplate;

@Deprecated
@Configuration
public class MTLSConfig {
    @Value(value="${client.ssl.key-store:#{null}}")
    private Resource keyStoreResource;
    @Value(value="${client.ssl.key-store-password:}")
    private char[] keyStorePassword;
    @Value(value="${client.ssl.key-store-type:}")
    private String keyStoreType;
    @Value(value="${client.ssl.trust-store:#{null}}")
    private Resource trustStoreResource;
    @Value(value="${client.ssl.trust-store-password:}")
    private char[] trustStorePassword;
    @Value(value="${client.ssl.trust-store-type:}")
    private String trustStoreType;
    @Value(value="${client.ssl.hostname-verification-disabled:false}")
    private boolean hostNameVerificationDisabled;

    @Bean
    public RestTemplate restTemplate(SSLContextBuilder apacheSSLContextBuilder) throws IOException, CertificateException, NoSuchAlgorithmException, KeyStoreException, KeyManagementException, UnrecoverableKeyException {
        if (this.isTlsOrMtlsConfigured()) {
            return this.createRestTemplateWithSslContext(apacheSSLContextBuilder);
        }
        return new RestTemplate();
    }

    @Bean
    public SSLContextBuilder apacheSSLContextBuilder() throws CertificateException, KeyStoreException, IOException, NoSuchAlgorithmException, UnrecoverableKeyException {
        SSLContextBuilder sslContextBuilder = new SSLContextBuilder();
        if (this.isKeystoreConfigured()) {
            KeyStore keyStore = this.getKeyStore(this.keyStoreType, this.keyStoreResource, this.keyStorePassword);
            sslContextBuilder.loadKeyMaterial(keyStore, this.keyStorePassword);
        }
        if (this.isTruststoreConfigured()) {
            sslContextBuilder.setKeyStoreType(this.trustStoreType).loadTrustMaterial(this.trustStoreResource.getURL(), this.trustStorePassword);
        }
        return sslContextBuilder;
    }

    private boolean isTlsOrMtlsConfigured() {
        return this.isTruststoreConfigured() || this.isKeystoreConfigured();
    }

    private boolean isTruststoreConfigured() {
        return this.trustStoreResource != null;
    }

    private boolean isKeystoreConfigured() {
        return this.keyStoreResource != null;
    }

    private RestTemplate createRestTemplateWithSslContext(SSLContextBuilder sslContextBuilder) throws NoSuchAlgorithmException, KeyManagementException {
        SSLConnectionSocketFactoryBuilder sslConnectionSocketFactoryBuilder = SSLConnectionSocketFactoryBuilder.create().setSslContext(sslContextBuilder.build()).setTlsVersions(new TLS[]{TLS.V_1_2, TLS.V_1_3});
        if (this.hostNameVerificationDisabled) {
            sslConnectionSocketFactoryBuilder.setHostnameVerifier((HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        }
        SSLConnectionSocketFactory sslConnectionSocketFactory = sslConnectionSocketFactoryBuilder.build();
        Registry sslSocketFactoryRegistry = RegistryBuilder.create().register("https", (Object)sslConnectionSocketFactory).build();
        PoolingHttpClientConnectionManager sslConnectionManager = new PoolingHttpClientConnectionManager(sslSocketFactoryRegistry);
        HttpClientBuilder httpClientBuilder = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)sslConnectionManager);
        CloseableHttpClient httpClient = httpClientBuilder.build();
        HttpComponentsClientHttpRequestFactory requestFactory = new HttpComponentsClientHttpRequestFactory((HttpClient)httpClient);
        return new RestTemplate((ClientHttpRequestFactory)requestFactory);
    }

    private KeyStore getKeyStore(String keyStoreType, Resource keyStoreResource, char[] keyStorePassword) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        KeyStore keyStore = KeyStore.getInstance(keyStoreType);
        try (InputStream keyStoreInputStream = keyStoreResource.getInputStream();){
            keyStore.load(keyStoreInputStream, keyStorePassword);
        }
        return keyStore;
    }
}

