/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.transformer;

import jakarta.servlet.http.HttpServletRequest;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.alfresco.transform.client.model.InternalContext;
import org.alfresco.transform.client.model.TransformReply;
import org.alfresco.transform.client.model.TransformRequest;
import org.alfresco.transform.common.TransformerDebug;
import org.alfresco.transform.config.CoreVersionDecorator;
import org.alfresco.transform.config.TransformConfig;
import org.alfresco.transform.exceptions.TransformException;
import org.alfresco.transform.messages.TransformRequestValidator;
import org.alfresco.transform.registry.TransformServiceRegistry;
import org.alfresco.transformer.TransformController;
import org.alfresco.transformer.TransformRegistryImpl;
import org.alfresco.transformer.clients.AlfrescoSharedFileStoreClient;
import org.alfresco.transformer.fs.FileManager;
import org.alfresco.transformer.logging.LogEntry;
import org.alfresco.transformer.model.FileRefResponse;
import org.codehaus.plexus.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.StringUtils;
import org.springframework.validation.DirectFieldBindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.multipart.MultipartFile;

@Deprecated
public abstract class AbstractTransformerController
implements TransformController {
    private static final Logger logger = LoggerFactory.getLogger(AbstractTransformerController.class);
    public static final List<String> NON_TRANSFORM_OPTION_REQUEST_PARAMETERS = Arrays.asList("sourceExtension", "targetExtension", "targetMimetype", "sourceMimetype", "testDelay", "transformName", "directAccessUrl");
    @Autowired
    private AlfrescoSharedFileStoreClient alfrescoSharedFileStoreClient;
    @Autowired
    private TransformRequestValidator transformRequestValidator;
    @Autowired
    private TransformServiceRegistry transformRegistry;
    @Autowired
    private TransformerDebug transformerDebug;
    private AtomicInteger httpRequestCount = new AtomicInteger(1);

    @GetMapping(value={"/transform/config"})
    public ResponseEntity<TransformConfig> info(@RequestParam(value="configVersion", defaultValue="1") int configVersion) {
        logger.info("GET Transform Config version: " + configVersion);
        TransformConfig transformConfig = ((TransformRegistryImpl)this.transformRegistry).getTransformConfig();
        transformConfig = CoreVersionDecorator.setOrClearCoreVersion((TransformConfig)transformConfig, (int)configVersion);
        return new ResponseEntity((Object)transformConfig, (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/transform"}, consumes={"multipart/form-data"})
    public ResponseEntity<Resource> transform(HttpServletRequest request, @RequestParam(value="file", required=false) MultipartFile sourceMultipartFile, @RequestParam(value="targetExtension") String targetExtension, @RequestParam(value="sourceMimetype", required=false) String sourceMimetype, @RequestParam(value="targetMimetype", required=false) String targetMimetype, @RequestParam Map<String, String> requestParameters, @RequestParam(value="testDelay", required=false) Long testDelay, @RequestParam(value="transformName", required=false) String requestTransformName) {
        String sourceFilename;
        File sourceFile;
        String directUrl;
        if (logger.isDebugEnabled()) {
            logger.debug("Processing request via HTTP endpoint. Params: sourceMimetype: '{}', targetMimetype: '{}', targetExtension: '{}', requestParameters: {}", new Object[]{sourceMimetype, targetMimetype, targetExtension, requestParameters});
        }
        if ((directUrl = requestParameters.getOrDefault("directAccessUrl", "")).isBlank()) {
            if (sourceMultipartFile == null) {
                throw new TransformException(HttpStatus.BAD_REQUEST, "Required request part 'file' is not present");
            }
            sourceFile = FileManager.createSourceFile(request, sourceMultipartFile);
            sourceFilename = sourceMultipartFile.getOriginalFilename();
        } else {
            sourceFile = this.getSourceFileFromDirectUrl(directUrl);
            sourceFilename = sourceFile.getName();
        }
        String targetFilename = FileManager.createTargetFileName(sourceFilename, targetExtension);
        this.getProbeTestTransform().incrementTransformerCount();
        File targetFile = FileManager.createTargetFile(request, targetFilename);
        Map<String, String> transformOptions = this.getTransformOptions(requestParameters);
        String transformName = this.getTransformerName(sourceMimetype, targetMimetype, requestTransformName, sourceFile, transformOptions);
        String reference = "e" + this.httpRequestCount.getAndIncrement();
        this.transformerDebug.pushTransform(reference, sourceMimetype, targetMimetype, sourceFile, transformName);
        this.transformerDebug.logOptions(reference, requestParameters);
        try {
            this.transformImpl(transformName, sourceMimetype, targetMimetype, transformOptions, sourceFile, targetFile);
            ResponseEntity<Resource> body = FileManager.createAttachment(targetFilename, targetFile);
            LogEntry.setTargetSize(targetFile.length());
            long time = LogEntry.setStatusCodeAndMessage(HttpStatus.OK.value(), "Success");
            this.getProbeTestTransform().recordTransformTime(time += LogEntry.addDelay(testDelay));
            this.transformerDebug.popTransform(reference, time);
            return body;
        }
        catch (Throwable t) {
            this.transformerDebug.logFailure(reference, t.getMessage());
            throw t;
        }
    }

    private File getSourceFileFromDirectUrl(String directUrl) {
        File sourceFile = FileManager.TempFileProvider.createTempFile("tmp", ".tmp");
        try {
            FileUtils.copyURLToFile((URL)new URL(directUrl), (File)sourceFile);
        }
        catch (IllegalArgumentException e) {
            throw new TransformException(HttpStatus.BAD_REQUEST, "Direct Access Url is invalid.", (Throwable)e);
        }
        catch (IOException e) {
            throw new TransformException(HttpStatus.BAD_REQUEST, "Direct Access Url not found.", (Throwable)e);
        }
        return sourceFile;
    }

    protected Map<String, String> getTransformOptions(Map<String, String> requestParameters) {
        HashMap<String, String> transformOptions = new HashMap<String, String>(requestParameters);
        transformOptions.keySet().removeAll(NON_TRANSFORM_OPTION_REQUEST_PARAMETERS);
        transformOptions.values().removeIf(v -> v.isEmpty());
        return transformOptions;
    }

    @Override
    @PostMapping(value={"/transform"}, produces={"application/json"})
    @ResponseBody
    public ResponseEntity<TransformReply> transform(@RequestBody TransformRequest request, @RequestParam(value="timeout", required=false) Long timeout) {
        FileRefResponse targetRef;
        File sourceFile;
        logger.trace("Received {}, timeout {} ms", (Object)request, (Object)timeout);
        TransformReply reply = new TransformReply();
        reply.setRequestId(request.getRequestId());
        reply.setSourceReference(request.getSourceReference());
        reply.setSchema(request.getSchema());
        reply.setClientData(request.getClientData());
        Errors errors = this.validateTransformRequest(request);
        this.validateInternalContext(request, errors);
        this.initialiseContext(request);
        reply.setInternalContext(request.getInternalContext());
        if (!errors.getAllErrors().isEmpty()) {
            reply.setStatus(HttpStatus.BAD_REQUEST.value());
            reply.setErrorDetails(errors.getAllErrors().stream().map(Object::toString).collect(Collectors.joining(", ")));
            this.transformerDebug.logFailure(reply);
            logger.trace("Invalid request, sending {}", (Object)reply);
            return new ResponseEntity((Object)reply, (HttpStatusCode)HttpStatus.valueOf((int)reply.getStatus()));
        }
        this.transformerDebug.pushTransform(request);
        try {
            String directUrl = request.getTransformRequestOptions().getOrDefault("directAccessUrl", "");
            sourceFile = directUrl.isBlank() ? this.loadSourceFile(request.getSourceReference(), request.getSourceExtension()) : this.getSourceFileFromDirectUrl(directUrl);
        }
        catch (TransformException e) {
            reply.setStatus(e.getStatusCode());
            reply.setErrorDetails(AbstractTransformerController.messageWithCause("Failed at reading the source file", e));
            this.transformerDebug.logFailure(reply);
            logger.trace("Failed to load source file (TransformException), sending " + String.valueOf(reply));
            return new ResponseEntity((Object)reply, (HttpStatusCode)HttpStatus.valueOf((int)reply.getStatus()));
        }
        catch (HttpClientErrorException e) {
            reply.setStatus(e.getStatusCode().value());
            reply.setErrorDetails(AbstractTransformerController.messageWithCause("Failed at reading the source file", e));
            this.transformerDebug.logFailure(reply);
            logger.trace("Failed to load source file (HttpClientErrorException), sending " + String.valueOf(reply), (Throwable)e);
            return new ResponseEntity((Object)reply, (HttpStatusCode)HttpStatus.valueOf((int)reply.getStatus()));
        }
        catch (Exception e) {
            reply.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
            reply.setErrorDetails(AbstractTransformerController.messageWithCause("Failed at reading the source file", e));
            this.transformerDebug.logFailure(reply);
            logger.trace("Failed to load source file (Exception), sending " + String.valueOf(reply), (Throwable)e);
            return new ResponseEntity((Object)reply, (HttpStatusCode)HttpStatus.valueOf((int)reply.getStatus()));
        }
        String targetFilename = FileManager.createTargetFileName(sourceFile.getName(), request.getTargetExtension());
        File targetFile = FileManager.buildFile(targetFilename);
        try {
            String targetMimetype = request.getTargetMediaType();
            String sourceMimetype = request.getSourceMediaType();
            Map<String, String> transformOptions = this.getTransformOptions(request.getTransformRequestOptions());
            this.transformerDebug.logOptions(request);
            String transformName = this.getTransformerName(sourceFile, sourceMimetype, targetMimetype, transformOptions);
            this.transformImpl(transformName, sourceMimetype, targetMimetype, transformOptions, sourceFile, targetFile);
            reply.getInternalContext().setCurrentSourceSize(Long.valueOf(targetFile.length()));
        }
        catch (TransformException e) {
            reply.setStatus(e.getStatusCode());
            reply.setErrorDetails(AbstractTransformerController.messageWithCause("Failed at processing transformation", e));
            this.transformerDebug.logFailure(reply);
            logger.trace("Failed to perform transform (TransformException), sending " + String.valueOf(reply), (Throwable)e);
            return new ResponseEntity((Object)reply, (HttpStatusCode)HttpStatus.valueOf((int)reply.getStatus()));
        }
        catch (Exception e) {
            reply.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
            reply.setErrorDetails(AbstractTransformerController.messageWithCause("Failed at processing transformation", e));
            this.transformerDebug.logFailure(reply);
            logger.trace("Failed to perform transform (Exception), sending " + String.valueOf(reply), (Throwable)e);
            return new ResponseEntity((Object)reply, (HttpStatusCode)HttpStatus.valueOf((int)reply.getStatus()));
        }
        try {
            targetRef = this.alfrescoSharedFileStoreClient.saveFile(targetFile);
        }
        catch (TransformException e) {
            reply.setStatus(e.getStatusCode());
            reply.setErrorDetails(AbstractTransformerController.messageWithCause("Failed at writing the transformed file", e));
            this.transformerDebug.logFailure(reply);
            logger.trace("Failed to save target file (TransformException), sending " + String.valueOf(reply), (Throwable)e);
            return new ResponseEntity((Object)reply, (HttpStatusCode)HttpStatus.valueOf((int)reply.getStatus()));
        }
        catch (HttpClientErrorException e) {
            reply.setStatus(e.getStatusCode().value());
            reply.setErrorDetails(AbstractTransformerController.messageWithCause("Failed at writing the transformed file. ", e));
            this.transformerDebug.logFailure(reply);
            logger.trace("Failed to save target file (HttpClientErrorException), sending " + String.valueOf(reply), (Throwable)e);
            return new ResponseEntity((Object)reply, (HttpStatusCode)HttpStatus.valueOf((int)reply.getStatus()));
        }
        catch (Exception e) {
            reply.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
            reply.setErrorDetails(AbstractTransformerController.messageWithCause("Failed at writing the transformed file. ", e));
            this.transformerDebug.logFailure(reply);
            logger.trace("Failed to save target file (Exception), sending " + String.valueOf(reply), (Throwable)e);
            return new ResponseEntity((Object)reply, (HttpStatusCode)HttpStatus.valueOf((int)reply.getStatus()));
        }
        try {
            FileManager.deleteFile(targetFile);
        }
        catch (Exception e) {
            logger.error("Failed to delete local temp target file '{}'. Error will be ignored ", (Object)targetFile, (Object)e);
        }
        try {
            FileManager.deleteFile(sourceFile);
        }
        catch (Exception e) {
            logger.error("Failed to delete source local temp file " + String.valueOf(sourceFile), (Throwable)e);
        }
        reply.setTargetReference(targetRef.getEntry().getFileRef());
        reply.setStatus(HttpStatus.CREATED.value());
        this.transformerDebug.popTransform(reply);
        logger.trace("Sending successful {}, timeout {} ms", (Object)reply, (Object)timeout);
        return new ResponseEntity((Object)reply, (HttpStatusCode)HttpStatus.valueOf((int)reply.getStatus()));
    }

    private Errors validateTransformRequest(TransformRequest transformRequest) {
        DirectFieldBindingResult errors = new DirectFieldBindingResult((Object)transformRequest, "request");
        this.transformRequestValidator.validate((Object)transformRequest, (Errors)errors);
        return errors;
    }

    private void validateInternalContext(TransformRequest request, Errors errors) {
        String errorMessage = InternalContext.checkForBasicErrors((InternalContext)request.getInternalContext(), (String)"T-Request");
        if (errorMessage != null) {
            errors.rejectValue("internalContext", null, errorMessage);
        }
    }

    private void initialiseContext(TransformRequest request) {
        request.setInternalContext(InternalContext.initialise((InternalContext)request.getInternalContext()));
    }

    private File loadSourceFile(String sourceReference, String sourceExtension) {
        ResponseEntity<Resource> responseEntity = this.alfrescoSharedFileStoreClient.retrieveFile(sourceReference);
        this.getProbeTestTransform().incrementTransformerCount();
        HttpHeaders headers = responseEntity.getHeaders();
        String filename = FileManager.getFilenameFromContentDisposition(headers);
        String extension = StringUtils.getFilenameExtension((String)filename) != null ? StringUtils.getFilenameExtension((String)filename) : sourceExtension;
        MediaType contentType = headers.getContentType();
        long size = headers.getContentLength();
        Resource body = (Resource)responseEntity.getBody();
        if (body == null) {
            String message = "Source file with reference: " + sourceReference + " is null or empty. Transformation will fail and stop now as there is no content to be transformed.";
            logger.warn(message);
            throw new TransformException(HttpStatus.BAD_REQUEST, message);
        }
        File file = FileManager.TempFileProvider.createTempFile("source_", "." + extension);
        logger.debug("Read source content {} length={} contentType={}", new Object[]{sourceReference, size, contentType});
        FileManager.save(body, file);
        LogEntry.setSource(filename, size);
        return file;
    }

    private static String messageWithCause(String prefix, Throwable e) {
        StringBuilder sb = new StringBuilder();
        sb.append(prefix).append(" - ").append(e.getClass().getSimpleName()).append(": ").append(e.getMessage());
        while (e.getCause() != null) {
            e = e.getCause();
            sb.append(", cause ").append(e.getClass().getSimpleName()).append(": ").append(e.getMessage());
        }
        return sb.toString();
    }

    private String getTransformerName(String sourceMimetype, String targetMimetype, String requestTransformName, File sourceFile, Map<String, String> transformOptions) {
        String transformName = requestTransformName;
        if (transformName == null || transformName.isEmpty()) {
            transformName = this.getTransformerName(sourceFile, sourceMimetype, targetMimetype, transformOptions);
        } else if (logger.isInfoEnabled()) {
            logger.trace("Using transform name provided in the request: " + requestTransformName);
        }
        return transformName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getTransformerName(File sourceFile, String sourceMimetype, String targetMimetype, Map<String, String> transformOptions) {
        String sourceEncoding = transformOptions.remove("sourceEncoding");
        try {
            long sourceSizeInBytes = sourceFile.length();
            String transformerName = this.transformRegistry.findTransformerName(sourceMimetype, sourceSizeInBytes, targetMimetype, transformOptions, null);
            if (transformerName == null) {
                throw new TransformException(HttpStatus.BAD_REQUEST, "No transforms for:");
            }
            String string = transformerName;
            return string;
        }
        finally {
            if (sourceEncoding != null) {
                transformOptions.put("sourceEncoding", sourceEncoding);
            }
        }
    }

    protected Map<String, String> createTransformOptions(Object ... namesAndValues) {
        if (namesAndValues.length % 2 != 0) {
            logger.error("Incorrect number of parameters. Should have an even number as they are names and values.");
        }
        HashMap<String, String> transformOptions = new HashMap<String, String>();
        for (int i = 0; i < namesAndValues.length; i += 2) {
            String name = namesAndValues[i].toString();
            Object value = namesAndValues[i + 1];
            if (value == null || value instanceof String && ((String)value).isBlank()) continue;
            transformOptions.put(name, value.toString());
        }
        return transformOptions;
    }
}

