/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.transformer.messaging;

import jakarta.jms.ConnectionFactory;
import jakarta.jms.Queue;
import org.alfresco.transform.messages.TransformRequestValidator;
import org.alfresco.transformer.messaging.TransformMessageConverter;
import org.apache.activemq.command.ActiveMQQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jms.annotation.JmsListenerConfigurer;
import org.springframework.jms.config.DefaultJmsListenerContainerFactory;
import org.springframework.jms.config.JmsListenerEndpointRegistrar;
import org.springframework.jms.connection.JmsTransactionManager;
import org.springframework.jms.support.converter.MessageConverter;
import org.springframework.lang.NonNull;
import org.springframework.messaging.handler.annotation.support.DefaultMessageHandlerMethodFactory;
import org.springframework.messaging.handler.annotation.support.MessageHandlerMethodFactory;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.validation.Validator;

@Deprecated
@Configuration
@ConditionalOnProperty(name={"activemq.url"})
public class MessagingConfig
implements JmsListenerConfigurer {
    private static final Logger logger = LoggerFactory.getLogger(MessagingConfig.class);

    public void configureJmsListeners(@NonNull JmsListenerEndpointRegistrar registrar) {
        registrar.setMessageHandlerMethodFactory((MessageHandlerMethodFactory)this.methodFactory());
    }

    @Bean
    @ConditionalOnProperty(name={"activemq.url"})
    public DefaultMessageHandlerMethodFactory methodFactory() {
        DefaultMessageHandlerMethodFactory factory = new DefaultMessageHandlerMethodFactory();
        factory.setValidator((Validator)new TransformRequestValidator());
        return factory;
    }

    @Bean
    @ConditionalOnProperty(name={"activemq.url"})
    public DefaultJmsListenerContainerFactory jmsListenerContainerFactory(ConnectionFactory connectionFactory, TransformMessageConverter transformMessageConverter) {
        DefaultJmsListenerContainerFactory factory = new DefaultJmsListenerContainerFactory();
        factory.setConnectionFactory(connectionFactory);
        factory.setMessageConverter((MessageConverter)transformMessageConverter);
        factory.setErrorHandler(t -> logger.error("JMS error: " + t.getMessage(), t));
        factory.setTransactionManager(this.transactionManager(connectionFactory));
        return factory;
    }

    @Bean
    @ConditionalOnProperty(name={"activemq.url"})
    public PlatformTransactionManager transactionManager(ConnectionFactory connectionFactory) {
        JmsTransactionManager transactionManager = new JmsTransactionManager();
        transactionManager.setConnectionFactory(connectionFactory);
        return transactionManager;
    }

    @Bean
    @ConditionalOnProperty(name={"activemq.url"})
    public Queue engineRequestQueue(@Value(value="${queue.engineRequestQueue}") String engineRequestQueueValue) {
        return new ActiveMQQueue(engineRequestQueueValue);
    }
}

