/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.transformer.fs;

import jakarta.servlet.http.HttpServletRequest;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import org.alfresco.transform.exceptions.TransformException;
import org.alfresco.transformer.logging.LogEntry;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.util.UriUtils;

@Deprecated
public class FileManager {
    public static final String SOURCE_FILE = "sourceFile";
    public static final String TARGET_FILE = "targetFile";
    private static final String FILENAME = "filename=";

    public static File createTargetFile(HttpServletRequest request, String filename) {
        File file = FileManager.buildFile(filename);
        request.setAttribute(TARGET_FILE, (Object)file);
        return file;
    }

    public static File buildFile(String filename) {
        filename = FileManager.checkFilename(false, filename);
        LogEntry.setTarget(filename);
        return TempFileProvider.createTempFile("target_", "_" + filename);
    }

    public static void deleteFile(File file) throws Exception {
        if (!file.delete()) {
            throw new Exception("Failed to delete file");
        }
    }

    private static String checkFilename(boolean source, String filename) {
        if ((filename = StringUtils.getFilename((String)filename)) == null || filename.isEmpty()) {
            String sourceOrTarget = source ? "source" : "target";
            HttpStatus statusCode = source ? HttpStatus.BAD_REQUEST : HttpStatus.INTERNAL_SERVER_ERROR;
            throw new TransformException(statusCode, "The " + sourceOrTarget + " filename was not supplied");
        }
        return filename;
    }

    private static void save(MultipartFile multipartFile, File file) {
        try {
            Files.copy(multipartFile.getInputStream(), file.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new TransformException(HttpStatus.INSUFFICIENT_STORAGE, "Failed to store the source file", (Throwable)e);
        }
    }

    public static void save(Resource body, File file) {
        try {
            Files.copy(body.getInputStream(), file.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new TransformException(HttpStatus.INSUFFICIENT_STORAGE, "Failed to store the source file", (Throwable)e);
        }
    }

    private static Resource load(File file) {
        try {
            UrlResource resource = new UrlResource(file.toURI());
            if (resource.exists() || resource.isReadable()) {
                return resource;
            }
            throw new TransformException(HttpStatus.INTERNAL_SERVER_ERROR, "Could not read the target file: " + file.getPath());
        }
        catch (MalformedURLException e) {
            throw new TransformException(HttpStatus.INTERNAL_SERVER_ERROR, "The target filename was malformed: " + file.getPath(), (Throwable)e);
        }
    }

    public static String getFilenameFromContentDisposition(HttpHeaders headers) {
        String filename = "";
        String contentDisposition = headers.getFirst("Content-Disposition");
        if (contentDisposition != null) {
            String[] strings = contentDisposition.split("; *");
            filename = Arrays.stream(strings).filter(s -> s.startsWith(FILENAME)).findFirst().map(s -> s.substring(FILENAME.length())).orElse("");
        }
        return filename;
    }

    public static String createTargetFileName(String fileName, String targetExtension) {
        String sourceFilename = StringUtils.getFilename((String)fileName);
        if (sourceFilename == null || sourceFilename.isEmpty()) {
            return null;
        }
        String ext = StringUtils.getFilenameExtension((String)sourceFilename);
        if (ext == null || ext.isEmpty()) {
            return sourceFilename + "." + targetExtension;
        }
        return sourceFilename.substring(0, sourceFilename.length() - ext.length() - 1) + "." + targetExtension;
    }

    public static File createSourceFile(HttpServletRequest request, MultipartFile multipartFile) {
        String filename = multipartFile.getOriginalFilename();
        long size = multipartFile.getSize();
        filename = FileManager.checkFilename(true, filename);
        File file = TempFileProvider.createTempFile("source_", "_" + filename);
        request.setAttribute(SOURCE_FILE, (Object)file);
        FileManager.save(multipartFile, file);
        LogEntry.setSource(filename, size);
        return file;
    }

    public static void deleteFile(HttpServletRequest request, String attributeName) {
        File file = (File)request.getAttribute(attributeName);
        if (file != null) {
            file.delete();
        }
    }

    public static ResponseEntity<Resource> createAttachment(String targetFilename, File targetFile) {
        Resource targetResource = FileManager.load(targetFile);
        targetFilename = UriUtils.encodePath((String)StringUtils.getFilename((String)targetFilename), (String)"UTF-8");
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Disposition", new String[]{"attachment; filename*=UTF-8''" + targetFilename})).body((Object)targetResource);
    }

    public static class TempFileProvider {
        public static File createTempFile(String prefix, String suffix) {
            File directory = TempFileProvider.getTempDir();
            try {
                return File.createTempFile(prefix, suffix, directory);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to created temp file: \n   prefix: " + prefix + "\n   suffix: " + suffix + "\n   directory: " + String.valueOf(directory), e);
            }
        }

        private static File getTempDir() {
            String dirName = "Alfresco";
            String systemTempDirPath = System.getProperty("java.io.tmpdir");
            if (systemTempDirPath == null) {
                throw new RuntimeException("System property not available: java.io.tmpdir");
            }
            File systemTempDir = new File(systemTempDirPath);
            File tempDir = new File(systemTempDir, "Alfresco");
            if (!(tempDir.exists() || tempDir.mkdirs() || tempDir.exists())) {
                throw new RuntimeException("Failed to create temp directory: " + String.valueOf(tempDir));
            }
            return tempDir;
        }
    }
}

