/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.transform.tika.transformers;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import org.alfresco.transform.base.CustomTransformer;
import org.alfresco.transform.base.TransformManager;
import org.alfresco.transform.base.executors.RuntimeExec;
import org.alfresco.transform.base.logging.LogEntry;
import org.alfresco.transform.tika.transformers.Tika;
import org.apache.tika.extractor.DocumentSelector;
import org.apache.tika.parser.Parser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;

public abstract class AbstractTikaTransformer
implements CustomTransformer {
    private static final Logger logger = LoggerFactory.getLogger(AbstractTikaTransformer.class);
    @Value(value="${transform.core.tika.pdfBox.notExtractBookmarksTextDefault:false}")
    boolean notExtractBookmarksTextDefault;
    @Value(value="${transform.core.tika.exifTool.windowsOS}")
    private String exifToolCommandOnWindows;
    @Value(value="${transform.core.tika.exifTool.unixOS}")
    private String exifToolCommandOnUnix;
    @Autowired
    protected Tika tika;

    protected abstract Parser getParser();

    @Bean(value={"exifTool"})
    public RuntimeExec exifRuntimeExec() {
        RuntimeExec runtimeExec = new RuntimeExec();
        HashMap<String, String[]> commandPerOS = new HashMap<String, String[]>();
        commandPerOS.put("[wW]in.*", this.exifToolCommandOnWindows.split(" "));
        commandPerOS.put("*", this.exifToolCommandOnUnix.split(" "));
        runtimeExec.setCommandsAndArguments(commandPerOS);
        return runtimeExec;
    }

    protected DocumentSelector getDocumentSelector() {
        return null;
    }

    public String getTransformerName() {
        String simpleClassName = this.getClass().getSimpleName();
        return simpleClassName.substring(0, simpleClassName.length() - "Transformer".length());
    }

    public void transform(String sourceMimetype, InputStream inputStream, String targetMimetype, OutputStream outputStream, Map<String, String> transformOptions, TransformManager transformManager) throws Exception {
        boolean includeContents = Boolean.parseBoolean(transformOptions.getOrDefault("includeContents", "false"));
        boolean notExtractBookmarksText = Boolean.parseBoolean(transformOptions.getOrDefault("notExtractBookmarksText", String.valueOf(this.notExtractBookmarksTextDefault)));
        String targetEncoding = transformOptions.getOrDefault("targetEncoding", "UTF-8");
        if (transformOptions.get("notExtractBookmarksText") == null && this.notExtractBookmarksTextDefault) {
            logger.trace("notExtractBookmarksText default value has been overridden to {}", (Object)this.notExtractBookmarksTextDefault);
        }
        this.call(inputStream, outputStream, new String[]{includeContents ? "--includeContents" : null, notExtractBookmarksText ? "--notExtractBookmarksText" : null, "--targetMimetype=" + targetMimetype, "--targetEncoding=" + targetEncoding});
    }

    void call(InputStream inputStream, OutputStream outputStream, String ... args) {
        Parser parser = this.getParser();
        DocumentSelector documentSelector = this.getDocumentSelector();
        this.logArgs(args);
        this.tika.transform(parser, documentSelector, inputStream, outputStream, args);
    }

    private void logArgs(String[] args) {
        StringJoiner sj = new StringJoiner(" ");
        Arrays.stream(args).filter(Objects::nonNull).forEach(arg -> sj.add((CharSequence)arg));
        LogEntry.setOptions((String)sj.toString());
    }
}

