/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.transform.tika.transformers;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import java.util.Objects;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.alfresco.transform.tika.parsers.TikaOfficeDetectParser;
import org.alfresco.transform.tika.transformers.Tika;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.exception.TikaException;
import org.apache.tika.extractor.DocumentSelector;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.parser.EmptyParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.microsoft.OfficeParser;
import org.apache.tika.parser.microsoft.ooxml.OOXMLParser;
import org.apache.tika.parser.pdf.PDFParser;
import org.apache.tika.parser.pdf.PDFParserConfig;
import org.apache.tika.parser.pkg.PackageParser;
import org.apache.tika.sax.BodyContentHandler;
import org.apache.tika.sax.ExpandedTitleContentHandler;
import org.slf4j.Logger;
import org.springframework.stereotype.Component;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class Tika {
    public static final String ARCHIVE = "Archive";
    public static final String OUTLOOK_MSG = "OutlookMsg";
    public static final String PDF_BOX = "PdfBox";
    public static final String OFFICE = "Office";
    public static final String POI = "Poi";
    public static final String OOXML = "OOXML";
    public static final String TIKA_AUTO = "TikaAuto";
    public static final String TEXT_MINING = "TextMining";
    public static final String TARGET_MIMETYPE = "--targetMimetype=";
    public static final String TARGET_ENCODING = "--targetEncoding=";
    public static final String INCLUDE_CONTENTS = "--includeContents";
    public static final String NOT_EXTRACT_BOOKMARKS_TEXT = "--notExtractBookmarksText";
    public static final String CSV = "csv";
    public static final String DOC = "doc";
    public static final String DOCX = "docx";
    public static final String HTML = "html";
    public static final String MSG = "msg";
    public static final String PDF = "pdf";
    public static final String PPTX = "pptx";
    public static final String TXT = "txt";
    public static final String XHTML = "xhtml";
    public static final String XLSX = "xlsx";
    public static final String XML = "xml";
    public static final String ZIP = "zip";
    public static final Parser packageParser = new PackageParser();
    public static final Parser pdfParser = new PDFParser();
    public static final Parser officeParser = new OfficeParser();
    public final Parser autoDetectParser;
    public static final Parser ooXmlParser = new OOXMLParser();
    public static final Parser tikaOfficeDetectParser = new TikaOfficeDetectParser();
    public final PDFParserConfig pdfParserConfig = new PDFParserConfig();
    public static final DocumentSelector pdfBoxEmbededDocumentSelector = new /* Unavailable Anonymous Inner Class!! */;

    public Tika() throws TikaException, IOException, SAXException {
        TikaConfig tikaConfig = Tika.readTikaConfig();
        this.autoDetectParser = new AutoDetectParser(tikaConfig);
    }

    public static TikaConfig readTikaConfig(Logger logger) {
        try {
            return Tika.readTikaConfig();
        }
        catch (Exception e) {
            logger.error("Failed to read tika-config.xml", (Throwable)e);
            return null;
        }
    }

    private static TikaConfig readTikaConfig() throws TikaException, IOException, SAXException {
        ClassLoader classLoader = Tika.class.getClassLoader();
        URL tikaConfigXml = classLoader.getResource("tika-config.xml");
        return new TikaConfig(tikaConfigXml);
    }

    void transform(Parser parser, DocumentSelector documentSelector, InputStream inputStream, OutputStream outputStream, String[] args) {
        String targetMimetype = null;
        String targetEncoding = null;
        Boolean includeContents = null;
        Boolean notExtractBookmarksText = null;
        for (String arg : args) {
            if (Objects.isNull(arg)) continue;
            if (arg.startsWith("--includeContents")) {
                this.getValue(arg, false, (Object)includeContents, "--includeContents");
                includeContents = true;
                continue;
            }
            if (arg.startsWith("--targetEncoding=")) {
                targetEncoding = this.getValue(arg, true, targetEncoding, "--targetEncoding=");
                continue;
            }
            if (arg.startsWith("--targetMimetype=")) {
                targetMimetype = this.getValue(arg, true, targetMimetype, "--targetMimetype=");
                continue;
            }
            if (arg.startsWith("--notExtractBookmarksText")) {
                this.getValue(arg, false, (Object)notExtractBookmarksText, "--notExtractBookmarksText");
                notExtractBookmarksText = true;
                continue;
            }
            throw new IllegalArgumentException("Unexpected argument " + arg);
        }
        includeContents = includeContents == null ? false : includeContents;
        notExtractBookmarksText = notExtractBookmarksText == null ? false : notExtractBookmarksText;
        this.transform(parser, documentSelector, includeContents, notExtractBookmarksText, inputStream, outputStream, targetMimetype, targetEncoding);
    }

    private String getValue(String arg, boolean valueExpected, Object value, String optionName) {
        if (value != null) {
            throw new IllegalArgumentException("Duplicate " + optionName);
        }
        String stringValue = arg.substring(optionName.length()).trim();
        if (!valueExpected && stringValue.length() > 0) {
            throw new IllegalArgumentException("Unexpected value with " + optionName);
        }
        if (valueExpected && stringValue.length() == 0) {
            throw new IllegalArgumentException("Expected value with " + optionName);
        }
        return stringValue;
    }

    private void transform(Parser parser, DocumentSelector documentSelector, Boolean includeContents, Boolean notExtractBookmarksText, InputStream inputStream, OutputStream outputStream, String targetMimetype, String targetEncoding) {
        try (BufferedWriter ow = new BufferedWriter(new OutputStreamWriter(outputStream, targetEncoding));){
            Metadata metadata = new Metadata();
            ParseContext context = this.buildParseContext(documentSelector, includeContents, notExtractBookmarksText);
            ContentHandler handler = this.getContentHandler(targetMimetype, (Writer)ow);
            parser.parse(inputStream, handler, metadata, context);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("Unsupported encoding " + e.getMessage(), e);
        }
        catch (IOException | TikaException | SAXException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    private ContentHandler getContentHandler(String targetMimetype, Writer output) {
        try {
            if ("text/plain".equals(targetMimetype)) {
                return new BodyContentHandler(output);
            }
            if ("text/csv".equals(targetMimetype)) {
                return new CsvContentHandler(output);
            }
            SAXTransformerFactory factory = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
            TransformerHandler transformerHandler = factory.newTransformerHandler();
            Transformer transformer = transformerHandler.getTransformer();
            transformer.setOutputProperty("indent", "yes");
            if ("text/html".equals(targetMimetype)) {
                transformer.setOutputProperty("version", "1.1");
                transformer.setOutputProperty("method", "html");
                transformerHandler.setResult(new StreamResult(output));
                return new ExpandedTitleContentHandler((ContentHandler)transformerHandler);
            }
            if ("application/xhtml+xml".equals(targetMimetype) || "text/xml".equals(targetMimetype)) {
                transformer.setOutputProperty("method", "xml");
                transformerHandler.setResult(new StreamResult(output));
                return transformerHandler;
            }
            throw new IllegalArgumentException("Invalid target mimetype " + targetMimetype);
        }
        catch (TransformerConfigurationException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    private ParseContext buildParseContext(DocumentSelector documentSelector, Boolean includeContents, Boolean notExtractBookmarksText) {
        ParseContext context = new ParseContext();
        if (documentSelector != null) {
            context.set(DocumentSelector.class, (Object)documentSelector);
        }
        if (notExtractBookmarksText.equals(true)) {
            this.pdfParserConfig.setExtractBookmarksText(false);
            context.set(PDFParserConfig.class, (Object)this.pdfParserConfig);
        }
        if (includeContents != null) {
            context.set(Parser.class, includeContents != false ? this.autoDetectParser : new EmptyParser());
        }
        return context;
    }
}

