/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.transform.tika.metadata.extractors;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.alfresco.transform.base.metadata.AbstractMetadataExtractorEmbedder;
import org.alfresco.transform.tika.metadata.AbstractTikaMetadataExtractorEmbeddor;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.odf.OpenDocumentParser;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class OpenDocumentMetadataExtractor
extends AbstractTikaMetadataExtractorEmbeddor {
    private static final Logger logger = LoggerFactory.getLogger(OpenDocumentMetadataExtractor.class);
    private static final String KEY_CREATION_DATE = "creationDate";
    private static final String KEY_CREATOR = "creator";
    private static final String KEY_DATE = "date";
    private static final String KEY_GENERATOR = "generator";
    private static final String KEY_INITIAL_CREATOR = "initialCreator";
    private static final String KEY_KEYWORD = "keyword";
    private static final String KEY_LANGUAGE = "language";
    private static final String KEY_ALFRESCO_CREATOR = "_alfresco:creator";
    private static final String CUSTOM_PREFIX = "custom:";
    private static final DateTimeFormatter dateFormatter = DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ss");

    public OpenDocumentMetadataExtractor() {
        super(AbstractMetadataExtractorEmbedder.Type.EXTRACTOR, logger);
    }

    protected Parser getParser() {
        OpenDocumentParser parser = new OpenDocumentParser();
        parser.setMetaParser((Parser)new /* Unavailable Anonymous Inner Class!! */);
        return parser;
    }

    protected Map<String, Serializable> extractSpecific(Metadata metadata, Map<String, Serializable> properties, Map<String, String> headers) {
        this.putRawValue("creationDate", (Serializable)this.getDateOrNull(metadata.get(TikaCoreProperties.CREATED)), properties);
        String creator = this.getCreator(metadata);
        this.putRawValue("creator", (Serializable)((Object)creator), properties);
        this.putRawValue("author", (Serializable)((Object)creator), properties);
        this.putRawValue("date", (Serializable)this.getDateOrNull(metadata.get(TikaCoreProperties.MODIFIED)), properties);
        this.putRawValue("description", (Serializable)((Object)metadata.get(TikaCoreProperties.DESCRIPTION)), properties);
        this.putRawValue("generator", (Serializable)((Object)metadata.get("generator")), properties);
        this.putRawValue("initialCreator", (Serializable)((Object)metadata.get("initial-creator")), properties);
        this.putRawValue("keyword", (Serializable)((Object)metadata.get(TikaCoreProperties.SUBJECT)), properties);
        this.putRawValue("language", (Serializable)((Object)metadata.get(TikaCoreProperties.LANGUAGE)), properties);
        Map mapping = super.getExtractMapping();
        for (String key : mapping.keySet()) {
            if (metadata.get("custom:" + key) == null) continue;
            this.putRawValue(key, (Serializable)((Object)metadata.get("custom:" + key)), properties);
        }
        return properties;
    }

    private String getCreator(Metadata metadata) {
        List creators = OpenDocumentMetadataExtractor.distinct((String[])metadata.getValues(TikaCoreProperties.CREATOR)).collect(Collectors.toUnmodifiableList());
        if (creators.size() == 1) {
            return (String)creators.get(0);
        }
        return metadata.get("_alfresco:creator");
    }

    private Date getDateOrNull(String dateString) {
        if (dateString != null && dateString.length() != 0) {
            try {
                return dateFormatter.parseDateTime(dateString).toDate();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return null;
    }
}

