/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.transform.tika.metadata.extractors;

import java.io.Serializable;
import java.util.Map;
import org.alfresco.transform.base.metadata.AbstractMetadataExtractorEmbedder;
import org.alfresco.transform.tika.metadata.AbstractTikaMetadataExtractorEmbeddor;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.Office;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.microsoft.OfficeParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class OfficeMetadataExtractor
extends AbstractTikaMetadataExtractorEmbeddor {
    private static final Logger logger = LoggerFactory.getLogger(OfficeMetadataExtractor.class);
    public static final String KEY_CREATE_DATETIME = "createDateTime";
    public static final String KEY_LAST_SAVE_DATETIME = "lastSaveDateTime";
    public static final String KEY_EDIT_TIME = "editTime";
    public static final String KEY_FORMAT = "format";
    public static final String KEY_KEYWORDS = "keywords";
    public static final String KEY_LAST_AUTHOR = "lastAuthor";
    public static final String KEY_LAST_PRINTED = "lastPrinted";
    public static final String KEY_PAGE_COUNT = "pageCount";
    public static final String KEY_PARAGRAPH_COUNT = "paragraphCount";
    public static final String KEY_WORD_COUNT = "wordCount";

    public OfficeMetadataExtractor() {
        super(AbstractMetadataExtractorEmbedder.Type.EXTRACTOR, logger);
    }

    protected Parser getParser() {
        return new OfficeParser();
    }

    protected Map<String, Serializable> extractSpecific(Metadata metadata, Map<String, Serializable> properties, Map<String, String> headers) {
        this.putRawValue(KEY_CREATE_DATETIME, (Serializable)((Object)metadata.get(TikaCoreProperties.CREATED)), properties);
        this.putRawValue(KEY_LAST_SAVE_DATETIME, (Serializable)((Object)metadata.get(TikaCoreProperties.MODIFIED)), properties);
        this.putRawValue(KEY_EDIT_TIME, (Serializable)((Object)metadata.get(TikaCoreProperties.MODIFIED)), properties);
        this.putRawValue(KEY_FORMAT, (Serializable)((Object)metadata.get(TikaCoreProperties.FORMAT)), properties);
        this.putRawValue(KEY_KEYWORDS, (Serializable)((Object)metadata.get(TikaCoreProperties.SUBJECT)), properties);
        this.putRawValue(KEY_LAST_AUTHOR, (Serializable)((Object)metadata.get(TikaCoreProperties.MODIFIER)), properties);
        this.putRawValue(KEY_LAST_PRINTED, (Serializable)((Object)metadata.get(TikaCoreProperties.PRINT_DATE)), properties);
        this.putRawValue(KEY_PAGE_COUNT, (Serializable)((Object)metadata.get(Office.PAGE_COUNT)), properties);
        this.putRawValue(KEY_PARAGRAPH_COUNT, (Serializable)((Object)metadata.get(Office.PARAGRAPH_COUNT)), properties);
        this.putRawValue(KEY_WORD_COUNT, (Serializable)((Object)metadata.get(Office.WORD_COUNT)), properties);
        return properties;
    }
}

