/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.transform.tika.parsers;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.HashSet;
import java.util.Set;
import org.apache.poi.poifs.filesystem.FileMagic;
import org.apache.poi.util.IOUtils;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.microsoft.OfficeParser;
import org.apache.tika.parser.microsoft.ooxml.OOXMLParser;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class TikaOfficeDetectParser
implements Parser {
    private final Parser ole2Parser = new OfficeParser();
    private final Parser ooxmlParser = new OOXMLParser();

    public Set<MediaType> getSupportedTypes(ParseContext parseContext) {
        HashSet<MediaType> types = new HashSet<MediaType>();
        types.addAll(this.ole2Parser.getSupportedTypes(parseContext));
        types.addAll(this.ooxmlParser.getSupportedTypes(parseContext));
        return types;
    }

    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext parseContext) throws IOException, SAXException, TikaException {
        InputStream wrapped;
        byte[] initial4 = new byte[4];
        if (stream.markSupported()) {
            stream.mark(initial4.length);
            IOUtils.readFully((InputStream)stream, (byte[])initial4);
            stream.reset();
            wrapped = stream;
        } else {
            PushbackInputStream inp = new PushbackInputStream(stream, 4);
            IOUtils.readFully((InputStream)inp, (byte[])initial4);
            inp.unread(initial4);
            wrapped = inp;
        }
        if (FileMagic.valueOf((byte[])initial4) == FileMagic.OOXML) {
            this.ooxmlParser.parse(wrapped, handler, metadata, parseContext);
        } else {
            this.ole2Parser.parse(wrapped, handler, metadata, parseContext);
        }
    }

    public void parse(InputStream stream, ContentHandler handler, Metadata metadata) throws IOException, SAXException, TikaException {
        this.parse(stream, handler, metadata, new ParseContext());
    }
}

