/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.transform.pdfrenderer.transformers;

import jakarta.annotation.PostConstruct;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.transform.base.TransformManager;
import org.alfresco.transform.base.executors.AbstractCommandExecutor;
import org.alfresco.transform.base.executors.RuntimeExec;
import org.alfresco.transform.base.util.CustomTransformerFileAdaptor;
import org.alfresco.transform.base.util.Util;
import org.alfresco.transform.exceptions.TransformException;
import org.alfresco.transform.pdfrenderer.PdfRendererOptionsBuilder;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class PdfRendererTransformer
extends AbstractCommandExecutor
implements CustomTransformerFileAdaptor {
    @Value(value="${transform.core.pdfrenderer.exe}")
    private String exe;

    @PostConstruct
    private void createCommands() {
        if (this.exe == null || this.exe.isEmpty()) {
            throw new IllegalArgumentException("PdfRendererTransformer PDFRENDERER_EXE variable cannot be null or empty");
        }
        this.transformCommand = this.createTransformCommand();
        this.checkCommand = this.createCheckCommand();
    }

    public String getTransformerName() {
        return "pdfrenderer";
    }

    protected RuntimeExec createTransformCommand() {
        RuntimeExec runtimeExec = new RuntimeExec();
        HashMap<String, String[]> commandsAndArguments = new HashMap<String, String[]>();
        commandsAndArguments.put(".*", new String[]{this.exe, "SPLIT:${options}", "${source}", "${target}"});
        runtimeExec.setCommandsAndArguments(commandsAndArguments);
        HashMap<String, Object> defaultProperties = new HashMap<String, Object>();
        defaultProperties.put("key", null);
        runtimeExec.setDefaultProperties(defaultProperties);
        runtimeExec.setErrorCodes("1");
        return runtimeExec;
    }

    protected RuntimeExec createCheckCommand() {
        RuntimeExec runtimeExec = new RuntimeExec();
        HashMap<String, String[]> commandsAndArguments = new HashMap<String, String[]>();
        commandsAndArguments.put(".*", new String[]{this.exe, "--version"});
        runtimeExec.setCommandsAndArguments(commandsAndArguments);
        return runtimeExec;
    }

    public void transform(String sourceMimetype, String targetMimetype, Map<String, String> transformOptions, File sourceFile, File targetFile, TransformManager transformManager) throws TransformException {
        String options = PdfRendererOptionsBuilder.builder().withPage(transformOptions.get("page")).withWidth(transformOptions.get("width")).withHeight(transformOptions.get("height")).withAllowPdfEnlargement(transformOptions.get("allowPdfEnlargement")).withMaintainPdfAspectRatio(transformOptions.get("maintainPdfAspectRatio")).build();
        Long timeout = Util.stringToLong((String)transformOptions.get("timeout"));
        this.run(options, sourceFile, targetFile, timeout);
    }
}

