/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.transform.pdfrenderer;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.Map;
import java.util.UUID;
import org.alfresco.transform.base.AbstractBaseTest;
import org.alfresco.transform.base.executors.CommandExecutor;
import org.alfresco.transform.base.executors.RuntimeExec;
import org.alfresco.transform.base.model.FileRefEntity;
import org.alfresco.transform.base.model.FileRefResponse;
import org.alfresco.transform.client.model.TransformReply;
import org.alfresco.transform.client.model.TransformRequest;
import org.alfresco.transform.pdfrenderer.transformers.PdfRendererTransformer;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockHttpServletRequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

public class PdfRendererTest
extends AbstractBaseTest {
    @Autowired
    private PdfRendererTransformer pdfRendererTransformer;
    @Mock
    private RuntimeExec.ExecutionResult mockExecutionResult;
    @Mock
    protected RuntimeExec mockTransformCommand;
    @Mock
    protected RuntimeExec mockCheckCommand;
    @Value(value="${transform.core.pdfrenderer.exe}")
    protected String execPath;

    @BeforeEach
    public void before() throws IOException {
        this.setMockExternalCommandsOnTransformer((CommandExecutor)this.pdfRendererTransformer, this.mockTransformCommand, this.mockCheckCommand);
        this.mockTransformCommand("pdf", "png", "application/pdf", true);
    }

    @AfterEach
    public void after() {
        this.resetExternalCommandsOnTransformer();
    }

    protected MockHttpServletRequestBuilder mockMvcRequest(String url, MockMultipartFile sourceFile, String ... params) {
        MockHttpServletRequestBuilder builder = super.mockMvcRequest(url, sourceFile, params).param("targetMimetype", new String[]{this.targetMimetype}).param("sourceMimetype", new String[]{this.sourceMimetype});
        return builder;
    }

    public void mockTransformCommand(String sourceExtension, String targetExtension, String sourceMimetype, boolean readTargetFileBytes) throws IOException {
        this.sourceExtension = sourceExtension;
        this.targetExtension = targetExtension;
        this.sourceMimetype = sourceMimetype;
        this.targetMimetype = "image/png";
        this.expectedOptions = null;
        this.expectedSourceSuffix = null;
        this.sourceFileBytes = this.readTestFile(sourceExtension);
        this.expectedTargetFileBytes = readTargetFileBytes ? this.readTestFile(targetExtension) : null;
        this.sourceFile = new MockMultipartFile("file", "quick." + sourceExtension, sourceMimetype, this.sourceFileBytes);
        Mockito.when((Object)this.mockTransformCommand.execute((Map)ArgumentMatchers.any(), ArgumentMatchers.anyLong())).thenAnswer(invocation -> {
            int i;
            Map actualProperties = (Map)invocation.getArgument(0);
            Assertions.assertEquals((int)3, (int)actualProperties.size(), (String)"There should be 3 properties");
            String actualOptions = (String)actualProperties.get("options");
            String actualSource = (String)actualProperties.get("source");
            String actualTarget = (String)actualProperties.get("target");
            String actualTargetExtension = StringUtils.getFilenameExtension((String)actualTarget);
            Assertions.assertNotNull((Object)actualSource);
            Assertions.assertNotNull((Object)actualTarget);
            if (this.expectedSourceSuffix != null) {
                Assertions.assertTrue((boolean)actualSource.endsWith(this.expectedSourceSuffix), (String)("The source file \"" + actualSource + "\" should have ended in \"" + this.expectedSourceSuffix + "\""));
                actualSource = actualSource.substring(0, actualSource.length() - this.expectedSourceSuffix.length());
            }
            Assertions.assertNotNull((Object)actualOptions);
            if (this.expectedOptions != null) {
                Assertions.assertEquals((Object)this.expectedOptions, (Object)actualOptions, (String)"expectedOptions");
            }
            Long actualTimeout = (Long)invocation.getArgument(1);
            Assertions.assertNotNull((Object)actualTimeout);
            if (this.expectedTimeout != null) {
                Assertions.assertEquals((Long)this.expectedTimeout, (Long)actualTimeout, (String)"expectedTimeout");
            }
            if ((i = actualTarget.lastIndexOf(95)) >= 0) {
                String testFilename = actualTarget.substring(i + 1);
                File testFile = this.getTestFile(testFilename, false);
                File targetFile = new File(actualTarget);
                this.generateTargetFileFromResourceFile(actualTargetExtension, testFile, targetFile);
            }
            byte[] actualSourceFileBytes = Files.readAllBytes(new File(actualSource).toPath());
            Assertions.assertTrue((boolean)Arrays.equals(this.sourceFileBytes, actualSourceFileBytes), (String)"Source file is not the same");
            return this.mockExecutionResult;
        });
        Mockito.when((Object)this.mockExecutionResult.getExitValue()).thenReturn((Object)0);
        Mockito.when((Object)this.mockExecutionResult.getStdErr()).thenReturn((Object)"STDERROR");
        Mockito.when((Object)this.mockExecutionResult.getStdOut()).thenReturn((Object)"STDOUT");
    }

    @Test
    public void optionsTest() throws Exception {
        this.expectedOptions = "--width=321 --height=654 --allow-enlargement --maintain-aspect-ratio --page=2";
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.multipart((String)"/transform", (Object[])new Object[0]).file(this.sourceFile).param("targetExtension", new String[]{this.targetExtension}).param("targetMimetype", new String[]{this.targetMimetype}).param("sourceMimetype", new String[]{this.sourceMimetype}).param("page", new String[]{"2"}).param("width", new String[]{"321"}).param("height", new String[]{"654"}).param("allowPdfEnlargement", new String[]{"true"}).param("maintainPdfAspectRatio", new String[]{"true"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().bytes(this.expectedTargetFileBytes)).andExpect(MockMvcResultMatchers.header().string("Content-Disposition", "attachment; filename*=UTF-8''transform." + this.targetExtension));
    }

    @Test
    public void optionsNegateBooleansTest() throws Exception {
        this.expectedOptions = "--width=321 --height=654 --page=2";
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.multipart((String)"/transform", (Object[])new Object[0]).file(this.sourceFile).param("targetExtension", new String[]{this.targetExtension}).param("targetMimetype", new String[]{this.targetMimetype}).param("sourceMimetype", new String[]{this.sourceMimetype}).param("page", new String[]{"2"}).param("width", new String[]{"321"}).param("height", new String[]{"654"}).param("allowPdfEnlargement", new String[]{"false"}).param("maintainPdfAspectRatio", new String[]{"false"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().bytes(this.expectedTargetFileBytes)).andExpect(MockMvcResultMatchers.header().string("Content-Disposition", "attachment; filename*=UTF-8''transform." + this.targetExtension));
    }

    protected void updateTransformRequestWithSpecificOptions(TransformRequest transformRequest) {
        transformRequest.setSourceExtension("pdf");
        transformRequest.setTargetExtension("png");
        transformRequest.setSourceMediaType("application/pdf");
        transformRequest.setTargetMediaType("image/png");
    }

    @Test
    public void badExitCodeTest() throws Exception {
        Mockito.when((Object)this.mockExecutionResult.getExitValue()).thenReturn((Object)1);
        this.mockMvc.perform((RequestBuilder)this.mockMvcRequest("/transform", this.sourceFile, "targetExtension", "xxx")).andExpect(MockMvcResultMatchers.status().is(HttpStatus.BAD_REQUEST.value())).andExpect(MockMvcResultMatchers.status().reason(Matchers.containsString((String)"Transformer exit code was not 0: \nSTDERR")));
    }

    @Test
    public void testPojoTransform() throws Exception {
        String sourceFileRef = UUID.randomUUID().toString();
        File sourceFile = this.getTestFile("quick." + this.sourceExtension, true);
        String targetFileRef = UUID.randomUUID().toString();
        TransformRequest transformRequest = this.createTransformRequest(sourceFileRef, sourceFile);
        HttpHeaders headers = new HttpHeaders();
        headers.set("Content-Disposition", "attachment; filename=quick." + this.sourceExtension);
        ResponseEntity response = new ResponseEntity((Object)new FileSystemResource(sourceFile), (MultiValueMap)headers, (HttpStatusCode)HttpStatus.OK);
        Mockito.when((Object)this.sharedFileStoreClient.retrieveFile(sourceFileRef)).thenReturn((Object)response);
        Mockito.when((Object)this.sharedFileStoreClient.saveFile((File)ArgumentMatchers.any())).thenReturn((Object)new FileRefResponse(new FileRefEntity(targetFileRef)));
        Mockito.when((Object)this.mockExecutionResult.getExitValue()).thenReturn((Object)0);
        this.updateTransformRequestWithSpecificOptions(transformRequest);
        String tr = this.objectMapper.writeValueAsString((Object)transformRequest);
        String transformationReplyAsString = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/transform", (Object[])new Object[0]).header("Accept", new Object[]{"application/json"}).header("Content-Type", new Object[]{"application/json"}).content(tr)).andExpect(MockMvcResultMatchers.status().is(HttpStatus.CREATED.value())).andReturn().getResponse().getContentAsString();
        TransformReply transformReply = (TransformReply)this.objectMapper.readValue(transformationReplyAsString, TransformReply.class);
        Assertions.assertEquals((Object)transformRequest.getRequestId(), (Object)transformReply.getRequestId());
        Assertions.assertEquals((Object)transformRequest.getClientData(), (Object)transformReply.getClientData());
        Assertions.assertEquals((int)transformRequest.getSchema(), (int)transformReply.getSchema());
    }

    @Test
    public void testOverridingExecutorPaths() {
        Assertions.assertEquals((Object)this.execPath, (Object)System.getProperty("PDF_RENDERER_EXE"));
    }
}

