/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.transform.pdfrenderer;

import java.util.StringJoiner;
import org.alfresco.transform.base.util.Util;

public final class PdfRendererOptionsBuilder {
    private Integer page;
    private Integer width;
    private Integer height;
    private Boolean allowPdfEnlargement;
    private Boolean maintainPdfAspectRatio;

    private PdfRendererOptionsBuilder() {
    }

    public PdfRendererOptionsBuilder withPage(String page) {
        return this.withPage(Util.stringToInteger((String)page));
    }

    public PdfRendererOptionsBuilder withPage(Integer page) {
        this.page = page;
        return this;
    }

    public PdfRendererOptionsBuilder withWidth(String width) {
        return this.withWidth(Util.stringToInteger((String)width));
    }

    public PdfRendererOptionsBuilder withWidth(Integer width) {
        this.width = width;
        return this;
    }

    public PdfRendererOptionsBuilder withHeight(String height) {
        return this.withHeight(Util.stringToInteger((String)height));
    }

    public PdfRendererOptionsBuilder withHeight(Integer height) {
        this.height = height;
        return this;
    }

    public PdfRendererOptionsBuilder withAllowPdfEnlargement(String allowPdfEnlargement) {
        return this.withAllowPdfEnlargement(Util.stringToBoolean((String)allowPdfEnlargement));
    }

    public PdfRendererOptionsBuilder withAllowPdfEnlargement(Boolean allowPdfEnlargement) {
        this.allowPdfEnlargement = allowPdfEnlargement;
        return this;
    }

    public PdfRendererOptionsBuilder withMaintainPdfAspectRatio(String maintainPdfAspectRatio) {
        return this.withMaintainPdfAspectRatio(Util.stringToBoolean((String)maintainPdfAspectRatio));
    }

    public PdfRendererOptionsBuilder withMaintainPdfAspectRatio(Boolean maintainPdfAspectRatio) {
        this.maintainPdfAspectRatio = maintainPdfAspectRatio;
        return this;
    }

    public String build() {
        StringJoiner args = new StringJoiner(" ");
        if (this.width != null && this.width >= 0) {
            args.add("--width=" + this.width);
        }
        if (this.height != null && this.height >= 0) {
            args.add("--height=" + this.height);
        }
        if (this.allowPdfEnlargement != null && this.allowPdfEnlargement.booleanValue()) {
            args.add("--allow-enlargement");
        }
        if (this.maintainPdfAspectRatio != null && this.maintainPdfAspectRatio.booleanValue()) {
            args.add("--maintain-aspect-ratio");
        }
        if (this.page != null && this.page >= 0) {
            args.add("--page=" + this.page);
        }
        return args.toString();
    }

    public static PdfRendererOptionsBuilder builder() {
        return new PdfRendererOptionsBuilder();
    }
}

