/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.transform.config;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.alfresco.transform.config.CoreFunction;
import org.alfresco.transform.config.TransformConfig;
import org.alfresco.transform.config.TransformOption;
import org.alfresco.transform.config.TransformOptionValue;
import org.alfresco.transform.config.TransformStep;
import org.alfresco.transform.config.Transformer;
import org.apache.maven.artifact.versioning.ComparableVersion;

public class CoreVersionDecorator {
    public static final int CONFIG_VERSION_INCLUDES_CORE_VERSION = 2;
    private static final Set<TransformOption> DIRECT_ACCESS_URL_TRANSFORM_OPTIONS = Set.of(new TransformOptionValue(false, "directAccessUrl"));
    private static final Set<TransformOption> SOURCE_FILENAME_TRANSFORM_OPTIONS = Set.of(new TransformOptionValue(false, "sourceFilename"));

    public static TransformConfig setOrClearCoreVersion(TransformConfig transformConfig, int configVersion) {
        boolean includeCoreVersion = configVersion >= 2;
        HashMap<String, Set<TransformOption>> transformOptions = new HashMap<String, Set<TransformOption>>(transformConfig.getTransformOptions());
        transformConfig = TransformConfig.builder().withTransformers(transformConfig.getTransformers().stream().map(transformer -> {
            if (includeCoreVersion && transformer.getCoreVersion() == null || !includeCoreVersion && transformer.getCoreVersion() != null) {
                transformer = Transformer.builder().withCoreVersion(includeCoreVersion ? transformer.getCoreVersion() : null).withTransformOptions(CoreVersionDecorator.setOrClearCoreTransformOptions(includeCoreVersion ? transformer.getCoreVersion() : null, transformer.getTransformOptions())).withTransformerName(transformer.getTransformerName()).withTransformerPipeline(transformer.getTransformerPipeline()).withTransformerFailover(transformer.getTransformerFailover()).withSupportedSourceAndTargetList(transformer.getSupportedSourceAndTargetList()).build();
            }
            return transformer;
        }).collect(Collectors.toList())).withTransformOptions(transformOptions).withRemoveTransformers(transformConfig.getRemoveTransformers()).withAddSupported(transformConfig.getAddSupported()).withRemoveSupported(transformConfig.getRemoveSupported()).withOverrideSupported(transformConfig.getOverrideSupported()).withSupportedDefaults(transformConfig.getSupportedDefaults()).build();
        CoreVersionDecorator.addOrRemoveDirectAccessUrlOption(transformConfig.getTransformOptions(), transformConfig.getTransformers());
        CoreVersionDecorator.addOrRemoveSourceFileNameOption(transformConfig.getTransformOptions(), transformConfig.getTransformers());
        return transformConfig;
    }

    public static void setCoreVersionOnSingleStepTransformers(TransformConfig transformConfig, String coreVersion) {
        List<Transformer> transformers = transformConfig.getTransformers();
        transformers.stream().filter(CoreVersionDecorator::isSingleStep).forEach(transformer -> {
            transformer.setCoreVersion(coreVersion);
            transformer.setTransformOptions(CoreVersionDecorator.setOrClearCoreTransformOptions(coreVersion, transformer.getTransformOptions()));
        });
        CoreVersionDecorator.addOrRemoveDirectAccessUrlOption(transformConfig.getTransformOptions(), transformers);
        CoreVersionDecorator.addOrRemoveSourceFileNameOption(transformConfig.getTransformOptions(), transformers);
    }

    public static void setCoreVersionOnMultiStepTransformers(Map<String, Set<TransformOption>> transformOptions, List<Transformer> transformers) {
        Map transformersByName = transformers.stream().collect(Collectors.toMap(Transformer::getTransformerName, Function.identity()));
        transformers.stream().filter(Predicate.not(CoreVersionDecorator::isSingleStep)).forEach(transformer -> {
            List<String> namesOfStepTransformers = transformer.getTransformerFailover().isEmpty() ? transformer.getTransformerPipeline().stream().map(TransformStep::getTransformerName).collect(Collectors.toList()) : transformer.getTransformerFailover();
            ComparableVersion minCoreVersion = namesOfStepTransformers.stream().map(transformerName -> ((Transformer)transformersByName.get(transformerName)).getCoreVersion()).map(coreVersion -> CoreFunction.newComparableVersion(coreVersion, CoreFunction.Constants.NO_VERSION)).min(ComparableVersion::compareTo).orElse(CoreFunction.Constants.NO_VERSION);
            String coreVersion2 = CoreFunction.Constants.NO_VERSION.equals((Object)minCoreVersion) ? null : minCoreVersion.toString();
            transformer.setCoreVersion(coreVersion2);
            transformer.setTransformOptions(CoreVersionDecorator.setOrClearCoreTransformOptions(transformer.getCoreVersion(), transformer.getTransformOptions()));
        });
        CoreVersionDecorator.addOrRemoveDirectAccessUrlOption(transformOptions, transformers);
        CoreVersionDecorator.addOrRemoveSourceFileNameOption(transformOptions, transformers);
    }

    private static Set<String> setOrClearCoreTransformOptions(String coreVersion, Set<String> transformerTransformOptions) {
        transformerTransformOptions = new HashSet<String>(transformerTransformOptions);
        if (CoreFunction.DIRECT_ACCESS_URL.isSupported(coreVersion)) {
            transformerTransformOptions.add("directAccessUrl");
        } else {
            transformerTransformOptions.remove("directAccessUrl");
        }
        if (CoreFunction.SOURCE_FILENAME.isSupported(coreVersion)) {
            transformerTransformOptions.add("sourceFilename");
        } else {
            transformerTransformOptions.remove("sourceFilename");
        }
        return transformerTransformOptions;
    }

    private static void addOrRemoveDirectAccessUrlOption(Map<String, Set<TransformOption>> transformOptions, List<Transformer> transformers) {
        if (transformers.stream().anyMatch(transformer -> CoreFunction.DIRECT_ACCESS_URL.isSupported(transformer.getCoreVersion()))) {
            transformOptions.put("directAccessUrl", DIRECT_ACCESS_URL_TRANSFORM_OPTIONS);
        } else {
            transformOptions.remove("directAccessUrl");
        }
    }

    private static void addOrRemoveSourceFileNameOption(Map<String, Set<TransformOption>> transformOptions, List<Transformer> transformers) {
        if (transformers.stream().anyMatch(transformer -> CoreFunction.SOURCE_FILENAME.isSupported(transformer.getCoreVersion()))) {
            transformOptions.put("sourceFilename", SOURCE_FILENAME_TRANSFORM_OPTIONS);
        } else {
            transformOptions.remove("sourceFilename");
        }
    }

    private static boolean isSingleStep(Transformer transformer) {
        return !(transformer.getTransformerFailover() != null && !transformer.getTransformerFailover().isEmpty() || transformer.getTransformerPipeline() != null && !transformer.getTransformerPipeline().isEmpty());
    }
}

