/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.transform.config;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.alfresco.transform.config.SupportedSourceAndTarget;
import org.alfresco.transform.config.TransformStep;

public class Transformer {
    private String transformerName;
    private String coreVersion;
    private Set<String> transformOptions = new HashSet<String>();
    private Set<SupportedSourceAndTarget> supportedSourceAndTargetList = new HashSet<SupportedSourceAndTarget>();
    private List<TransformStep> transformerPipeline = new ArrayList<TransformStep>();
    private List<String> transformerFailover = new ArrayList<String>();

    public Transformer() {
    }

    public Transformer(String transformerName, Set<String> transformOptions, Set<SupportedSourceAndTarget> supportedSourceAndTargetList) {
        this.transformerName = transformerName;
        this.transformOptions = transformOptions;
        this.supportedSourceAndTargetList = supportedSourceAndTargetList;
    }

    public Transformer(String transformerName, Set<String> transformOptions, Set<SupportedSourceAndTarget> supportedSourceAndTargetList, List<TransformStep> transformerPipeline) {
        this(transformerName, transformOptions, supportedSourceAndTargetList);
        this.transformerPipeline = transformerPipeline;
    }

    public Transformer(String transformerName, Set<String> transformOptions, Set<SupportedSourceAndTarget> supportedSourceAndTargetList, List<TransformStep> transformerPipeline, List<String> transformerFailover) {
        this(transformerName, transformOptions, supportedSourceAndTargetList, transformerPipeline);
        this.transformerFailover = transformerFailover;
    }

    public String getTransformerName() {
        return this.transformerName;
    }

    public void setTransformerName(String transformerName) {
        this.transformerName = transformerName;
    }

    public String getCoreVersion() {
        return this.coreVersion;
    }

    public void setCoreVersion(String coreVersion) {
        this.coreVersion = coreVersion;
    }

    public List<TransformStep> getTransformerPipeline() {
        return this.transformerPipeline;
    }

    public void setTransformerPipeline(List<TransformStep> transformerPipeline) {
        this.transformerPipeline = transformerPipeline == null ? new ArrayList() : transformerPipeline;
    }

    public List<String> getTransformerFailover() {
        return this.transformerFailover;
    }

    public void setTransformerFailover(List<String> transformerFailover) {
        this.transformerFailover = transformerFailover == null ? new ArrayList() : transformerFailover;
    }

    public Set<String> getTransformOptions() {
        return this.transformOptions;
    }

    public void setTransformOptions(Set<String> transformOptions) {
        this.transformOptions = transformOptions == null ? new HashSet() : transformOptions;
    }

    public Set<SupportedSourceAndTarget> getSupportedSourceAndTargetList() {
        return this.supportedSourceAndTargetList;
    }

    public void setSupportedSourceAndTargetList(Set<SupportedSourceAndTarget> supportedSourceAndTargetList) {
        this.supportedSourceAndTargetList = supportedSourceAndTargetList == null ? new HashSet() : supportedSourceAndTargetList;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Transformer that = (Transformer)o;
        return Objects.equals(this.transformerName, that.transformerName) && Objects.equals(this.coreVersion, that.coreVersion) && Objects.equals(this.transformerPipeline, that.transformerPipeline) && Objects.equals(this.transformerFailover, that.transformerFailover) && Objects.equals(this.transformOptions, that.transformOptions) && Objects.equals(this.supportedSourceAndTargetList, that.supportedSourceAndTargetList);
    }

    public int hashCode() {
        return Objects.hash(this.transformerName, this.coreVersion, this.transformerPipeline, this.transformerFailover, this.transformOptions, this.supportedSourceAndTargetList);
    }

    public String toString() {
        return "Transformer{transformerName='" + this.transformerName + "', coreVersion=" + this.coreVersion + ", transformerPipeline=" + String.valueOf(this.transformerPipeline) + ", transformerFailover=" + String.valueOf(this.transformerFailover) + ", transformOptions=" + String.valueOf(this.transformOptions) + ", supportedSourceAndTargetList=" + String.valueOf(this.supportedSourceAndTargetList) + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final Transformer transformer = new Transformer();

        private Builder() {
        }

        public Transformer build() {
            return this.transformer;
        }

        public Builder withTransformerName(String transformerName) {
            this.transformer.transformerName = transformerName;
            return this;
        }

        public Builder withCoreVersion(String coreVersion) {
            this.transformer.setCoreVersion(coreVersion);
            return this;
        }

        public Builder withTransformerPipeline(List<TransformStep> transformerPipeline) {
            this.transformer.transformerPipeline = transformerPipeline;
            return this;
        }

        public Builder withTransformerFailover(List<String> transformerFailover) {
            this.transformer.transformerFailover = transformerFailover;
            return this;
        }

        public Builder withTransformOptions(Set<String> transformOptions) {
            this.transformer.transformOptions = transformOptions;
            return this;
        }

        public Builder withSupportedSourceAndTargetList(Set<SupportedSourceAndTarget> supportedSourceAndTargetList) {
            this.transformer.supportedSourceAndTargetList = supportedSourceAndTargetList;
            return this;
        }
    }
}

