/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.transform.registry;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.transform.config.CoreFunction;
import org.alfresco.transform.config.TransformOption;
import org.alfresco.transform.config.Transformer;
import org.alfresco.transform.registry.SupportedTransform;
import org.alfresco.transform.registry.TransformCache;
import org.alfresco.transform.registry.TransformRegistryHelper;
import org.alfresco.transform.registry.TransformServiceRegistry;

public abstract class AbstractTransformRegistry
implements TransformServiceRegistry {
    protected abstract void logError(String var1);

    protected void logWarn(String msg) {
        this.logError(msg);
    }

    public abstract TransformCache getData();

    protected void register(Transformer transformer, Map<String, Set<TransformOption>> transformOptions, String baseUrl, String readFrom) {
        this.getData().incrementTransformerCount();
        transformer.getSupportedSourceAndTargetList().forEach(e -> this.getData().appendTransform(e.getSourceMediaType(), e.getTargetMediaType(), new SupportedTransform(transformer.getTransformerName(), TransformRegistryHelper.lookupTransformOptions(transformer.getTransformOptions(), transformOptions, readFrom, this::logError), e.getMaxSourceSizeBytes(), e.getPriority()), transformer.getTransformerName(), transformer.getCoreVersion()));
    }

    @Override
    public String findTransformerName(String sourceMimetype, long sourceSizeInBytes, String targetMimetype, Map<String, String> actualOptions, String renditionName) {
        return TransformRegistryHelper.retrieveTransformListBySize(this.getData(), sourceMimetype, targetMimetype, actualOptions, renditionName).stream().filter(t -> t.getMaxSourceSizeBytes() == -1L || t.getMaxSourceSizeBytes() >= sourceSizeInBytes).findFirst().map(SupportedTransform::getName).orElse(null);
    }

    @Override
    public long findMaxSize(String sourceMimetype, String targetMimetype, Map<String, String> actualOptions, String renditionName) {
        List<SupportedTransform> supportedTransforms = TransformRegistryHelper.retrieveTransformListBySize(this.getData(), sourceMimetype, targetMimetype, actualOptions, renditionName);
        return supportedTransforms.isEmpty() ? 0L : supportedTransforms.get(supportedTransforms.size() - 1).getMaxSourceSizeBytes();
    }

    @Override
    public boolean isSupported(CoreFunction function, String transformerName) {
        return function.isSupported(this.getData().getCoreVersion(transformerName));
    }

    public String getBaseUrlIfTesting(String name, String baseUrl) {
        return baseUrl;
    }
}

