/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.transform.registry;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.alfresco.transform.config.CoreFunction;
import org.alfresco.transform.config.SupportedSourceAndTarget;
import org.alfresco.transform.config.TransformConfig;
import org.alfresco.transform.config.TransformOption;
import org.alfresco.transform.config.TransformOptionGroup;
import org.alfresco.transform.config.TransformOptionValue;
import org.alfresco.transform.config.Transformer;
import org.alfresco.transform.registry.AbstractTransformRegistry;
import org.alfresco.transform.registry.CombinedTransformConfig;
import org.alfresco.transform.registry.SupportedTransform;
import org.alfresco.transform.registry.TransformCache;
import org.alfresco.transform.registry.TransformRegistryHelper;
import org.apache.commons.lang3.StringUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TransformRegistryModelTest {
    protected static final String GIF = "image/gif";
    protected static final String JPEG = "image/jpeg";
    protected static final String PDF = "application/pdf";
    protected static final String DOC = "application/msword";
    protected static final String XLS = "application/vnd.ms-excel";
    protected static final String PPT = "application/vnd.ms-powerpoint";
    protected static final String MSG = "application/vnd.ms-outlook";
    protected static final String TXT = "text/plain";
    protected AbstractTransformRegistry registry;
    protected Map<String, Set<TransformOption>> mapOfTransformOptions;

    @BeforeEach
    public void setUp() throws Exception {
        this.registry = this.buildTransformServiceRegistryImpl();
        this.mapOfTransformOptions = new HashMap<String, Set<TransformOption>>();
    }

    protected AbstractTransformRegistry buildTransformServiceRegistryImpl() throws Exception {
        return new AbstractTransformRegistry(){
            private TransformCache data = new TransformCache();

            protected void logError(String msg) {
                System.out.println(msg);
            }

            protected void logWarn(String msg) {
                System.out.println(msg);
            }

            public TransformCache getData() {
                return this.data;
            }
        };
    }

    private void assertAddToPossibleOptions(TransformOptionGroup transformOptionGroup, Set<String> actualOptionNames, Set<String> expectedNameSet, Set<String> expectedRequiredSet) {
        HashMap<String, Boolean> possibleTransformOptions = new HashMap<String, Boolean>();
        TransformRegistryHelper.addToPossibleTransformOptions(possibleTransformOptions, (TransformOptionGroup)transformOptionGroup, (Boolean)true, TransformRegistryModelTest.buildActualOptions(actualOptionNames));
        Assertions.assertEquals(expectedNameSet, possibleTransformOptions.keySet());
        possibleTransformOptions.forEach((name, required) -> {
            if (required.booleanValue()) {
                Assertions.assertTrue((boolean)expectedRequiredSet.contains(name));
            } else {
                Assertions.assertFalse((boolean)expectedRequiredSet.contains(name));
            }
        });
    }

    private void assertOptionsMatch(Set<String> actualOptionNames, Set<String> transformOptionNames, String unsupportedMsg) {
        Map transformOptions = transformOptionNames.stream().collect(Collectors.toMap(Function.identity(), name -> name.toUpperCase().equals(name)));
        boolean supported = TransformRegistryHelper.optionsMatch(transformOptions, TransformRegistryModelTest.buildActualOptions(actualOptionNames));
        if (StringUtils.isBlank((CharSequence)unsupportedMsg)) {
            Assertions.assertTrue((boolean)supported);
        } else {
            Assertions.assertFalse((boolean)supported);
        }
    }

    private void assertTransformOptions(Set<TransformOption> setOfTransformOptions) throws Exception {
        Transformer transformer = new Transformer("name", Collections.singleton("testOptions"), TransformRegistryModelTest.set((SupportedSourceAndTarget)((SupportedSourceAndTarget.Builder)((SupportedSourceAndTarget.Builder)SupportedSourceAndTarget.builder().withSourceMediaType(DOC)).withTargetMediaType(TXT)).build(), (SupportedSourceAndTarget)((SupportedSourceAndTarget.Builder)((SupportedSourceAndTarget.Builder)SupportedSourceAndTarget.builder().withSourceMediaType(XLS)).withTargetMediaType(TXT)).withMaxSourceSizeBytes(Long.valueOf(1024000L)).build()));
        TransformConfig transformConfig = TransformConfig.builder().withTransformers(Collections.singletonList(transformer)).withTransformOptions(Collections.singletonMap("testOptions", setOfTransformOptions)).build();
        this.registry = this.buildTransformServiceRegistryImpl();
        CombinedTransformConfig.combineAndRegister((TransformConfig)transformConfig, (String)this.getClass().getName(), (String)this.getBaseUrl(transformer), (AbstractTransformRegistry)this.registry);
        Assertions.assertTrue((boolean)this.registry.isSupported(XLS, 1024L, TXT, Collections.emptyMap(), null));
        Assertions.assertTrue((boolean)this.registry.isSupported(XLS, 1024000L, TXT, null, null));
        Assertions.assertFalse((boolean)this.registry.isSupported(XLS, 1024001L, TXT, Collections.emptyMap(), null));
        Assertions.assertTrue((boolean)this.registry.isSupported(DOC, 1024001L, TXT, null, null));
    }

    protected String getBaseUrl(Transformer transformer) {
        return "xxx";
    }

    private void assertTransformerName(String sourceMimetype, long sourceSizeInBytes, String targetMimetype, Map<String, String> actualOptions, String expectedTransformerName, Transformer ... transformers) throws Exception {
        this.buildAndPopulateRegistry(transformers);
        String transformerName = this.registry.findTransformerName(sourceMimetype, sourceSizeInBytes, targetMimetype, actualOptions, null);
        Assertions.assertEquals((Object)expectedTransformerName, (Object)transformerName);
    }

    private void assertSupported(Transformer transformer, String sourceMimetype, long sourceSizeInBytes, String targetMimetype, Map<String, String> actualOptions, String unsupportedMsg) throws Exception {
        this.assertSupported(sourceMimetype, sourceSizeInBytes, targetMimetype, actualOptions, unsupportedMsg, transformer);
    }

    private void assertSupported(String sourceMimetype, long sourceSizeInBytes, String targetMimetype, Map<String, String> actualOptions, String unsupportedMsg, Transformer ... transformers) throws Exception {
        this.buildAndPopulateRegistry(transformers);
        this.assertSupported(sourceMimetype, sourceSizeInBytes, targetMimetype, actualOptions, null, unsupportedMsg);
    }

    private void buildAndPopulateRegistry(Transformer[] transformers) throws Exception {
        this.registry = this.buildTransformServiceRegistryImpl();
        TransformConfig transformConfig = TransformConfig.builder().withTransformers(Arrays.asList(transformers)).withTransformOptions(this.mapOfTransformOptions).build();
        CombinedTransformConfig.combineAndRegister((TransformConfig)transformConfig, (String)this.getClass().getName(), (String)"---", (AbstractTransformRegistry)this.registry);
    }

    protected void assertSupported(String sourceMimetype, long sourceSizeInBytes, String targetMimetype, Map<String, String> actualOptions, String renditionName, String unsupportedMsg) {
        boolean supported = this.registry.isSupported(sourceMimetype, sourceSizeInBytes, targetMimetype, actualOptions, renditionName);
        if (unsupportedMsg == null || unsupportedMsg.isEmpty()) {
            Assertions.assertTrue((boolean)supported);
        } else {
            Assertions.assertFalse((boolean)supported);
        }
    }

    private static Map<String, String> buildActualOptions(Set<String> optionNames) {
        return optionNames.stream().collect(Collectors.toMap(Function.identity(), name -> "value for " + name));
    }

    @Test
    public void testOptionalGroups() {
        TransformOptionGroup transformOptionGroup = new TransformOptionGroup(true, TransformRegistryModelTest.set(new TransformOptionValue(false, "1"), new TransformOptionValue(true, "2"), new TransformOptionGroup(false, TransformRegistryModelTest.set(new TransformOptionValue(false, "3.1"), new TransformOptionValue(false, "3.2"), new TransformOptionValue(false, "3.3"))), new TransformOptionGroup(false, TransformRegistryModelTest.set(new TransformOptionValue(false, "4.1"), new TransformOptionValue(true, "4.2"), new TransformOptionValue(false, "4.3")))));
        this.assertAddToPossibleOptions(transformOptionGroup, Collections.emptySet(), TransformRegistryModelTest.set("1", "2"), TransformRegistryModelTest.set("2"));
        this.assertAddToPossibleOptions(transformOptionGroup, TransformRegistryModelTest.set("1"), TransformRegistryModelTest.set("1", "2"), TransformRegistryModelTest.set("2"));
        this.assertAddToPossibleOptions(transformOptionGroup, TransformRegistryModelTest.set("2"), TransformRegistryModelTest.set("1", "2"), TransformRegistryModelTest.set("2"));
        this.assertAddToPossibleOptions(transformOptionGroup, TransformRegistryModelTest.set("2", "3.2"), TransformRegistryModelTest.set("1", "2", "3.1", "3.2", "3.3"), TransformRegistryModelTest.set("2"));
        this.assertAddToPossibleOptions(transformOptionGroup, TransformRegistryModelTest.set("2", "4.1"), TransformRegistryModelTest.set("1", "2", "4.1", "4.2", "4.3"), TransformRegistryModelTest.set("2", "4.2"));
        this.assertAddToPossibleOptions(transformOptionGroup, TransformRegistryModelTest.set("2", "4.2"), TransformRegistryModelTest.set("1", "2", "4.1", "4.2", "4.3"), TransformRegistryModelTest.set("2", "4.2"));
    }

    @Test
    public void testRequiredGroup() {
        TransformOptionGroup transformOptionGroup = new TransformOptionGroup(true, TransformRegistryModelTest.set(new TransformOptionValue(false, "1"), new TransformOptionValue(true, "2"), new TransformOptionGroup(false, TransformRegistryModelTest.set(new TransformOptionValue(false, "3.1"), new TransformOptionValue(false, "3.2"), new TransformOptionValue(false, "3.3"))), new TransformOptionGroup(true, TransformRegistryModelTest.set(new TransformOptionValue(false, "4.1"), new TransformOptionValue(true, "4.2"), new TransformOptionValue(false, "4.3")))));
        this.assertAddToPossibleOptions(transformOptionGroup, Collections.emptySet(), TransformRegistryModelTest.set("1", "2", "4.1", "4.2", "4.3"), TransformRegistryModelTest.set("2", "4.2"));
        this.assertAddToPossibleOptions(transformOptionGroup, TransformRegistryModelTest.set("1"), TransformRegistryModelTest.set("1", "2", "4.1", "4.2", "4.3"), TransformRegistryModelTest.set("2", "4.2"));
        this.assertAddToPossibleOptions(transformOptionGroup, TransformRegistryModelTest.set("2", "3.2"), TransformRegistryModelTest.set("1", "2", "3.1", "3.2", "3.3", "4.1", "4.2", "4.3"), TransformRegistryModelTest.set("2", "4.2"));
        this.assertAddToPossibleOptions(transformOptionGroup, TransformRegistryModelTest.set("2", "4.1"), TransformRegistryModelTest.set("1", "2", "4.1", "4.2", "4.3"), TransformRegistryModelTest.set("2", "4.2"));
        this.assertAddToPossibleOptions(transformOptionGroup, TransformRegistryModelTest.set("2", "4.2"), TransformRegistryModelTest.set("1", "2", "4.1", "4.2", "4.3"), TransformRegistryModelTest.set("2", "4.2"));
    }

    @Test
    public void testNestedGroups() {
        TransformOptionGroup transformOptionGroup = new TransformOptionGroup(false, TransformRegistryModelTest.set(new TransformOptionGroup(false, TransformRegistryModelTest.set(new TransformOptionValue(false, "1"), new TransformOptionGroup(false, TransformRegistryModelTest.set(new TransformOptionValue(false, "1.2"), new TransformOptionGroup(false, TransformRegistryModelTest.set(new TransformOptionValue(false, "1.2.3"))))))), new TransformOptionGroup(false, TransformRegistryModelTest.set(new TransformOptionValue(false, "2"), new TransformOptionGroup(false, TransformRegistryModelTest.set(new TransformOptionValue(false, "2.2"), new TransformOptionGroup(false, TransformRegistryModelTest.set(new TransformOptionGroup(false, TransformRegistryModelTest.set(new TransformOptionValue(false, "2.2.1.2"))))))))), new TransformOptionGroup(false, TransformRegistryModelTest.set(new TransformOptionValue(true, "3"), new TransformOptionGroup(false, TransformRegistryModelTest.set(new TransformOptionGroup(false, TransformRegistryModelTest.set(new TransformOptionGroup(false, TransformRegistryModelTest.set(new TransformOptionValue(false, "3.1.1.2"))))))))), new TransformOptionGroup(false, TransformRegistryModelTest.set(new TransformOptionValue(false, "4"), new TransformOptionGroup(true, TransformRegistryModelTest.set(new TransformOptionGroup(false, TransformRegistryModelTest.set(new TransformOptionGroup(false, TransformRegistryModelTest.set(new TransformOptionValue(false, "4.1.1.2"))))))))), new TransformOptionGroup(false, TransformRegistryModelTest.set(new TransformOptionValue(false, "5"), new TransformOptionGroup(false, TransformRegistryModelTest.set(new TransformOptionGroup(true, TransformRegistryModelTest.set(new TransformOptionGroup(false, TransformRegistryModelTest.set(new TransformOptionValue(false, "5.1.1.2"))))))))), new TransformOptionGroup(false, TransformRegistryModelTest.set(new TransformOptionValue(false, "6"), new TransformOptionGroup(false, TransformRegistryModelTest.set(new TransformOptionGroup(false, TransformRegistryModelTest.set(new TransformOptionGroup(true, TransformRegistryModelTest.set(new TransformOptionValue(false, "6.1.1.2"))))))))), new TransformOptionGroup(false, TransformRegistryModelTest.set(new TransformOptionValue(false, "7"), new TransformOptionGroup(false, TransformRegistryModelTest.set(new TransformOptionGroup(false, TransformRegistryModelTest.set(new TransformOptionGroup(false, TransformRegistryModelTest.set(new TransformOptionValue(true, "7.1.1.2")))))))))));
        this.assertAddToPossibleOptions(transformOptionGroup, Collections.emptySet(), Collections.emptySet(), Collections.emptySet());
        this.assertAddToPossibleOptions(transformOptionGroup, TransformRegistryModelTest.set("1"), TransformRegistryModelTest.set("1"), Collections.emptySet());
        this.assertAddToPossibleOptions(transformOptionGroup, TransformRegistryModelTest.set("1", "7"), TransformRegistryModelTest.set("1", "7"), Collections.emptySet());
        this.assertAddToPossibleOptions(transformOptionGroup, TransformRegistryModelTest.set("1", "7.1.1.2"), TransformRegistryModelTest.set("1", "7", "7.1.1.2"), TransformRegistryModelTest.set("7.1.1.2"));
        this.assertAddToPossibleOptions(transformOptionGroup, TransformRegistryModelTest.set("1", "6"), TransformRegistryModelTest.set("1", "6"), Collections.emptySet());
        this.assertAddToPossibleOptions(transformOptionGroup, TransformRegistryModelTest.set("1", "6.1.1.2"), TransformRegistryModelTest.set("1", "6", "6.1.1.2"), Collections.emptySet());
        this.assertAddToPossibleOptions(transformOptionGroup, TransformRegistryModelTest.set("1", "5"), TransformRegistryModelTest.set("1", "5"), Collections.emptySet());
        this.assertAddToPossibleOptions(transformOptionGroup, TransformRegistryModelTest.set("1", "5.1.1.2"), TransformRegistryModelTest.set("1", "5", "5.1.1.2"), Collections.emptySet());
        this.assertAddToPossibleOptions(transformOptionGroup, TransformRegistryModelTest.set("1", "4"), TransformRegistryModelTest.set("1", "4"), Collections.emptySet());
        this.assertAddToPossibleOptions(transformOptionGroup, TransformRegistryModelTest.set("1", "4.1.1.2"), TransformRegistryModelTest.set("1", "4", "4.1.1.2"), Collections.emptySet());
        this.assertAddToPossibleOptions(transformOptionGroup, TransformRegistryModelTest.set("1", "3"), TransformRegistryModelTest.set("1", "3"), TransformRegistryModelTest.set("3"));
        this.assertAddToPossibleOptions(transformOptionGroup, TransformRegistryModelTest.set("1", "3.1.1.2"), TransformRegistryModelTest.set("1", "3", "3.1.1.2"), TransformRegistryModelTest.set("3"));
        this.assertAddToPossibleOptions(transformOptionGroup, TransformRegistryModelTest.set("2"), TransformRegistryModelTest.set("2"), Collections.emptySet());
        this.assertAddToPossibleOptions(transformOptionGroup, TransformRegistryModelTest.set("2", "2.2"), TransformRegistryModelTest.set("2", "2.2"), Collections.emptySet());
        this.assertAddToPossibleOptions(transformOptionGroup, TransformRegistryModelTest.set("3"), TransformRegistryModelTest.set("3"), TransformRegistryModelTest.set("3"));
        this.assertAddToPossibleOptions(transformOptionGroup, TransformRegistryModelTest.set("3.1.1.2"), TransformRegistryModelTest.set("3", "3.1.1.2"), TransformRegistryModelTest.set("3"));
    }

    @Test
    public void testRegistryOptionsMatchMethod() {
        this.assertOptionsMatch(TransformRegistryModelTest.set("a"), TransformRegistryModelTest.set("a", "B", "c"), "required option B is missing");
        this.assertOptionsMatch(Collections.emptySet(), TransformRegistryModelTest.set("a", "B", "c"), "required option B is missing");
        this.assertOptionsMatch(TransformRegistryModelTest.set("B"), TransformRegistryModelTest.set("a", "B", "c"), null);
        this.assertOptionsMatch(TransformRegistryModelTest.set("B", "c"), TransformRegistryModelTest.set("a", "B", "c"), null);
        this.assertOptionsMatch(TransformRegistryModelTest.set("B", "a", "c"), TransformRegistryModelTest.set("a", "B", "c"), null);
        this.assertOptionsMatch(TransformRegistryModelTest.set("B", "d"), TransformRegistryModelTest.set("a", "B", "c"), "there is an extra option d");
        this.assertOptionsMatch(TransformRegistryModelTest.set("B", "c", "d"), TransformRegistryModelTest.set("a", "B", "c"), "there is an extra option d");
        this.assertOptionsMatch(TransformRegistryModelTest.set("d"), TransformRegistryModelTest.set("a", "B", "c"), "required option B is missing and there is an extra option d");
        this.assertOptionsMatch(TransformRegistryModelTest.set("a"), TransformRegistryModelTest.set("a", "b", "c"), null);
        this.assertOptionsMatch(Collections.emptySet(), TransformRegistryModelTest.set("a", "b", "c"), null);
        this.assertOptionsMatch(TransformRegistryModelTest.set("a", "b", "c"), TransformRegistryModelTest.set("a", "b", "c"), null);
    }

    @Test
    public void testNoActualOptions() throws Exception {
        this.assertTransformOptions(TransformRegistryModelTest.set(new TransformOptionValue(false, "option1"), new TransformOptionValue(false, "option2")));
    }

    @Test
    public void testNoTransformOptions() throws Exception {
        this.assertTransformOptions(Collections.emptySet());
        this.assertTransformOptions(null);
    }

    @Test
    public void testSupported() throws Exception {
        this.mapOfTransformOptions.put("options1", TransformRegistryModelTest.set(new TransformOptionValue(false, "page"), new TransformOptionValue(false, "width"), new TransformOptionValue(false, "height")));
        Transformer transformer = new Transformer("name", Collections.singleton("options1"), TransformRegistryModelTest.set((SupportedSourceAndTarget)((SupportedSourceAndTarget.Builder)((SupportedSourceAndTarget.Builder)SupportedSourceAndTarget.builder().withSourceMediaType(DOC)).withTargetMediaType(GIF)).withMaxSourceSizeBytes(Long.valueOf(102400L)).build(), (SupportedSourceAndTarget)((SupportedSourceAndTarget.Builder)((SupportedSourceAndTarget.Builder)SupportedSourceAndTarget.builder().withSourceMediaType(DOC)).withTargetMediaType(JPEG)).build(), (SupportedSourceAndTarget)((SupportedSourceAndTarget.Builder)((SupportedSourceAndTarget.Builder)SupportedSourceAndTarget.builder().withSourceMediaType(MSG)).withTargetMediaType(GIF)).build()));
        this.assertSupported(transformer, DOC, 1024L, GIF, Collections.emptyMap(), null);
        this.assertSupported(transformer, DOC, 102400L, GIF, Collections.emptyMap(), null);
        this.assertSupported(transformer, DOC, 102401L, GIF, Collections.emptyMap(), "source is too large");
        this.assertSupported(transformer, DOC, 1024L, JPEG, Collections.emptyMap(), null);
        this.assertSupported(transformer, GIF, 1024L, DOC, Collections.emptyMap(), "image/gif is not a source of this transformer");
        this.assertSupported(transformer, MSG, 1024L, GIF, Collections.emptyMap(), null);
        this.assertSupported(transformer, MSG, 1024L, JPEG, Collections.emptyMap(), "application/vnd.ms-outlook to image/jpeg is not supported by this transformer");
        this.assertSupported(transformer, DOC, 1024L, GIF, TransformRegistryModelTest.buildActualOptions(TransformRegistryModelTest.set("page", "width")), null);
        this.assertSupported(transformer, DOC, 1024L, GIF, TransformRegistryModelTest.buildActualOptions(TransformRegistryModelTest.set("page", "width", "startPage")), "startPage is not an option");
    }

    @Test
    public void testCache() {
        this.mapOfTransformOptions.put("options1", TransformRegistryModelTest.set(new TransformOptionValue(false, "page"), new TransformOptionValue(false, "width"), new TransformOptionValue(false, "height")));
        Transformer transformer = new Transformer("name", Collections.singleton("options1"), TransformRegistryModelTest.set((SupportedSourceAndTarget)((SupportedSourceAndTarget.Builder)((SupportedSourceAndTarget.Builder)SupportedSourceAndTarget.builder().withSourceMediaType(DOC)).withTargetMediaType(GIF)).withMaxSourceSizeBytes(Long.valueOf(102400L)).build(), (SupportedSourceAndTarget)((SupportedSourceAndTarget.Builder)((SupportedSourceAndTarget.Builder)SupportedSourceAndTarget.builder().withSourceMediaType(MSG)).withTargetMediaType(GIF)).build()));
        TransformConfig transformConfig = TransformConfig.builder().withTransformers(Collections.singletonList(transformer)).withTransformOptions(this.mapOfTransformOptions).build();
        CombinedTransformConfig.combineAndRegister((TransformConfig)transformConfig, (String)this.getClass().getName(), (String)this.getBaseUrl(transformer), (AbstractTransformRegistry)this.registry);
        this.assertSupported(DOC, 1024L, GIF, Collections.emptyMap(), "doclib", "");
        this.assertSupported(MSG, 1024L, GIF, Collections.emptyMap(), "doclib", "");
        Assertions.assertEquals((long)102400L, (long)this.registry.findMaxSize(DOC, GIF, Collections.emptyMap(), "doclib"));
        Assertions.assertEquals((long)-1L, (long)this.registry.findMaxSize(MSG, GIF, Collections.emptyMap(), "doclib"));
        SupportedTransform cachedSupportedTransform = new SupportedTransform("name1", Collections.emptySet(), 999999L, 0);
        this.registry.getData().retrieveCached("doclib", DOC).add(cachedSupportedTransform);
        Assertions.assertEquals((long)999999L, (long)this.registry.findMaxSize(DOC, GIF, Collections.emptyMap(), "doclib"));
    }

    @Test
    public void testTransformCacheGetTransforms() {
        TransformConfig transformConfig = TransformConfig.builder().withTransformers((List)ImmutableList.of((Object)new Transformer("transformer1", Collections.emptySet(), TransformRegistryModelTest.set((SupportedSourceAndTarget)((SupportedSourceAndTarget.Builder)((SupportedSourceAndTarget.Builder)SupportedSourceAndTarget.builder().withSourceMediaType(GIF)).withTargetMediaType(PDF)).build(), (SupportedSourceAndTarget)((SupportedSourceAndTarget.Builder)((SupportedSourceAndTarget.Builder)SupportedSourceAndTarget.builder().withSourceMediaType(GIF)).withTargetMediaType(JPEG)).build())))).build();
        Assertions.assertEquals((int)0, (int)this.registry.getData().getTransforms().size());
        Assertions.assertEquals((Object)"", (Object)this.registry.getData().toString());
        CombinedTransformConfig.combineAndRegister((TransformConfig)transformConfig, (String)"readFrom", (String)"baseUrl", (AbstractTransformRegistry)this.registry);
        Assertions.assertEquals((int)1, (int)this.registry.getData().getTransforms().size());
        Assertions.assertEquals((int)2, (int)((Map)this.registry.getData().getTransforms().get(GIF)).size());
        Assertions.assertEquals((Object)"(transformers: 1 transforms: 2)", (Object)this.registry.getData().toString());
    }

    @Test
    public void testGetTransformerName() throws Exception {
        Transformer t1 = this.newTransformer("transformer1", MSG, GIF, 100L, 50);
        Transformer t2 = this.newTransformer("transformer2", MSG, GIF, 200L, 60);
        Transformer t3 = this.newTransformer("transformer3", MSG, GIF, 200L, 40);
        Transformer t4 = this.newTransformer("transformer4", MSG, GIF, -1L, 100);
        Transformer t5 = this.newTransformer("transformer5", MSG, GIF, -1L, 80);
        this.assertTransformerName(MSG, 100L, GIF, Collections.emptyMap(), "transformer1", t1, t2);
        this.assertTransformerName(MSG, 150L, GIF, Collections.emptyMap(), "transformer2", t1, t2);
        this.assertTransformerName(MSG, 250L, GIF, Collections.emptyMap(), null, t1, t2);
        this.assertTransformerName(MSG, 100L, GIF, Collections.emptyMap(), "transformer3", t1, t2, t3, t4, t5);
        this.assertTransformerName(MSG, 200L, GIF, Collections.emptyMap(), "transformer3", t1, t2, t3, t4, t5);
        this.assertTransformerName(MSG, 200L, GIF, Collections.emptyMap(), "transformer3", t1, t2, t3, t4);
        this.assertTransformerName(MSG, 300L, GIF, Collections.emptyMap(), "transformer4", t1, t2, t3, t4);
        this.assertTransformerName(MSG, 300L, GIF, Collections.emptyMap(), "transformer5", t1, t2, t3, t4, t5);
    }

    private Transformer newTransformer(String transformerName, String sourceMediaType, String targetMediaType, long maxSourceSizeBytes, int priority) {
        return Transformer.builder().withTransformerName(transformerName).withSupportedSourceAndTargetList((Set)ImmutableSet.of((Object)((SupportedSourceAndTarget)((SupportedSourceAndTarget.Builder)((SupportedSourceAndTarget.Builder)SupportedSourceAndTarget.builder().withSourceMediaType(sourceMediaType)).withTargetMediaType(targetMediaType)).withMaxSourceSizeBytes(Long.valueOf(maxSourceSizeBytes)).withPriority(Integer.valueOf(priority)).build()))).build();
    }

    @Test
    public void testMultipleTransformers() throws Exception {
        this.mapOfTransformOptions.put("options1", TransformRegistryModelTest.set(new TransformOptionValue(false, "page"), new TransformOptionValue(false, "width"), new TransformOptionValue(false, "height")));
        this.mapOfTransformOptions.put("options2", TransformRegistryModelTest.set(new TransformOptionValue(false, "opt1"), new TransformOptionValue(false, "opt2")));
        this.mapOfTransformOptions.put("options3", new HashSet<TransformOptionValue>(Collections.singletonList(new TransformOptionValue(false, "opt1"))));
        Transformer transformer1 = new Transformer("transformer1", Collections.singleton("options1"), TransformRegistryModelTest.set((SupportedSourceAndTarget)((SupportedSourceAndTarget.Builder)((SupportedSourceAndTarget.Builder)SupportedSourceAndTarget.builder().withSourceMediaType(DOC)).withTargetMediaType(GIF)).withMaxSourceSizeBytes(Long.valueOf(102400L)).build(), (SupportedSourceAndTarget)((SupportedSourceAndTarget.Builder)((SupportedSourceAndTarget.Builder)SupportedSourceAndTarget.builder().withSourceMediaType(DOC)).withTargetMediaType(JPEG)).build(), (SupportedSourceAndTarget)((SupportedSourceAndTarget.Builder)((SupportedSourceAndTarget.Builder)SupportedSourceAndTarget.builder().withSourceMediaType(MSG)).withTargetMediaType(GIF)).build()));
        Transformer transformer2 = new Transformer("transformer2", Collections.singleton("options2"), TransformRegistryModelTest.set((SupportedSourceAndTarget)((SupportedSourceAndTarget.Builder)((SupportedSourceAndTarget.Builder)SupportedSourceAndTarget.builder().withSourceMediaType(PDF)).withTargetMediaType(GIF)).build(), (SupportedSourceAndTarget)((SupportedSourceAndTarget.Builder)((SupportedSourceAndTarget.Builder)SupportedSourceAndTarget.builder().withSourceMediaType(PPT)).withTargetMediaType(JPEG)).build()));
        Transformer transformer3 = new Transformer("transformer3", Collections.singleton("options3"), new HashSet<SupportedSourceAndTarget>(Collections.singletonList((SupportedSourceAndTarget)((SupportedSourceAndTarget.Builder)((SupportedSourceAndTarget.Builder)SupportedSourceAndTarget.builder().withSourceMediaType(DOC)).withTargetMediaType(GIF)).build())));
        this.assertSupported(DOC, 1024L, GIF, Collections.emptyMap(), null, transformer1);
        this.assertSupported(DOC, 1024L, GIF, Collections.emptyMap(), null, transformer1, transformer2);
        this.assertSupported(DOC, 1024L, GIF, Collections.emptyMap(), null, transformer1, transformer2, transformer3);
        this.assertSupported(DOC, 102401L, GIF, Collections.emptyMap(), "source is too large", transformer1);
        this.assertSupported(DOC, 102401L, GIF, Collections.emptyMap(), null, transformer1, transformer3);
        this.assertSupported(PDF, 1024L, GIF, Collections.emptyMap(), "Only transformer2 supports these mimetypes", transformer1);
        this.assertSupported(PDF, 1024L, GIF, Collections.emptyMap(), null, transformer1, transformer2);
        this.assertSupported(PDF, 1024L, GIF, Collections.emptyMap(), null, transformer1, transformer2, transformer3);
        Map<String, String> actualOptions = TransformRegistryModelTest.buildActualOptions(TransformRegistryModelTest.set("opt1"));
        this.assertSupported(PDF, 1024L, GIF, actualOptions, "Only transformer2/4 supports these options", transformer1);
        this.assertSupported(PDF, 1024L, GIF, actualOptions, null, transformer1, transformer2);
        this.assertSupported(PDF, 1024L, GIF, actualOptions, null, transformer1, transformer2, transformer3);
        this.assertSupported(PDF, 1024L, GIF, actualOptions, "transformer4 supports opt1 but not the source mimetype ", transformer1, transformer3);
    }

    @SafeVarargs
    private static <T> Set<T> set(T ... elements) {
        if (elements == null || elements.length == 0) {
            return Collections.emptySet();
        }
        return ImmutableSet.copyOf((Object[])elements);
    }

    @Test
    public void testIsSupportedCoreFunction() throws Exception {
        Transformer t1 = this.newTransformer("transformer1", MSG, GIF, 100L, 50);
        Transformer t2 = this.newTransformer("transformer2", MSG, GIF, 200L, 60);
        Transformer t3 = this.newTransformer("transformer3", MSG, GIF, 200L, 40);
        t2.setCoreVersion("1.0");
        t3.setCoreVersion("2.5.7");
        this.buildAndPopulateRegistry(new Transformer[]{t1, t2, t3});
        Assertions.assertTrue((boolean)this.registry.isSupported(CoreFunction.HTTP, "transformer1"));
        Assertions.assertTrue((boolean)this.registry.isSupported(CoreFunction.HTTP, "transformer2"));
        Assertions.assertTrue((boolean)this.registry.isSupported(CoreFunction.HTTP, "transformer3"));
        Assertions.assertFalse((boolean)this.registry.isSupported(CoreFunction.ACTIVE_MQ, "transformer1"));
        Assertions.assertTrue((boolean)this.registry.isSupported(CoreFunction.ACTIVE_MQ, "transformer2"));
        Assertions.assertTrue((boolean)this.registry.isSupported(CoreFunction.ACTIVE_MQ, "transformer3"));
        Assertions.assertFalse((boolean)this.registry.isSupported(CoreFunction.DIRECT_ACCESS_URL, "transformer1"));
        Assertions.assertFalse((boolean)this.registry.isSupported(CoreFunction.DIRECT_ACCESS_URL, "transformer2"));
        Assertions.assertTrue((boolean)this.registry.isSupported(CoreFunction.DIRECT_ACCESS_URL, "transformer3"));
    }
}

