/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.transform.registry;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.alfresco.transform.config.AddSupported;
import org.alfresco.transform.config.OverrideSupported;
import org.alfresco.transform.config.RemoveSupported;
import org.alfresco.transform.config.SupportedDefaults;
import org.alfresco.transform.config.SupportedSourceAndTarget;
import org.alfresco.transform.config.TransformConfig;
import org.alfresco.transform.config.Transformer;
import org.alfresco.transform.registry.AbstractTransformRegistry;
import org.alfresco.transform.registry.CombinedTransformConfig;
import org.alfresco.transform.registry.FakeTransformRegistry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class OverrideTransformConfigTests {
    private static final String READ_FROM_A = "readFromA";
    private static final String READ_FROM_B = "readFromB";
    private static final String BASE_URL_A = "baseUrlA";
    private static final String BASE_URL_B = "baseUrlB";
    private final SupportedSourceAndTarget supported_A2B = (SupportedSourceAndTarget)((SupportedSourceAndTarget.Builder)((SupportedSourceAndTarget.Builder)SupportedSourceAndTarget.builder().withSourceMediaType("mimetype/a")).withTargetMediaType("mimetype/b")).build();
    private final SupportedSourceAndTarget supported_A2B__40 = (SupportedSourceAndTarget)((SupportedSourceAndTarget.Builder)((SupportedSourceAndTarget.Builder)SupportedSourceAndTarget.builder().withSourceMediaType("mimetype/a")).withTargetMediaType("mimetype/b")).withPriority(Integer.valueOf(40)).build();
    private final SupportedSourceAndTarget supported_C2D = (SupportedSourceAndTarget)((SupportedSourceAndTarget.Builder)((SupportedSourceAndTarget.Builder)SupportedSourceAndTarget.builder().withSourceMediaType("mimetype/c")).withTargetMediaType("mimetype/d")).build();
    private final SupportedSourceAndTarget supported_A2D_1234_44 = (SupportedSourceAndTarget)((SupportedSourceAndTarget.Builder)((SupportedSourceAndTarget.Builder)SupportedSourceAndTarget.builder().withSourceMediaType("mimetype/a")).withTargetMediaType("mimetype/d")).withMaxSourceSizeBytes(Long.valueOf(1234L)).withPriority(Integer.valueOf(44)).build();
    private final SupportedSourceAndTarget supported_X2Y_100_23 = (SupportedSourceAndTarget)((SupportedSourceAndTarget.Builder)((SupportedSourceAndTarget.Builder)SupportedSourceAndTarget.builder().withSourceMediaType("mimetype/x")).withTargetMediaType("mimetype/y")).withMaxSourceSizeBytes(Long.valueOf(100L)).withPriority(Integer.valueOf(23)).build();
    private final SupportedSourceAndTarget supported_X2Y_200 = (SupportedSourceAndTarget)((SupportedSourceAndTarget.Builder)((SupportedSourceAndTarget.Builder)SupportedSourceAndTarget.builder().withSourceMediaType("mimetype/x")).withTargetMediaType("mimetype/y")).withMaxSourceSizeBytes(Long.valueOf(200L)).build();
    private final TransformConfig transformConfig_A2B_X2Y_100_23 = TransformConfig.builder().withTransformers((List)ImmutableList.of((Object)Transformer.builder().withTransformerName("1").withSupportedSourceAndTargetList(new HashSet<SupportedSourceAndTarget>(Set.of(this.supported_A2B, this.supported_X2Y_100_23))).build())).build();
    private final CombinedTransformConfig config = new CombinedTransformConfig();
    private final FakeTransformRegistry registry = new FakeTransformRegistry();

    @Test
    public void testRemoveTransformers() {
        Transformer transformer1 = Transformer.builder().withTransformerName("1").build();
        Transformer transformer2 = Transformer.builder().withTransformerName("2").build();
        Transformer transformer3 = Transformer.builder().withTransformerName("3").build();
        Transformer transformer4 = Transformer.builder().withTransformerName("4").build();
        TransformConfig firstConfig = TransformConfig.builder().withTransformers((List)ImmutableList.of((Object)transformer1, (Object)transformer2, (Object)transformer3, (Object)transformer4)).build();
        TransformConfig secondConfig = TransformConfig.builder().withTransformers((List)ImmutableList.of((Object)transformer2)).withRemoveTransformers((Set)ImmutableSet.of((Object)"2", (Object)"7", (Object)"3", (Object)"2", (Object)"5")).build();
        this.config.addTransformConfig(firstConfig, READ_FROM_A, BASE_URL_A, (AbstractTransformRegistry)this.registry);
        TransformConfig resultConfig = this.config.buildTransformConfig();
        Assertions.assertEquals((int)4, (int)resultConfig.getTransformers().size());
        this.config.addTransformConfig(secondConfig, READ_FROM_B, BASE_URL_B, (AbstractTransformRegistry)this.registry);
        resultConfig = this.config.buildTransformConfig();
        Assertions.assertEquals((int)3, (int)resultConfig.getTransformers().size());
        String expected = "Unable to process \"removeTransformers\": [\"7\", \"5\"]. Read from readFromB";
        Assertions.assertEquals((int)1, (int)this.registry.warnMessages.size());
        Assertions.assertEquals((Object)expected, (Object)this.registry.warnMessages.get(0));
    }

    @Test
    public void testSupportedDefaultsSet() {
        SupportedDefaults default_1A_100 = SupportedDefaults.builder().withTransformerName("1").withSourceMediaType("mimetype/a").withMaxSourceSizeBytes(Long.valueOf(100L)).build();
        SupportedDefaults default_1A_200 = SupportedDefaults.builder().withTransformerName("1").withSourceMediaType("mimetype/a").withMaxSourceSizeBytes(Long.valueOf(200L)).build();
        SupportedDefaults default_2A__45 = SupportedDefaults.builder().withTransformerName("2").withSourceMediaType("mimetype/a").withPriority(Integer.valueOf(45)).build();
        SupportedDefaults default_3_400 = SupportedDefaults.builder().withTransformerName("3").withMaxSourceSizeBytes(Long.valueOf(400L)).build();
        SupportedDefaults default_B_400 = SupportedDefaults.builder().withSourceMediaType("mimetype/b").withMaxSourceSizeBytes(Long.valueOf(400L)).build();
        SupportedDefaults default_B_500 = SupportedDefaults.builder().withSourceMediaType("mimetype/b").withMaxSourceSizeBytes(Long.valueOf(500L)).build();
        SupportedDefaults default__600 = SupportedDefaults.builder().withMaxSourceSizeBytes(Long.valueOf(600L)).build();
        SupportedDefaults default___45 = SupportedDefaults.builder().withPriority(Integer.valueOf(45)).build();
        SupportedDefaults default___50 = SupportedDefaults.builder().withPriority(Integer.valueOf(50)).build();
        SupportedDefaults default__500_50 = SupportedDefaults.builder().withMaxSourceSizeBytes(Long.valueOf(500L)).withPriority(Integer.valueOf(50)).build();
        SupportedDefaults default__600_45 = SupportedDefaults.builder().withMaxSourceSizeBytes(Long.valueOf(600L)).withPriority(Integer.valueOf(45)).build();
        TransformConfig firstConfig = TransformConfig.builder().build();
        TransformConfig secondConfig = TransformConfig.builder().withSupportedDefaults((Set)ImmutableSet.of((Object)default_1A_100)).build();
        TransformConfig thirdConfig = TransformConfig.builder().withSupportedDefaults((Set)ImmutableSet.of((Object)default_1A_200, (Object)default_2A__45, (Object)default_3_400, (Object)default_B_400, (Object)default_B_500, (Object)default__500_50, (Object[])new SupportedDefaults[]{default__600, default___50, default___45})).build();
        TransformConfig fourthConfig = TransformConfig.builder().withSupportedDefaults((Set)ImmutableSet.of((Object)SupportedDefaults.builder().withMaxSourceSizeBytes(Long.valueOf(-1L)).withPriority(Integer.valueOf(45)).build())).build();
        TransformConfig fifthConfig = TransformConfig.builder().withSupportedDefaults((Set)ImmutableSet.of((Object)SupportedDefaults.builder().withPriority(Integer.valueOf(50)).build(), (Object)SupportedDefaults.builder().withTransformerName("9").withSourceMediaType("mimetype/z").build())).build();
        this.config.addTransformConfig(firstConfig, READ_FROM_A, BASE_URL_A, (AbstractTransformRegistry)this.registry);
        TransformConfig resultConfig = this.config.buildTransformConfig();
        Assertions.assertEquals((int)0, (int)resultConfig.getSupportedDefaults().size());
        this.config.addTransformConfig(secondConfig, READ_FROM_B, BASE_URL_B, (AbstractTransformRegistry)this.registry);
        resultConfig = this.config.buildTransformConfig();
        Assertions.assertEquals((Object)ImmutableSet.of((Object)default_1A_100), (Object)resultConfig.getSupportedDefaults());
        this.config.addTransformConfig(thirdConfig, READ_FROM_B, BASE_URL_B, (AbstractTransformRegistry)this.registry);
        resultConfig = this.config.buildTransformConfig();
        Assertions.assertEquals((Object)ImmutableSet.of((Object)default_1A_200, (Object)default_2A__45, (Object)default_3_400, (Object)default_B_500, (Object)default__600_45), (Object)resultConfig.getSupportedDefaults());
        this.config.addTransformConfig(fourthConfig, READ_FROM_B, BASE_URL_B, (AbstractTransformRegistry)this.registry);
        resultConfig = this.config.buildTransformConfig();
        Assertions.assertEquals((int)5, (int)resultConfig.getSupportedDefaults().size());
        this.config.addTransformConfig(fifthConfig, READ_FROM_A, BASE_URL_A, (AbstractTransformRegistry)this.registry);
        resultConfig = this.config.buildTransformConfig();
        Assertions.assertEquals((int)4, (int)resultConfig.getSupportedDefaults().size());
        Assertions.assertEquals((Object)ImmutableSet.of((Object)default_1A_200, (Object)default_2A__45, (Object)default_3_400, (Object)default_B_500), (Object)resultConfig.getSupportedDefaults());
        String expected = "Unable to process \"supportedDefaults\": [{\"transformerName\": \"9\", \"sourceMediaType\": \"mimetype/z\"}]. Read from readFromA";
        Assertions.assertEquals((int)1, (int)this.registry.warnMessages.size());
        Assertions.assertEquals((Object)expected, (Object)this.registry.warnMessages.get(0));
    }

    @Test
    public void testRemoveSupported() {
        this.addTransformConfig_A2B_X2Y_100_23();
        TransformConfig secondConfig = TransformConfig.builder().withRemoveSupported((Set)ImmutableSet.of((Object)((RemoveSupported)((RemoveSupported.Builder)((RemoveSupported.Builder)((RemoveSupported.Builder)RemoveSupported.builder().withTransformerName("1")).withSourceMediaType("mimetype/c")).withTargetMediaType("mimetype/d")).build()), (Object)((RemoveSupported)((RemoveSupported.Builder)((RemoveSupported.Builder)((RemoveSupported.Builder)RemoveSupported.builder().withTransformerName("1")).withSourceMediaType("mimetype/a")).withTargetMediaType("mimetype/b")).build()), (Object)((RemoveSupported)((RemoveSupported.Builder)((RemoveSupported.Builder)((RemoveSupported.Builder)RemoveSupported.builder().withTransformerName("bad")).withSourceMediaType("mimetype/a")).withTargetMediaType("mimetype/d")).build()), (Object)((RemoveSupported)((RemoveSupported.Builder)((RemoveSupported.Builder)RemoveSupported.builder().withSourceMediaType("mimetype/a")).withTargetMediaType("mimetype/d")).build()), (Object)((RemoveSupported)((RemoveSupported.Builder)((RemoveSupported.Builder)RemoveSupported.builder().withTransformerName("1")).withTargetMediaType("mimetype/d")).build()), (Object)((RemoveSupported)((RemoveSupported.Builder)((RemoveSupported.Builder)RemoveSupported.builder().withTransformerName("1")).withSourceMediaType("mimetype/a")).build()), (Object[])new RemoveSupported[0])).build();
        String expectedWarnMessage = "Unable to process \"removeSupported\": [{\"transformerName\": \"bad\", \"sourceMediaType\": \"mimetype/a\", \"targetMediaType\": \"mimetype/d\"}, {\"transformerName\": \"1\", \"sourceMediaType\": \"mimetype/a\"}, {\"transformerName\": \"1\", \"sourceMediaType\": \"mimetype/c\", \"targetMediaType\": \"mimetype/d\"}, {\"sourceMediaType\": \"mimetype/a\", \"targetMediaType\": \"mimetype/d\"}, {\"transformerName\": \"1\", \"targetMediaType\": \"mimetype/d\"}]. Read from readFromB";
        ImmutableSet expectedSupported = ImmutableSet.of((Object)this.supported_X2Y_100_23);
        String expectedToString = "[{\"sourceMediaType\": \"mimetype/x\", \"targetMediaType\": \"mimetype/y\", \"maxSourceSizeBytes\": \"100\", \"priority\": \"23\"}]";
        this.addTransformConfig(secondConfig, expectedWarnMessage, (Set<SupportedSourceAndTarget>)expectedSupported, expectedToString);
    }

    @Test
    public void testAddSupported() {
        this.addTransformConfig_A2B_X2Y_100_23();
        TransformConfig secondConfig = TransformConfig.builder().withAddSupported((Set)ImmutableSet.of((Object)((AddSupported)((AddSupported.Builder)((AddSupported.Builder)((AddSupported.Builder)AddSupported.builder().withTransformerName("1")).withSourceMediaType("mimetype/c")).withTargetMediaType("mimetype/d")).build()), (Object)((AddSupported)((AddSupported.Builder)((AddSupported.Builder)((AddSupported.Builder)((AddSupported.Builder)AddSupported.builder().withTransformerName("1")).withSourceMediaType("mimetype/a")).withTargetMediaType("mimetype/b")).withPriority(40)).build()), (Object)((AddSupported)((AddSupported.Builder)((AddSupported.Builder)((AddSupported.Builder)((AddSupported.Builder)((AddSupported.Builder)AddSupported.builder().withTransformerName("1")).withSourceMediaType("mimetype/a")).withTargetMediaType("mimetype/d")).withPriority(44)).withMaxSourceSizeBytes(1234L)).build()), (Object)((AddSupported)((AddSupported.Builder)((AddSupported.Builder)((AddSupported.Builder)AddSupported.builder().withTransformerName("bad")).withSourceMediaType("mimetype/a")).withTargetMediaType("mimetype/d")).build()), (Object)((AddSupported)((AddSupported.Builder)((AddSupported.Builder)AddSupported.builder().withSourceMediaType("mimetype/a")).withTargetMediaType("mimetype/d")).build()), (Object)((AddSupported)((AddSupported.Builder)((AddSupported.Builder)AddSupported.builder().withTransformerName("1")).withTargetMediaType("mimetype/d")).build()), (Object[])new AddSupported[]{(AddSupported)((AddSupported.Builder)((AddSupported.Builder)AddSupported.builder().withTransformerName("1")).withSourceMediaType("mimetype/a")).build()})).build();
        String expectedWarnMessage = "Unable to process \"addSupported\": [{\"transformerName\": \"1\", \"sourceMediaType\": \"mimetype/a\"}, {\"transformerName\": \"1\", \"targetMediaType\": \"mimetype/d\"}, {\"transformerName\": \"1\", \"sourceMediaType\": \"mimetype/a\", \"targetMediaType\": \"mimetype/b\", \"priority\": \"40\"}, {\"transformerName\": \"bad\", \"sourceMediaType\": \"mimetype/a\", \"targetMediaType\": \"mimetype/d\"}, {\"sourceMediaType\": \"mimetype/a\", \"targetMediaType\": \"mimetype/d\"}]. Read from readFromB";
        ImmutableSet expectedSupported = ImmutableSet.of((Object)this.supported_A2B, (Object)this.supported_C2D, (Object)this.supported_X2Y_100_23, (Object)this.supported_A2D_1234_44);
        String expectedToString = "[{\"sourceMediaType\": \"mimetype/x\", \"targetMediaType\": \"mimetype/y\", \"maxSourceSizeBytes\": \"100\", \"priority\": \"23\"}, {\"sourceMediaType\": \"mimetype/a\", \"targetMediaType\": \"mimetype/d\", \"maxSourceSizeBytes\": \"1234\", \"priority\": \"44\"}, {\"sourceMediaType\": \"mimetype/a\", \"targetMediaType\": \"mimetype/b\"}, {\"sourceMediaType\": \"mimetype/c\", \"targetMediaType\": \"mimetype/d\"}]";
        this.addTransformConfig(secondConfig, expectedWarnMessage, (Set<SupportedSourceAndTarget>)expectedSupported, expectedToString);
    }

    @Test
    public void testOverrideSupported() {
        this.addTransformConfig_A2B_X2Y_100_23();
        TransformConfig secondConfig = TransformConfig.builder().withOverrideSupported((Set)ImmutableSet.of((Object)((OverrideSupported)((OverrideSupported.Builder)((OverrideSupported.Builder)((OverrideSupported.Builder)OverrideSupported.builder().withTransformerName("1")).withSourceMediaType("mimetype/c")).withTargetMediaType("mimetype/d")).build()), (Object)((OverrideSupported)((OverrideSupported.Builder)((OverrideSupported.Builder)((OverrideSupported.Builder)((OverrideSupported.Builder)OverrideSupported.builder().withTransformerName("1")).withSourceMediaType("mimetype/a")).withTargetMediaType("mimetype/b")).withPriority(40)).build()), (Object)((OverrideSupported)((OverrideSupported.Builder)((OverrideSupported.Builder)((OverrideSupported.Builder)((OverrideSupported.Builder)OverrideSupported.builder().withTransformerName("1")).withSourceMediaType("mimetype/x")).withTargetMediaType("mimetype/y")).withMaxSourceSizeBytes(200L)).build()), (Object)((OverrideSupported)((OverrideSupported.Builder)((OverrideSupported.Builder)((OverrideSupported.Builder)OverrideSupported.builder().withTransformerName("bad")).withSourceMediaType("mimetype/a")).withTargetMediaType("mimetype/d")).build()))).build();
        String expectedWarnMessage = "Unable to process \"overrideSupported\": [{\"transformerName\": \"1\", \"sourceMediaType\": \"mimetype/c\", \"targetMediaType\": \"mimetype/d\"}, {\"transformerName\": \"bad\", \"sourceMediaType\": \"mimetype/a\", \"targetMediaType\": \"mimetype/d\"}]. Read from readFromB";
        ImmutableSet expectedSupported = ImmutableSet.of((Object)this.supported_X2Y_200, (Object)this.supported_A2B__40);
        String expectedToString = "[{\"sourceMediaType\": \"mimetype/a\", \"targetMediaType\": \"mimetype/b\", \"priority\": \"40\"}, {\"sourceMediaType\": \"mimetype/x\", \"targetMediaType\": \"mimetype/y\", \"maxSourceSizeBytes\": \"200\"}]";
        this.addTransformConfig(secondConfig, expectedWarnMessage, (Set<SupportedSourceAndTarget>)expectedSupported, expectedToString);
    }

    private void addTransformConfig_A2B_X2Y_100_23() {
        this.config.addTransformConfig(this.transformConfig_A2B_X2Y_100_23, READ_FROM_A, BASE_URL_A, (AbstractTransformRegistry)this.registry);
        TransformConfig resultConfig = this.config.buildTransformConfig();
        Assertions.assertEquals((int)1, (int)resultConfig.getTransformers().size());
        Assertions.assertEquals((int)2, (int)((Transformer)resultConfig.getTransformers().get(0)).getSupportedSourceAndTargetList().size());
    }

    private void addTransformConfig(TransformConfig secondConfig, String expectedWarnMessage, Set<SupportedSourceAndTarget> expectedSupported, String expectedToString) {
        this.config.addTransformConfig(secondConfig, READ_FROM_B, BASE_URL_B, (AbstractTransformRegistry)this.registry);
        TransformConfig resultConfig = this.config.buildTransformConfig();
        Assertions.assertEquals((int)1, (int)this.registry.warnMessages.size());
        Assertions.assertEquals((Object)expectedWarnMessage, (Object)this.registry.warnMessages.get(0));
        Set supportedSourceAndTargetList = ((Transformer)resultConfig.getTransformers().get(0)).getSupportedSourceAndTargetList();
        Assertions.assertTrue((boolean)supportedSourceAndTargetList.equals(expectedSupported));
        Assertions.assertEquals((Object)expectedToString, (Object)supportedSourceAndTargetList.toString());
    }
}

