/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.transform.misc.transformers;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Map;
import org.alfresco.transform.base.TransformManager;
import org.alfresco.transform.base.util.CustomTransformerFileAdaptor;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackageRelationship;
import org.apache.poi.openxml4j.opc.PackageRelationshipCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class OOXMLThumbnailContentTransformer
implements CustomTransformerFileAdaptor {
    private static final Logger logger = LoggerFactory.getLogger(OOXMLThumbnailContentTransformer.class);

    public String getTransformerName() {
        return "ooXmlThumbnail";
    }

    public void transform(String sourceMimetype, String targetMimetype, Map<String, String> parameters, File sourceFile, File targetFile, TransformManager transformManager) throws Exception {
        block10: {
            if (logger.isDebugEnabled()) {
                logger.debug("Performing OOXML to jpeg transform with sourceMimetype=" + sourceMimetype + " targetMimetype=" + targetMimetype);
            }
            try (OPCPackage pkg = OPCPackage.open((String)sourceFile.getPath());){
                PackageRelationshipCollection rels = pkg.getRelationshipsByType("http://schemas.openxmlformats.org/package/2006/relationships/metadata/thumbnail");
                if (rels.size() > 0) {
                    PackageRelationship tRel = rels.getRelationship(0);
                    PackagePart tPart = pkg.getPart(tRel);
                    InputStream tStream = tPart.getInputStream();
                    Files.copy(tStream, targetFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    tStream.close();
                    break block10;
                }
                logger.debug("No thumbnail present in file.");
                throw new Exception("No thumbnail present in file, unable to generate " + targetMimetype);
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to transform file.", e);
            }
        }
    }
}

