/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.transform.misc.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.jupiter.params.provider.Arguments;

public class ArgumentsCartesianProduct {
    public static Stream<Arguments> of(Object fixedFirstArgument, Stream<?> secondArguments) {
        return secondArguments.map(secondArgument -> Arguments.of((Object[])new Object[]{fixedFirstArgument, secondArgument}));
    }

    public static Stream<Arguments> of(Stream<?> firstArguments, Object ... otherFixedArguments) {
        return firstArguments.map(firstArgument -> Arguments.of((Object[])new Object[]{firstArgument, otherFixedArguments}));
    }

    public static Stream<Arguments> of(Stream<?> firstArguments, Stream<?> secondArguments) {
        return ArgumentsCartesianProduct.cartesianProductOf(firstArguments, secondArguments).map(arguments -> Arguments.of((Object[])arguments.toArray()));
    }

    public static Stream<Arguments> of(Stream<?> ... argumentsStreams) {
        return ArgumentsCartesianProduct.cartesianProductOf(argumentsStreams).map(arguments -> Arguments.of((Object[])arguments.toArray()));
    }

    @SafeVarargs
    public static Stream<Arguments> ofArguments(Stream<Arguments> ... argumentsStreams) {
        return ArgumentsCartesianProduct.cartesianProductOf(argumentsStreams).map(argumentsStream -> argumentsStream).map(argumentsStream -> Arguments.of((Object[])argumentsStream.flatMap(arguments -> Arrays.stream(arguments.get())).toArray()));
    }

    private static Stream<Stream<?>> cartesianProductOf(Stream<?> ... streams) {
        if (streams == null) {
            return Stream.empty();
        }
        return Stream.of(streams).filter(Objects::nonNull).map(stream -> stream.map(Collections::singletonList)).reduce((result, nextElements) -> {
            List nextElementsCopy = nextElements.collect(Collectors.toList());
            return result.flatMap(resultPortion -> nextElementsCopy.stream().map(nextElementsPortion -> {
                ArrayList extendedResultPortion = new ArrayList();
                extendedResultPortion.addAll(resultPortion);
                extendedResultPortion.addAll(nextElementsPortion);
                return extendedResultPortion;
            }));
        }).orElse(Stream.empty()).map(Collection::stream);
    }
}

