/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.transform.misc.metadataExtractors;

import jakarta.mail.Address;
import jakarta.mail.Header;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeUtility;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.alfresco.transform.base.TransformManager;
import org.alfresco.transform.base.metadata.AbstractMetadataExtractorEmbedder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class RFC822MetadataExtractor
extends AbstractMetadataExtractorEmbedder {
    private static final Logger logger = LoggerFactory.getLogger(RFC822MetadataExtractor.class);
    protected static final String KEY_MESSAGE_FROM = "messageFrom";
    protected static final String KEY_MESSAGE_TO = "messageTo";
    protected static final String KEY_MESSAGE_CC = "messageCc";
    protected static final String KEY_MESSAGE_SUBJECT = "messageSubject";
    protected static final String KEY_MESSAGE_SENT = "messageSent";
    protected static final String KEY_MESSAGE_RECEIVED = "messageReceived";

    public RFC822MetadataExtractor() {
        super(AbstractMetadataExtractorEmbedder.Type.EXTRACTOR, logger);
    }

    public void embedMetadata(String sourceMimetype, InputStream inputStream, String targetMimetype, OutputStream outputStream, Map<String, String> transformOptions, TransformManager transformManager) throws Exception {
    }

    public Map<String, Serializable> extractMetadata(String sourceMimetype, InputStream inputStream, String targetMimetype, OutputStream outputStream, Map<String, String> transformOptions, TransformManager transformManager) throws Exception {
        HashMap<String, Serializable> rawProperties = new HashMap<String, Serializable>();
        MimeMessage mimeMessage = new MimeMessage(null, inputStream);
        if (mimeMessage != null) {
            String tmp = InternetAddress.toString((Address[])mimeMessage.getFrom());
            tmp = tmp != null ? MimeUtility.decodeText((String)tmp) : null;
            this.putRawValue(KEY_MESSAGE_FROM, (Serializable)((Object)tmp), rawProperties);
            tmp = InternetAddress.toString((Address[])mimeMessage.getRecipients(MimeMessage.RecipientType.TO));
            tmp = tmp != null ? MimeUtility.decodeText((String)tmp) : null;
            this.putRawValue(KEY_MESSAGE_TO, (Serializable)((Object)tmp), rawProperties);
            tmp = InternetAddress.toString((Address[])mimeMessage.getRecipients(MimeMessage.RecipientType.CC));
            tmp = tmp != null ? MimeUtility.decodeText((String)tmp) : null;
            this.putRawValue(KEY_MESSAGE_CC, (Serializable)((Object)tmp), rawProperties);
            this.putRawValue(KEY_MESSAGE_SENT, (Serializable)mimeMessage.getSentDate(), rawProperties);
            Date rxDate = mimeMessage.getReceivedDate();
            if (rxDate != null) {
                this.putRawValue(KEY_MESSAGE_RECEIVED, (Serializable)rxDate, rawProperties);
            } else {
                String[] rx = mimeMessage.getHeader("received");
                if (rx != null && rx.length > 0) {
                    String lastReceived = rx[0];
                    int x = (lastReceived = MimeUtility.unfold((String)lastReceived)).lastIndexOf(59);
                    if (x > 0) {
                        String dateStr = lastReceived.substring(x + 1).trim();
                        this.putRawValue(KEY_MESSAGE_RECEIVED, (Serializable)((Object)dateStr), rawProperties);
                    }
                }
            }
            String[] subj = mimeMessage.getHeader("Subject");
            if (subj != null && subj.length > 0) {
                String decodedSubject = subj[0];
                try {
                    decodedSubject = MimeUtility.decodeText((String)decodedSubject);
                }
                catch (UnsupportedEncodingException e) {
                    logger.warn(e.toString());
                }
                this.putRawValue(KEY_MESSAGE_SUBJECT, (Serializable)((Object)decodedSubject), rawProperties);
            }
            Set keys = this.getExtractMapping().keySet();
            Enumeration headers = mimeMessage.getAllHeaders();
            while (headers.hasMoreElements()) {
                Header header = (Header)headers.nextElement();
                if (!keys.contains(header.getName())) continue;
                tmp = header.getValue();
                tmp = tmp != null ? MimeUtility.decodeText((String)tmp) : null;
                this.putRawValue(header.getName(), (Serializable)((Object)tmp), rawProperties);
            }
        }
        return rawProperties;
    }
}

