/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.transform.misc;

import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import org.alfresco.transform.base.AbstractBaseTest;
import org.apache.pdfbox.Loader;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.text.PDFTextStripper;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockHttpServletRequestBuilder;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class MiscTest
extends AbstractBaseTest {
    protected static final String sourceEncoding = "UTF-8";
    protected static final String targetEncoding = "UTF-8";
    protected final String targetMimetype = "text/plain";

    @BeforeEach
    public void before() throws Exception {
        this.sourceMimetype = "text/html";
        this.sourceExtension = "html";
        this.targetExtension = "txt";
        this.expectedOptions = null;
        this.expectedSourceSuffix = null;
        this.sourceFileBytes = this.readTestFile(this.sourceExtension);
        this.expectedTargetFileBytes = Files.readAllBytes(this.getTestFile("quick3." + this.targetExtension, true).toPath());
        this.sourceFile = new MockMultipartFile("file", "quick." + this.sourceExtension, this.sourceMimetype, this.sourceFileBytes);
    }

    protected MockHttpServletRequestBuilder mockMvcRequest(String url, MockMultipartFile sourceFile, String ... params) {
        MockHttpServletRequestBuilder builder = super.mockMvcRequest(url, sourceFile, params).param("sourceEncoding", new String[]{"UTF-8"}).param("targetMimetype", new String[]{"text/plain"}).param("sourceMimetype", new String[]{this.sourceMimetype}).param("collapseHtml", new String[]{"true"});
        if (!"message/rfc822".equals(this.sourceMimetype) && !"text/html".equals(this.sourceMimetype)) {
            builder.param("targetEncoding", new String[]{"UTF-8"});
        }
        return builder;
    }

    @Test
    public void testRFC822ToText() throws Exception {
        String expected = "Gym class featuring a brown fox and lazy dog";
        MvcResult result = this.sendRequest("eml", null, "message/rfc822", "txt", "text/plain", null, null, null, this.readTestFile("eml"));
        Assertions.assertTrue((boolean)result.getResponse().getContentAsString().contains(expected), (String)"Content from eml transform didn't contain expected value. ");
    }

    @Test
    public void testNonAsciiRFC822ToText() throws Exception {
        String expected = "El r\u00e1pido zorro marr\u00f3n salta sobre el perro perezoso";
        MvcResult result = this.sendRequest("eml", null, "message/rfc822", "txt", "text/plain", null, null, null, this.readTestFile("spanish.eml"));
        String contentResult = new String(result.getResponse().getContentAsByteArray(), StandardCharsets.UTF_8);
        Assertions.assertTrue((boolean)contentResult.contains(expected), (String)"Content from eml transform didn't contain expected value. ");
    }

    @Test
    public void testRFC822WithAttachmentToText() throws Exception {
        String expected = "Mail with attachment content";
        String notExpected = "File attachment content";
        MvcResult result = this.sendRequest("eml", null, "message/rfc822", "txt", "text/plain", null, null, null, this.readTestFile("attachment.eml"));
        Assertions.assertTrue((boolean)result.getResponse().getContentAsString().contains(expected), (String)"Content from eml transform didn't contain expected value. ");
        Assertions.assertFalse((boolean)result.getResponse().getContentAsString().contains(notExpected));
    }

    @Test
    public void testRFC822AlternativeToText() throws Exception {
        String expected = "alternative plain text";
        MvcResult result = this.sendRequest("eml", null, "message/rfc822", "txt", "text/plain", null, null, null, this.readTestFile("alternative.eml"));
        Assertions.assertTrue((boolean)result.getResponse().getContentAsString().contains(expected), (String)"Content from eml transform didn't contain expected value. ");
    }

    @Test
    public void testRFC822NestedAlternativeToText() throws Exception {
        String expected = "nested alternative plain text";
        MvcResult result = this.sendRequest("eml", null, "message/rfc822", "txt", "text/plain", null, null, null, this.readTestFile("nested.alternative.eml"));
        Assertions.assertTrue((boolean)result.getResponse().getContentAsString().contains(expected), (String)"Content from eml transform didn't contain expected value. ");
    }

    @Test
    public void testExtractMetadataRFC822() throws Exception {
        String expected = "{\"{http://www.alfresco.org/model/content/1.0}addressee\":\"Nevin Nollop <nevin.nollop@gmail.com>\",\"{http://www.alfresco.org/model/content/1.0}addressees\":\"Nevin Nollop <nevinn@alfresco.com>\",\"{http://www.alfresco.org/model/content/1.0}description\":\"The quick brown fox jumps over the lazy dog\",\"{http://www.alfresco.org/model/content/1.0}originator\":\"Nevin Nollop <nevin.nollop@alfresco.com>\",\"{http://www.alfresco.org/model/content/1.0}sentdate\":1086351802000,\"{http://www.alfresco.org/model/content/1.0}subjectline\":\"The quick brown fox jumps over the lazy dog\",\"{http://www.alfresco.org/model/content/1.0}title\":\"The quick brown fox jumps over the lazy dog\",\"{http://www.alfresco.org/model/imap/1.0}dateSent\":1086351802000,\"{http://www.alfresco.org/model/imap/1.0}messageCc\":\"Nevin Nollop <nevinn@alfresco.com>\",\"{http://www.alfresco.org/model/imap/1.0}messageFrom\":\"Nevin Nollop <nevin.nollop@alfresco.com>\",\"{http://www.alfresco.org/model/imap/1.0}messageId\":\"<20040604122322.GV1905@phoenix.home>\",\"{http://www.alfresco.org/model/imap/1.0}messageSubject\":\"The quick brown fox jumps over the lazy dog\",\"{http://www.alfresco.org/model/imap/1.0}messageTo\":\"Nevin Nollop <nevin.nollop@gmail.com>\"}";
        MvcResult result = this.sendRequest("eml", null, "message/rfc822", "json", "alfresco-metadata-extract", null, null, null, this.readTestFile("eml"));
        String metadata = result.getResponse().getContentAsString();
        Assertions.assertEquals((Object)expected, (Object)metadata, (String)"Metadata extract");
    }

    @Test
    public void testExtractMetadataOptionRFC822() throws Exception {
        String extractMapping = "{\"messageSubject\":[\"{http://www.alfresco.org/model/imap/1.0}messageSubject\",\"{http://www.alfresco.org/model/content/1.0}title\"],\"Thread-Index\":[\"{http://www.alfresco.org/model/imap/1.0}threadIndex\"],\"messageFrom\":[\"{http://www.alfresco.org/model/dod5015/1.0}dodProp1\"]}\n";
        String expected = "{\"{http://www.alfresco.org/model/content/1.0}title\":\"The quick brown fox jumps over the lazy dog\",\"{http://www.alfresco.org/model/dod5015/1.0}dodProp1\":\"Nevin Nollop <nevin.nollop@alfresco.com>\",\"{http://www.alfresco.org/model/imap/1.0}messageSubject\":\"The quick brown fox jumps over the lazy dog\"}";
        MvcResult result = this.sendRequest("eml", null, "message/rfc822", "json", "alfresco-metadata-extract", null, null, extractMapping, this.readTestFile("eml"));
        String metadata = result.getResponse().getContentAsString();
        Assertions.assertEquals((Object)expected, (Object)metadata, (String)"Option metadata extract");
    }

    @Test
    public void testHtmlSpecialCharsToText() throws Exception {
        String expected = "&nbsp;";
        MvcResult result = this.sendRequest("eml", null, "message/rfc822", "txt", "text/plain", null, null, null, this.readTestFile("htmlChars.eml"));
        Assertions.assertFalse((boolean)result.getResponse().getContentAsString().contains(expected));
    }

    @Test
    public void testHTMLtoString() throws Exception {
        String NEWLINE = System.getProperty("line.separator");
        String TITLE = "Testing!";
        String TEXT_P1 = "This is some text in English";
        String TEXT_P2 = "This is more text in English";
        String TEXT_P3 = "C'est en Fran\u00e7ais et Espa\u00f1ol";
        String partA = "<html><head><title>Testing!</title></head>" + NEWLINE;
        String partB = "<body><p>This is some text in English</p>" + NEWLINE + "<p>This is more text in English</p>" + NEWLINE + "<p>C'est en Fran\u00e7ais et Espa\u00f1ol</p>" + NEWLINE;
        String partC = "</body></html>";
        String expected = "Testing! This is some text in English This is more text in English C'est en Fran\u00e7ais et Espa\u00f1ol";
        MvcResult result = this.sendRequest("html", "UTF-8", "text/html", "txt", "text/plain", null, null, null, "Testing! This is some text in English This is more text in English C'est en Fran\u00e7ais et Espa\u00f1ol".getBytes());
        String contentResult = new String(result.getResponse().getContentAsByteArray(), "UTF-8");
        Assertions.assertTrue((boolean)contentResult.contains("Testing! This is some text in English This is more text in English C'est en Fran\u00e7ais et Espa\u00f1ol"), (String)"The content did not include \"Testing! This is some text in English This is more text in English C'est en Fran\u00e7ais et Espa\u00f1ol");
    }

    @Test
    public void testStringToString() throws Exception {
        String expected;
        byte[] content;
        try {
            content = "azAz10!\ufffd$%^&*()\t\r\n".getBytes(StandardCharsets.UTF_8);
            expected = new String(content, "MacDingbat");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Encoding not recognised", e);
        }
        MvcResult result = this.sendRequest("txt", "MacDingbat", "text/plain", "txt", "text/plain", "UTF-8", null, null, content);
        String contentResult = new String(result.getResponse().getContentAsByteArray(), "UTF-8");
        Assertions.assertTrue((boolean)contentResult.contains(expected), (String)("The content did not include \"" + expected));
    }

    @Test
    public void testEmptyTextFileReturnsEmptyFile() throws Exception {
        byte[] content = new byte[]{};
        MvcResult result = this.sendRequest("txt", "UTF-8", "text/plain", "txt", "text/plain", "UTF-8", null, null, content);
        Assertions.assertEquals((int)0, (int)result.getResponse().getContentLength(), (String)"Returned content should be empty for an empty source file");
    }

    @Test
    public void textToPdf() throws Exception {
        StringBuilder sb = new StringBuilder();
        for (int i = 1; i <= 5; ++i) {
            sb.append(Integer.toString(i));
            sb.append(" I must not talk in class or feed my homework to my cat.\n");
        }
        sb.append("\nBart\n");
        String expected = sb.toString();
        MvcResult result = this.sendRequest("txt", "UTF-8", "text/plain", "pdf", "application/pdf", null, "1", null, expected.getBytes());
        PDDocument doc = Loader.loadPDF((byte[])result.getResponse().getContentAsByteArray());
        PDFTextStripper textStripper = new PDFTextStripper();
        StringWriter textWriter = new StringWriter();
        textStripper.writeText(doc, (Writer)textWriter);
        doc.close();
        expected = this.clean(expected);
        String actual = this.clean(textWriter.toString());
        Assertions.assertEquals((Object)expected, (Object)actual, (String)"The content did not match.");
    }

    @Test
    public void testAppleIWorksPages() throws Exception {
        MvcResult result = this.sendRequest("numbers", null, "application/vnd.apple.numbers", "jpeg", "image/jpeg", null, null, null, this.readTestFile("pages"));
        Assertions.assertTrue(((long)result.getResponse().getContentAsByteArray().length > 0L ? 1 : 0) != 0, (String)"Expected image content but content is empty.");
    }

    @Test
    public void testAppleIWorksNumbers() throws Exception {
        MvcResult result = this.sendRequest("numbers", null, "application/vnd.apple.numbers", "jpeg", "image/jpeg", null, null, null, this.readTestFile("numbers"));
        Assertions.assertTrue(((long)result.getResponse().getContentAsByteArray().length > 0L ? 1 : 0) != 0, (String)"Expected image content but content is empty.");
    }

    @Test
    public void testAppleIWorksKey() throws Exception {
        MvcResult result = this.sendRequest("key", null, "application/vnd.apple.keynote", "jpeg", "image/jpeg", null, null, null, this.readTestFile("key"));
        Assertions.assertTrue(((long)result.getResponse().getContentAsByteArray().length > 0L ? 1 : 0) != 0, (String)"Expected image content but content is empty.");
    }

    private MvcResult sendRequest(String sourceExtension, String sourceEncoding, String sourceMimetype, String targetExtension, String targetMimetype, String targetEncoding, String pageLimit, String extractMapping, byte[] content) throws Exception {
        MockMultipartFile sourceFile = new MockMultipartFile("file", "test_file." + sourceExtension, sourceMimetype, content);
        MockHttpServletRequestBuilder requestBuilder = super.mockMvcRequest("/transform", sourceFile, new String[0]).param("targetMimetype", new String[]{targetMimetype}).param("sourceMimetype", new String[]{sourceMimetype});
        if (sourceEncoding != null) {
            requestBuilder.param("sourceEncoding", new String[]{sourceEncoding});
        }
        if (targetEncoding != null) {
            requestBuilder.param("targetEncoding", new String[]{targetEncoding});
        }
        if (pageLimit != null) {
            requestBuilder.param("pageLimit", new String[]{pageLimit});
        }
        if (extractMapping != null) {
            requestBuilder.param("extractMapping", new String[]{extractMapping});
        }
        return this.mockMvc.perform((RequestBuilder)requestBuilder).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.header().string("Content-Disposition", "attachment; filename*=" + (targetEncoding == null ? "UTF-8" : targetEncoding) + "''transform." + targetExtension)).andReturn();
    }

    private String clean(String text) {
        text = text.replaceAll("\\s+\\r", "");
        text = text.replaceAll("\\s+\\n", "");
        text = text.replaceAll("\\r", "");
        text = text.replaceAll("\\n", "");
        return text;
    }

    @Test
    public void queueTransformRequestUsingDirectAccessUrlTest() throws Exception {
        ((AbstractBaseTest)this).targetMimetype = this.targetMimetype;
        super.queueTransformRequestUsingDirectAccessUrlTest();
    }
}

