/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.transform.misc.transformers;

import jakarta.annotation.PostConstruct;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Map;
import org.alfresco.transform.base.TransformManager;
import org.alfresco.transform.base.util.CustomTransformerFileAdaptor;
import org.alfresco.transform.misc.transformers.TextToPdfContentTransformer;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class TextToPdfContentTransformer
implements CustomTransformerFileAdaptor {
    private static final Logger logger = LoggerFactory.getLogger(TextToPdfContentTransformer.class);
    private static final int UTF16_READ_AHEAD_BYTES = 16;
    private static final byte FE = -2;
    private static final byte FF = -1;
    private static final int UTF8_READ_AHEAD_BYTES = 3;
    private static final byte EF = -17;
    private static final byte BB = -69;
    private static final byte BF = -65;
    private static final String DEFAULT_FONT = "NotoSans-Regular";
    private static final int DEFAULT_FONT_SIZE = 10;
    private final PagedTextToPDF transformer = new PagedTextToPDF();
    @Value(value="${transform.core.misc.pdfBox.defaultFont:NotoSans-Regular}")
    private String pdfBoxDefaultFont;

    @PostConstruct
    public void init() {
        this.transformer.setDefaultFont(this.pdfBoxDefaultFont);
    }

    public void setStandardFont(String fontName) {
        try {
            this.transformer.setFont(fontName);
        }
        catch (Throwable e) {
            throw new RuntimeException("Unable to set Standard Font for PDF generation: " + fontName, e);
        }
    }

    public void setFontSize(int fontSize) {
        try {
            this.transformer.setFontSize(fontSize);
        }
        catch (Throwable e) {
            throw new RuntimeException("Unable to set Font Size for PDF generation: " + fontSize);
        }
    }

    public String getUsedFont() {
        return this.transformer.getFontName();
    }

    public String getTransformerName() {
        return "textToPdf";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transform(String sourceMimetype, String targetMimetype, Map<String, String> transformOptions, File sourceFile, File targetFile, TransformManager transformManager) throws Exception {
        String pdfFont;
        String sourceEncoding = transformOptions.get("sourceEncoding");
        String stringPageLimit = transformOptions.get("pageLimit");
        int pageLimit = -1;
        if (stringPageLimit != null) {
            pageLimit = this.parseInt(stringPageLimit, "pageLimit");
        }
        if ((pdfFont = transformOptions.get("pdfFont")) == null || pdfFont.isBlank()) {
            pdfFont = this.pdfBoxDefaultFont;
        }
        String pdfFontSize = transformOptions.get("pdfFontSize");
        Integer fontSize = null;
        if (pdfFontSize != null && !pdfFontSize.isBlank()) {
            try {
                fontSize = this.parseInt(pdfFontSize, "pdfFontSize");
            }
            catch (Exception e) {
                fontSize = 10;
                logger.error("Error parsing font size {}, going to set it as {}", new Object[]{pdfFontSize, fontSize, e});
            }
        }
        PDDocument pdf = null;
        try (FileInputStream is = new FileInputStream(sourceFile);
             BufferedReader ir = new BufferedReader(this.buildReader((InputStream)is, sourceEncoding));
             BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(targetFile));){
            pdf = this.transformer.createPDFFromText((Reader)ir, pageLimit, pdfFont, fontSize);
            pdf.save((OutputStream)os);
        }
        finally {
            if (pdf != null) {
                try {
                    pdf.close();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }
    }

    protected InputStreamReader buildReader(InputStream is, String encoding) {
        if (encoding != null) {
            Charset charset = null;
            try {
                charset = Charset.forName(encoding);
            }
            catch (Exception e) {
                logger.warn("JVM doesn't understand encoding '" + encoding + "' when transforming text to pdf");
            }
            if (charset != null) {
                String name = charset.displayName();
                if ("UTF-16".equals(name) || "UTF-16BE".equals(name) || "UTF-16LE".equals(name)) {
                    logger.debug("Handle big and little endian UTF-16 text. Using UTF-16 rather than encoding " + name);
                    charset = Charset.forName("UTF-16");
                    is = this.handleUTF16BOM(is);
                } else if ("UTF-8".equals(name)) {
                    logger.debug("Using UTF-8");
                    charset = Charset.forName("UTF-8");
                    is = this.handleUTF8BOM(is);
                }
                logger.debug("Processing plain text in encoding " + name);
                return new InputStreamReader(is, charset);
            }
        }
        logger.debug("Processing plain text using system default encoding");
        return new InputStreamReader(is);
    }

    private int parseInt(String s, String paramName) {
        try {
            return Integer.valueOf(s);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(paramName + " parameter must be an integer.");
        }
    }

    private InputStream handleUTF8BOM(InputStream is) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private InputStream handleUTF16BOM(InputStream is) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }
}

