/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.transform.misc.transformers;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.util.Map;
import org.alfresco.transform.base.TransformManager;
import org.alfresco.transform.base.util.CustomTransformerFileAdaptor;
import org.alfresco.transform.misc.transformers.HtmlParserContentTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class HtmlParserContentTransformer
implements CustomTransformerFileAdaptor {
    private static final Logger logger = LoggerFactory.getLogger(HtmlParserContentTransformer.class);
    @Value(value="${transform.core.misc.htmlOptions.collapseHtml:true}")
    private String collapseOptionDefault;

    public String getTransformerName() {
        return "html";
    }

    public void transform(String sourceMimetype, String targetMimetype, Map<String, String> transformOptions, File sourceFile, File targetFile, TransformManager transformManager) throws Exception {
        boolean collapse;
        String sourceEncoding = transformOptions.get("sourceEncoding");
        this.checkEncodingParameter(sourceEncoding, "sourceEncoding");
        String collapseOption = transformOptions.get("collapseHtml");
        if (collapseOption != null && (collapseOption.trim().equalsIgnoreCase("true") || collapseOption.trim().equalsIgnoreCase("false"))) {
            collapse = Boolean.parseBoolean(collapseOption);
        } else {
            boolean bl = collapse = this.collapseOptionDefault == null || Boolean.parseBoolean(this.collapseOptionDefault);
            if (logger.isDebugEnabled()) {
                logger.debug("Using default html collapse option: " + this.collapseOptionDefault);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Performing HTML to text transform with sourceEncoding=" + sourceEncoding);
        }
        EncodingAwareStringBean extractor = new EncodingAwareStringBean();
        extractor.setCollapse(collapse);
        extractor.setLinks(false);
        extractor.setReplaceNonBreakingSpaces(false);
        extractor.setURL(sourceFile, sourceEncoding);
        String text = extractor.getStrings();
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(targetFile)));){
            writer.write(text);
        }
    }

    private void checkEncodingParameter(String encoding, String parameterName) {
        try {
            if (encoding != null && !Charset.isSupported(encoding)) {
                throw new IllegalArgumentException(parameterName + "=" + encoding + " is not supported by the JVM.");
            }
        }
        catch (IllegalCharsetNameException e) {
            throw new IllegalArgumentException(parameterName + "=" + encoding + " is not a valid encoding.");
        }
    }
}

