/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.transform.libreoffice.patch;

import org.alfresco.transform.libreoffice.patch.LibreOfficeProfileManager;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.runner.RunWith;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
class LibreOfficeProfileManagerTest {
    LibreOfficeProfileManagerTest() {
    }

    @Test
    void testGetEffectiveTemplateProfileDir_WithNullInput() {
        LibreOfficeProfileManager profileManager = new LibreOfficeProfileManager(null);
        String result = profileManager.getEffectiveTemplateProfileDir();
        Assertions.assertNull((Object)result);
    }

    @Test
    void testGetEffectiveTemplateProfileDir_WithEmptyString() {
        LibreOfficeProfileManager profileManager = new LibreOfficeProfileManager("");
        String result = profileManager.getEffectiveTemplateProfileDir();
        Assertions.assertEquals((Object)"", (Object)result);
    }

    @Test
    void testGetEffectiveTemplateProfileDir_WithBlankString() {
        LibreOfficeProfileManager profileManager = new LibreOfficeProfileManager("   ");
        String result = profileManager.getEffectiveTemplateProfileDir();
        Assertions.assertEquals((Object)"   ", (Object)result);
    }

    @Test
    void testGetEffectiveTemplateProfileDir_WithValidUserPath() {
        String validPath = "/path/to/template/profile";
        LibreOfficeProfileManager profileManager = new LibreOfficeProfileManager(validPath);
        String result = profileManager.getEffectiveTemplateProfileDir();
        Assertions.assertEquals((Object)validPath, (Object)result);
    }

    @Test
    void testGetEffectiveTemplateProfileDir_WithDefaultMarkerCreatesTempDir() {
        LibreOfficeProfileManager profileManager = new LibreOfficeProfileManager("alfresco_default");
        String result = profileManager.getEffectiveTemplateProfileDir();
        Assertions.assertNotNull((Object)result);
        Assertions.assertFalse((boolean)result.isBlank());
    }

    @Test
    void testGetEffectiveTemplateProfileDir_WithMultiplePathFormats() {
        String[] paths;
        for (String path : paths = new String[]{"C:\\path\\to\\template", "/path/to/template", "/path/to/template/", "relative/path/to/template"}) {
            LibreOfficeProfileManager manager = new LibreOfficeProfileManager(path);
            String result = manager.getEffectiveTemplateProfileDir();
            Assertions.assertEquals((Object)path, (Object)result);
        }
    }
}

