/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.transform.libreoffice.patch;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class LibreOfficeProfileManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(LibreOfficeProfileManager.class);
    private static final String DEFAULT_LO_TEMPLATE_PROFILE = "libreoffice_templateProfile";
    private static final String DEFAULT_TEMPLATE_MARKER = "alfresco_default";
    private final String templateProfileDir;

    public LibreOfficeProfileManager(String templateProfileDir) {
        this.templateProfileDir = templateProfileDir;
    }

    public String getEffectiveTemplateProfileDir() {
        if (DEFAULT_TEMPLATE_MARKER.equalsIgnoreCase(this.templateProfileDir)) {
            return this.createDefaultTemplateProfileDirFromResource();
        }
        if (StringUtils.isNotBlank((CharSequence)this.templateProfileDir)) {
            LOGGER.warn("Template profile directory found. Make sure that the BlockUntrustedRefererLinks security setting is set to true in the registrymodifications.xcu file of the LibreOffice profile.");
        } else {
            LOGGER.warn("No template profile directory provided, using default settings. Untrusted referer links are allowed. It is recommended to set the template profile directory to `{}` to prevent Blind SSRF risks.", (Object)DEFAULT_TEMPLATE_MARKER);
        }
        return this.templateProfileDir;
    }

    private String createDefaultTemplateProfileDirFromResource() {
        try {
            String baseDir = "templateProfileDir";
            Object[] resources = this.loadResources("classpath:" + baseDir);
            if (ArrayUtils.isEmpty((Object[])resources)) {
                return null;
            }
            Path tempDir = Files.createTempDirectory(DEFAULT_LO_TEMPLATE_PROFILE, new FileAttribute[0]);
            for (Object resource : resources) {
                String relative;
                if (!resource.isReadable() || resource.contentLength() == 0L || StringUtils.isBlank((CharSequence)(relative = this.resolveRelativePath((Resource)resource, baseDir)))) continue;
                this.copyResource((Resource)resource, tempDir.resolve(relative));
            }
            return tempDir.toString();
        }
        catch (IOException e) {
            LOGGER.warn("Error creating temporary directory for LibreOffice profile. {}", (Object)e.getMessage());
            return null;
        }
    }

    private Resource[] loadResources(String classpathTemplateDir) {
        Object[] resources;
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        try {
            resources = resolver.getResources(classpathTemplateDir + "/**");
        }
        catch (Exception e) {
            LOGGER.warn("No resources found for classpath: {}.\n {}", (Object)classpathTemplateDir, (Object)e.getMessage());
            return new Resource[0];
        }
        if (ArrayUtils.isEmpty((Object[])resources)) {
            LOGGER.warn("No resources found for classpath: {}", (Object)classpathTemplateDir);
        }
        return resources;
    }

    private String resolveRelativePath(Resource resource, String baseDir) {
        try {
            String url = resource.getURL().toString();
            if (!url.contains(baseDir)) {
                LOGGER.warn("Base directory '{}' not found in resource URL '{}'. Skipping.", (Object)baseDir, (Object)url);
                return null;
            }
            int baseIndex = url.indexOf(baseDir);
            String relative = url.substring(baseIndex + baseDir.length() + 1);
            if (relative.isEmpty()) {
                LOGGER.warn("Relative path is empty for resource URL '{}'. Skipping.", (Object)url);
                return null;
            }
            return relative;
        }
        catch (Exception e) {
            LOGGER.warn("Error resolving URL for resource: {}. {}", (Object)resource, (Object)e.getMessage());
            return null;
        }
    }

    private void copyResource(Resource resource, Path target) {
        try {
            Files.createDirectories(target.getParent(), new FileAttribute[0]);
            try (InputStream in = resource.getInputStream();){
                LOGGER.info("Creating temporary libreoffice profile file");
                Files.copy(in, target, StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (IOException e) {
            LOGGER.error("Error copying resource to temporary file: {}", (Object)e.getMessage());
        }
    }
}

