/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.transform.libreoffice.transformers;

import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.StringTokenizer;
import org.alfresco.transform.libreoffice.transformers.JodConverter;
import org.artofsolving.jodconverter.office.DefaultOfficeManagerConfiguration;
import org.artofsolving.jodconverter.office.OfficeException;
import org.artofsolving.jodconverter.office.OfficeManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JodConverterSharedInstance
implements JodConverter {
    private static final Logger logger = LoggerFactory.getLogger(JodConverterSharedInstance.class);
    private OfficeManager officeManager;
    private boolean isAvailable = false;
    private Integer maxTasksPerProcess;
    private String url;
    private String officeHome;
    private int[] portNumbers;
    private Long taskExecutionTimeout;
    private Long taskQueueTimeout;
    private File templateProfileDir;
    private Boolean enabled;
    private Long connectTimeout;
    private String deprecatedOooExe;
    private Boolean deprecatedOooEnabled;
    private int[] deprecatedOooPortNumbers;

    void setMaxTasksPerProcess(String maxTasksPerProcess) {
        Long l = this.parseStringForLong(maxTasksPerProcess.trim());
        if (l != null) {
            this.maxTasksPerProcess = l.intValue();
        }
    }

    public void setUrl(String url) {
        this.url = url;
    }

    void setOfficeHome(String officeHome) {
        this.officeHome = officeHome == null ? "" : officeHome.trim();
    }

    public void setDeprecatedOooExe(String deprecatedOooExe) {
        this.deprecatedOooExe = deprecatedOooExe == null ? "" : deprecatedOooExe.trim();
    }

    void setPortNumbers(String s) {
        this.portNumbers = this.parsePortNumbers(s, "jodconverter");
    }

    public void setDeprecatedOooPort(String s) {
        this.deprecatedOooPortNumbers = this.parsePortNumbers(s, "ooo");
    }

    private int[] parsePortNumbers(String s, String sys) {
        int[] portNumbers = null;
        String string = s = s == null ? null : s.trim();
        if (s != null && !s.isEmpty()) {
            StringTokenizer tokenizer = new StringTokenizer(s, ",");
            int tokenCount = tokenizer.countTokens();
            portNumbers = new int[tokenCount];
            int i = 0;
            while (tokenizer.hasMoreTokens()) {
                try {
                    portNumbers[i] = Integer.parseInt(tokenizer.nextToken().trim());
                }
                catch (NumberFormatException e) {
                    logger.error("Unparseable value for property '{}.portNumbers': {}", (Object)sys, (Object)s);
                }
                ++i;
            }
        }
        return portNumbers;
    }

    void setTaskExecutionTimeout(String taskExecutionTimeout) {
        this.taskExecutionTimeout = this.parseStringForLong(taskExecutionTimeout.trim());
    }

    void setTemplateProfileDir(String templateProfileDir) {
        if (templateProfileDir == null || templateProfileDir.trim().length() == 0) {
            this.templateProfileDir = null;
        } else {
            File tmp = new File(templateProfileDir);
            if (!tmp.isDirectory()) {
                throw new RuntimeException("OpenOffice template profile directory " + templateProfileDir + " does not exist.");
            }
            this.templateProfileDir = tmp;
        }
    }

    void setTaskQueueTimeout(String taskQueueTimeout) {
        this.taskQueueTimeout = this.parseStringForLong(taskQueueTimeout.trim());
    }

    void setConnectTimeout(String connectTimeout) {
        this.connectTimeout = this.parseStringForLong(connectTimeout.trim());
    }

    void setEnabled(String enabledStr) {
        this.enabled = this.parseEnabled(enabledStr);
        if (!(this.enabled.booleanValue() || this.deprecatedOooEnabled != null && this.deprecatedOooEnabled.booleanValue())) {
            this.isAvailable = false;
        }
    }

    public void setDeprecatedOooEnabled(String deprecatedOooEnabled) {
        this.deprecatedOooEnabled = this.parseEnabled(deprecatedOooEnabled);
    }

    private Boolean parseEnabled(String enabled) {
        enabled = enabled == null ? "" : enabled.trim();
        return Boolean.parseBoolean(enabled);
    }

    private String getOfficeHome() {
        File grandparent;
        File oooExe;
        File parent;
        String officeHome = this.officeHome;
        if ((officeHome == null || officeHome.isEmpty()) && this.deprecatedOooExe != null && !this.deprecatedOooExe.isEmpty() && (parent = (oooExe = new File(this.deprecatedOooExe)).getParentFile()) != null && "program".equals(parent.getName()) && (grandparent = parent.getParentFile()) != null) {
            officeHome = grandparent.getPath();
        }
        return officeHome;
    }

    private boolean isEnabled() {
        return this.deprecatedOooEnabled != null && this.deprecatedOooEnabled != false || this.enabled != null && this.enabled != false;
    }

    private int[] getPortNumbers() {
        return (this.enabled == null || this.enabled == false) && this.deprecatedOooEnabled != null && this.deprecatedOooEnabled != false ? this.deprecatedOooPortNumbers : this.portNumbers;
    }

    private Long parseStringForLong(String string) {
        try {
            return Long.parseLong(string);
        }
        catch (NumberFormatException nfe) {
            logger.debug("Cannot parse numerical value from {}", (Object)string);
            return null;
        }
    }

    public boolean isAvailable() {
        return this.isAvailable && (this.officeManager != null || this.url != null && !this.url.isEmpty());
    }

    @PostConstruct
    public void afterPropertiesSet() {
        this.isAvailable = false;
        int[] portNumbers = this.getPortNumbers();
        String officeHome = this.getOfficeHome();
        if (logger.isDebugEnabled()) {
            logger.debug("JodConverter settings (null settings will be replaced by jodconverter defaults):");
            logger.debug("  officeHome = {}", (Object)officeHome);
            logger.debug("  enabled = {}", (Object)this.isEnabled());
            logger.debug("  portNumbers = {}", (Object)this.getString(portNumbers));
            logger.debug("    ooo.exe = {}", (Object)this.deprecatedOooExe);
            logger.debug("    ooo.enabled = {}", (Object)this.deprecatedOooEnabled);
            logger.debug("    ooo.port = {}", (Object)this.getString(this.deprecatedOooPortNumbers));
            logger.debug("    jodConverter.enabled = {}", (Object)this.enabled);
            logger.debug("    jodconverter.portNumbers = {}", (Object)this.getString(this.portNumbers));
            logger.debug("  jodconverter.officeHome = {}", (Object)this.officeHome);
            logger.debug("  jodconverter.maxTasksPerProcess = {}", (Object)this.maxTasksPerProcess);
            logger.debug("  jodconverter.taskExecutionTimeout = {}", (Object)this.taskExecutionTimeout);
            logger.debug("  jodconverter.taskQueueTimeout = {}", (Object)this.taskQueueTimeout);
            logger.debug("  jodconverter.connectTimeout = {}", (Object)this.connectTimeout);
            logger.debug("  jodconverter.url = {}", (Object)this.url);
        }
        if (!this.isEnabled()) {
            return;
        }
        if (this.url == null || this.url.isEmpty()) {
            this.logAllSofficeFilesUnderOfficeHome();
            try {
                DefaultOfficeManagerConfiguration defaultOfficeMgrConfig = new DefaultOfficeManagerConfiguration();
                if (this.maxTasksPerProcess != null && this.maxTasksPerProcess > 0) {
                    defaultOfficeMgrConfig.setMaxTasksPerProcess(this.maxTasksPerProcess.intValue());
                }
                if (officeHome != null && officeHome.length() != 0) {
                    defaultOfficeMgrConfig.setOfficeHome(officeHome);
                }
                if (portNumbers != null && portNumbers.length != 0) {
                    defaultOfficeMgrConfig.setPortNumbers(portNumbers);
                }
                if (this.taskExecutionTimeout != null && this.taskExecutionTimeout > 0L) {
                    defaultOfficeMgrConfig.setTaskExecutionTimeout(this.taskExecutionTimeout.longValue());
                }
                if (this.taskQueueTimeout != null && this.taskQueueTimeout > 0L) {
                    defaultOfficeMgrConfig.setTaskQueueTimeout(this.taskQueueTimeout.longValue());
                }
                if (this.templateProfileDir != null) {
                    defaultOfficeMgrConfig.setTemplateProfileDir(this.templateProfileDir);
                }
                if (this.connectTimeout != null) {
                    defaultOfficeMgrConfig.setConnectTimeout(this.connectTimeout.longValue());
                }
                this.officeManager = defaultOfficeMgrConfig.buildOfficeManager();
                this.officeManager.start();
            }
            catch (IllegalStateException e) {
                logger.error("Unable to pre-initialise JodConverter library. The following error is shown for informational purposes only.", (Throwable)e);
                return;
            }
            catch (OfficeException e) {
                logger.error("Unable to start JodConverter library. The following error is shown for informational purposes only.", (Throwable)e);
            }
            catch (Exception e) {
                logger.error("Unexpected error in configuring or starting the JodConverter library.The following error is shown for informational purposes only.", (Throwable)e);
                return;
            }
        }
        this.isAvailable = true;
    }

    private String getString(int[] portNumbers) {
        StringBuilder portInfo = new StringBuilder();
        if (portNumbers != null) {
            for (int i = 0; i < portNumbers.length; ++i) {
                portInfo.append(portNumbers[i]);
                if (i >= portNumbers.length - 1) continue;
                portInfo.append(", ");
            }
        }
        return portInfo.toString();
    }

    private void logAllSofficeFilesUnderOfficeHome() {
        if (!logger.isDebugEnabled()) {
            return;
        }
        String officeHome = this.getOfficeHome();
        File requestedOfficeHome = new File(officeHome);
        logger.debug("Some information on soffice* files and their permissions");
        this.logFileInfo(requestedOfficeHome);
        for (File f : this.findSofficePrograms(requestedOfficeHome, new ArrayList(), 2)) {
            this.logFileInfo(f);
        }
    }

    private List<File> findSofficePrograms(File searchRoot, List<File> results, int maxRecursionDepth) {
        return this.findSofficePrograms(searchRoot, results, 0, maxRecursionDepth);
    }

    private List<File> findSofficePrograms(File searchRoot, List<File> results, int currentRecursionDepth, int maxRecursionDepth) {
        if (currentRecursionDepth >= maxRecursionDepth) {
            return results;
        }
        File[] matchingFiles = searchRoot.listFiles((dir, name) -> name.startsWith("soffice"));
        if (matchingFiles == null) {
            return results;
        }
        results.addAll(Arrays.asList(matchingFiles));
        File[] matchingDirectories = searchRoot.listFiles(File::isDirectory);
        if (matchingDirectories == null) {
            return results;
        }
        for (File dir2 : Objects.requireNonNull(matchingDirectories)) {
            this.findSofficePrograms(dir2, results, currentRecursionDepth + 1, maxRecursionDepth);
        }
        return results;
    }

    private void logFileInfo(File f) {
        if (!logger.isDebugEnabled()) {
            return;
        }
        StringBuilder msg = new StringBuilder();
        msg.append(f).append(" ");
        if (f.exists() && f.canRead()) {
            msg.append("(").append(f.isDirectory() ? "d" : "-").append(f.canRead() ? "r" : "-").append(f.canWrite() ? "w" : "-").append(f.canExecute() ? "x" : "-").append(")");
        } else {
            msg.append("does not exist");
        }
        logger.debug(msg.toString());
    }

    @PreDestroy
    public void destroy() {
        this.isAvailable = false;
        if (this.officeManager != null) {
            this.officeManager.stop();
        }
    }

    public OfficeManager getOfficeManager() {
        return this.officeManager;
    }
}

