/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.transform.imagemagick;

import com.google.common.collect.ImmutableList;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.alfresco.transform.base.clients.FileInfo;
import org.alfresco.transform.base.clients.HttpClient;
import org.apache.commons.lang3.tuple.Pair;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;

public class ImageMagickTransformationIT {
    private static final Logger logger = LoggerFactory.getLogger(ImageMagickTransformationIT.class);
    private static final String ENGINE_URL = "http://localhost:8090";
    private static final List<Pair<String, String>> targetExtensions = new ImmutableList.Builder().add((Object)Pair.of((Object)"3fr", (Object)"image/x-raw-hasselblad")).add((Object)Pair.of((Object)"arw", (Object)"image/x-raw-sony")).add((Object)Pair.of((Object)"bmp", (Object)"image/bmp")).add((Object)Pair.of((Object)"cgm", (Object)"image/cgm")).add((Object)Pair.of((Object)"cr2", (Object)"image/x-raw-canon")).add((Object)Pair.of((Object)"dng", (Object)"image/x-raw-adobe")).add((Object)Pair.of((Object)"gif", (Object)"image/gif")).add((Object)Pair.of((Object)"ief", (Object)"image/ief")).add((Object)Pair.of((Object)"jp2", (Object)"image/jp2")).add((Object)Pair.of((Object)"jpg", (Object)"image/jpeg")).add((Object)Pair.of((Object)"k25", (Object)"image/x-raw-kodak")).add((Object)Pair.of((Object)"mrw", (Object)"image/x-raw-minolta")).add((Object)Pair.of((Object)"nef", (Object)"image/x-raw-nikon")).add((Object)Pair.of((Object)"orf", (Object)"image/x-raw-olympus")).add((Object)Pair.of((Object)"pbm", (Object)"image/x-portable-bitmap")).add((Object)Pair.of((Object)"pef", (Object)"image/x-raw-pentax")).add((Object)Pair.of((Object)"pgm", (Object)"image/x-portable-graymap")).add((Object)Pair.of((Object)"png", (Object)"image/png")).add((Object)Pair.of((Object)"pnm", (Object)"image/x-portable-anymap")).add((Object)Pair.of((Object)"ppj", (Object)"image/vnd.adobe.premiere")).add((Object)Pair.of((Object)"ppm", (Object)"image/x-portable-pixmap")).add((Object)Pair.of((Object)"r3d", (Object)"image/x-raw-red")).add((Object)Pair.of((Object)"raf", (Object)"image/x-raw-fuji")).add((Object)Pair.of((Object)"ras", (Object)"image/x-cmu-raster")).add((Object)Pair.of((Object)"rw2", (Object)"image/x-raw-panasonic")).add((Object)Pair.of((Object)"rwl", (Object)"image/x-raw-leica")).add((Object)Pair.of((Object)"tiff", (Object)"image/tiff")).add((Object)Pair.of((Object)"x3f", (Object)"image/x-raw-sigma")).add((Object)Pair.of((Object)"xbm", (Object)"image/x-xbitmap")).add((Object)Pair.of((Object)"xpm", (Object)"image/x-xpixmap")).add((Object)Pair.of((Object)"xwd", (Object)"image/x-xwindowdump")).build();
    private static final List<Pair<String, String>> targetExtensionsForPSD = new ImmutableList.Builder().add((Object)Pair.of((Object)"x3f", (Object)"image/x-raw-sigma")).add((Object)Pair.of((Object)"tiff", (Object)"image/tiff")).add((Object)Pair.of((Object)"rwl", (Object)"image/x-raw-leica")).add((Object)Pair.of((Object)"rw2", (Object)"image/x-raw-panasonic")).add((Object)Pair.of((Object)"ras", (Object)"image/x-cmu-raster")).add((Object)Pair.of((Object)"raf", (Object)"image/x-raw-fuji")).add((Object)Pair.of((Object)"r3d", (Object)"image/x-raw-red")).add((Object)Pair.of((Object)"psd", (Object)"image/vnd.adobe.photoshop")).add((Object)Pair.of((Object)"ppm", (Object)"image/x-portable-pixmap")).add((Object)Pair.of((Object)"ppj", (Object)"image/vnd.adobe.premiere")).add((Object)Pair.of((Object)"pnm", (Object)"image/x-portable-anymap")).add((Object)Pair.of((Object)"pgm", (Object)"image/x-portable-graymap")).add((Object)Pair.of((Object)"pef", (Object)"image/x-raw-pentax")).add((Object)Pair.of((Object)"pbm", (Object)"image/x-portable-bitmap")).add((Object)Pair.of((Object)"orf", (Object)"image/x-raw-olympus")).add((Object)Pair.of((Object)"nef", (Object)"image/x-raw-nikon")).add((Object)Pair.of((Object)"mrw", (Object)"image/x-raw-minolta")).add((Object)Pair.of((Object)"k25", (Object)"image/x-raw-kodak")).add((Object)Pair.of((Object)"ief", (Object)"image/ief")).add((Object)Pair.of((Object)"gif", (Object)"image/gif")).add((Object)Pair.of((Object)"dng", (Object)"image/x-raw-adobe")).add((Object)Pair.of((Object)"cr2", (Object)"image/x-raw-canon")).add((Object)Pair.of((Object)"arw", (Object)"image/x-raw-sony")).add((Object)Pair.of((Object)"3fr", (Object)"image/x-raw-hasselblad")).build();
    private static final Map<String, FileInfo> TEST_FILES = Stream.of(FileInfo.testFile((String)"image/bmp", (String)"bmp", (String)"quick.bmp"), FileInfo.testFile((String)"image/gif", (String)"gif", (String)"quick.gif"), FileInfo.testFile((String)"image/jpeg", (String)"jpg", (String)"quick.jpg"), FileInfo.testFile((String)"image/x-portable-bitmap", (String)"pbm", (String)"quick.pbm"), FileInfo.testFile((String)"image/x-portable-graymap", (String)"pgm", (String)"quick.pgm"), FileInfo.testFile((String)"image/png", (String)"png", (String)"quick.png"), FileInfo.testFile((String)"image/x-portable-anymap", (String)"pnm", (String)"quick.pnm"), FileInfo.testFile((String)"image/x-portable-pixmap", (String)"ppm", (String)"quick.ppm"), FileInfo.testFile((String)"image/x-xbitmap", (String)"xbm", (String)"quick.xbm"), FileInfo.testFile((String)"image/x-xpixmap", (String)"xpm", (String)"quick.xpm"), FileInfo.testFile((String)"image/vnd.adobe.photoshop", (String)"psd", (String)"quick.psd"), FileInfo.testFile((String)"image/tiff", (String)"tiff", (String)"quick.tiff"), FileInfo.testFile((String)"image/x-xwindowdump", (String)"xwd", (String)"quick.xwd")).collect(Collectors.toMap(FileInfo::getPath, Function.identity()));

    public static Stream<Pair<FileInfo, Pair<String, String>>> engineTransformations() {
        return Stream.of(ImageMagickTransformationIT.allTargets("quick.bmp", targetExtensions), ImageMagickTransformationIT.allTargets("quick.gif", targetExtensions), ImageMagickTransformationIT.allTargets("quick.jpg", targetExtensions), ImageMagickTransformationIT.allTargets("quick.pbm", targetExtensions), ImageMagickTransformationIT.allTargets("quick.pgm", targetExtensions), ImageMagickTransformationIT.allTargets("quick.png", targetExtensions), ImageMagickTransformationIT.allTargets("quick.pnm", targetExtensions), ImageMagickTransformationIT.allTargets("quick.ppm", targetExtensions), ImageMagickTransformationIT.allTargets("quick.psd", targetExtensionsForPSD), ImageMagickTransformationIT.allTargets("quick.tiff", targetExtensions), ImageMagickTransformationIT.allTargets("quick.xbm", targetExtensions), ImageMagickTransformationIT.allTargets("quick.xpm", targetExtensions), ImageMagickTransformationIT.allTargets("quick.xwd", targetExtensions)).flatMap(Function.identity());
    }

    @ParameterizedTest
    @MethodSource(value={"engineTransformations"})
    public void testTransformation(Pair<FileInfo, Pair<String, String>> entry) {
        String sourceFile = ((FileInfo)entry.getLeft()).getPath();
        String targetExtension = (String)((Pair)entry.getRight()).getLeft();
        String sourceMimetype = ((FileInfo)entry.getLeft()).getMimeType();
        String targetMimetype = (String)((Pair)entry.getRight()).getRight();
        String descriptor = MessageFormat.format("Transform ({0}, {1} -> {2}, {3})", sourceFile, sourceMimetype, targetMimetype, targetExtension);
        try {
            ResponseEntity response = HttpClient.sendTRequest((String)ENGINE_URL, (String)sourceFile, (String)sourceMimetype, (String)targetMimetype, (String)targetExtension, Collections.emptyMap());
            Assertions.assertEquals((Object)HttpStatus.OK, (Object)response.getStatusCode(), (String)descriptor);
        }
        catch (Exception e) {
            Assertions.fail((String)(descriptor + " exception: " + e.getMessage()));
        }
    }

    private static Stream<Pair<FileInfo, Pair<String, String>>> allTargets(String sourceFile, List<Pair<String, String>> targetExtensionsList) {
        return targetExtensionsList.stream().map(k -> Pair.of((Object)TEST_FILES.get(sourceFile), (Object)k));
    }
}

