/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.transform.imagemagick.transformers.page;

import java.util.List;
import java.util.Map;
import org.alfresco.transform.base.util.Util;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class PageRangeFactory {
    private final List<String> singlePageFormats = List.of("image/bmp", "image/jp2", "image/jpeg", "image/png", "image/x-xwindowdump");

    public String create(String sourceMimetype, String targetMimetype, Map<String, String> transformOptions) {
        String startPageString = transformOptions.get("startPage");
        String endPageString = transformOptions.get("endPage");
        if (!this.singlePageFormats.contains(sourceMimetype) && this.singlePageFormats.contains(targetMimetype)) {
            if (StringUtils.isEmpty((CharSequence)startPageString)) {
                startPageString = "0";
            }
            if (StringUtils.isEmpty((CharSequence)endPageString)) {
                endPageString = startPageString;
            }
        }
        Integer startPage = Util.stringToInteger((String)startPageString);
        Integer endPage = Util.stringToInteger((String)endPageString);
        return this.calculatePageRange(startPage, endPage);
    }

    private String calculatePageRange(Integer startPage, Integer endPage) {
        return startPage == null ? (endPage == null ? "" : "[" + endPage + "]") : (endPage == null || startPage.equals(endPage) ? "[" + startPage + "]" : "[" + startPage + "-" + endPage + "]");
    }
}

